/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.biz.service.file;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.BigExcelWriter;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.StyleSet;
import com.geoway.base.service.BaseService;
import com.geoway.base.support.QueryParamUtil;
import com.geoway.base.support.QuerySpecification;
import com.geoway.onemap.biz.dao.file.FileRepository;
import com.geoway.onemap.biz.domain.file.FileData;
import com.geoway.onemap.core.dao.SysConfigRepository;
import com.geoway.onemap.core.domain.SysConfig;
import com.geoway.onemap.core.domain.system.SysUser;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.pdfbox.io.IOUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(rollbackFor={Exception.class})
public class FileService
extends BaseService {
    @Value(value="${project.uploadDir}")
    protected String workDir;
    @Autowired
    SysConfigRepository sysConfigDao;
    @Autowired
    FileRepository fileDao;
    private Logger logger = Logger.getLogger(FileService.class);

    public Page<FileData> queryByFilter(String filterParam, String sortParam, int start, int limit) throws Exception {
        Page pager = this.fileDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        return pager;
    }

    public List<FileData> queryByFilter(String filterParam, String sortParam) throws Exception {
        ArrayList<FileData> list = new ArrayList();
        list = this.fileDao.findAll((Specification)new QuerySpecification(filterParam), QueryParamUtil.parseSortParams((String)sortParam));
        return list;
    }

    public List<FileData> queryByFilter(String filterParam, String sortParam, String name) throws Exception {
        List<Object> list = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)name)) {
            FileData fileData = (FileData)this.fileDao.findOne((Specification)new QuerySpecification("Q_level_N_EQ=1;Q_name_S_EQ=" + name)).get();
            if (ObjectUtil.isNotNull((Object)fileData) && ObjectUtil.isNotNull((Object)fileData.getId())) {
                list = this.queryAllDataById(fileData.getId(), filterParam, sortParam);
            }
        } else {
            list = this.fileDao.findAll((Specification)new QuerySpecification(filterParam), QueryParamUtil.parseSortParams((String)sortParam));
        }
        return list;
    }

    public List<FileData> queryTreeByFilter(String filterParam, String sortParam) {
        List results = this.fileDao.findAll((Specification)new QuerySpecification(filterParam), QueryParamUtil.parseSortParams((String)sortParam));
        return this.constructCatalogTree(results);
    }

    public List<FileData> queryTreeByFilter(String filterParam, String sortParam, String name) {
        List<Object> results = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)name)) {
            FileData fileData = (FileData)this.fileDao.findOne((Specification)new QuerySpecification("Q_level_N_EQ=1;Q_name_S_EQ=" + name)).get();
            if (ObjectUtil.isNotNull((Object)fileData) && ObjectUtil.isNotNull((Object)fileData.getId())) {
                results = this.queryAllDataById(fileData.getId(), filterParam, sortParam);
            }
        } else {
            results = this.fileDao.findAll((Specification)new QuerySpecification(filterParam), QueryParamUtil.parseSortParams((String)sortParam));
        }
        return this.constructCatalogTree(results);
    }

    private List<FileData> constructCatalogTree(List<FileData> catalogs) {
        int minLevel = 999999;
        HashMap mapParam = new HashMap();
        for (FileData catalog : catalogs) {
            String key = catalog.getPid();
            if (!StringUtils.isEmpty((String)key) && !key.equals("-1")) {
                if (mapParam.containsKey(key)) {
                    ((List)mapParam.get(key)).add(catalog);
                } else {
                    ArrayList<FileData> initCatalog = new ArrayList<FileData>();
                    initCatalog.add(catalog);
                    mapParam.put(key, initCatalog);
                }
            }
            if (catalog.getLevel() >= minLevel) continue;
            minLevel = catalog.getLevel();
        }
        for (String key : mapParam.keySet()) {
            List myCatalogs = (List)mapParam.get(key);
            Collections.sort(myCatalogs);
        }
        ArrayList<FileData> results = new ArrayList<FileData>();
        for (FileData catalog : catalogs) {
            String key = catalog.getId();
            if (StringUtils.isEmpty((String)key) || !mapParam.containsKey(key)) continue;
            catalog.setChildren((List)mapParam.get(key));
        }
        for (FileData catalog : catalogs) {
            if (catalog.getLevel() != minLevel) continue;
            results.add(catalog);
        }
        return results;
    }

    public List<FileData> queryAll(String filterParam) throws Exception {
        List results = this.fileDao.findAll((Specification)new QuerySpecification(filterParam));
        return this.constructFileTree(results);
    }

    private List<FileData> constructFileTree(List<FileData> lists) {
        int minLevel = 999999;
        HashMap mapParam = new HashMap();
        for (FileData file : lists) {
            String key = file.getPid();
            if (!StringUtils.isEmpty((String)key) && !key.equals("-1")) {
                if (mapParam.containsKey(key)) {
                    ((List)mapParam.get(key)).add(file);
                } else {
                    ArrayList<FileData> initFile = new ArrayList<FileData>();
                    initFile.add(file);
                    mapParam.put(key, initFile);
                }
            }
            if (file.getLevel() >= minLevel) continue;
            minLevel = file.getLevel();
        }
        ArrayList<FileData> results = new ArrayList<FileData>();
        for (FileData file : lists) {
            String key = file.getId();
            if (StringUtils.isEmpty((String)key) || !mapParam.containsKey(key)) continue;
            file.setChildren((List)mapParam.get(key));
        }
        for (FileData file : lists) {
            if (file.getLevel() != minLevel) continue;
            results.add(file);
        }
        return results;
    }

    public FileData addFile(FileData fileData, SysUser user) throws Exception {
        long nameCount;
        if (ObjectUtil.isNull((Object)fileData.getPid()) || "-1".equals(fileData.getPid())) {
            Integer maxSort = this.fileDao.queryMaxSortByParentId(fileData.getPid());
            if (ObjectUtil.isEmpty((Object)maxSort) || maxSort <= 0) {
                maxSort = 0;
            }
            fileData.setSort(maxSort + 1);
        }
        if (ObjectUtil.isNull((Object)fileData.getName())) {
            String message = "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
            throw new Exception(message);
        }
        String filterParam = "Q_name_S_EQ=" + fileData.getName();
        if (StringUtils.isNotBlank((String)fileData.getPid())) {
            filterParam = filterParam + ";Q_pid_S_EQ=" + fileData.getPid();
        }
        if (ObjectUtil.isNotEmpty((Object)fileData.getLevel())) {
            filterParam = filterParam + ";Q_level_N_EQ=" + fileData.getLevel();
        }
        if (ObjectUtil.isNotEmpty((Object)fileData.getFiletype())) {
            filterParam = filterParam + ";Q_filetype_N_EQ=" + fileData.getFiletype();
        }
        if ((nameCount = this.fileDao.count((Specification)new QuerySpecification(filterParam))) > 0L) {
            String message = "\u540c\u4e00\u7ea7\u76ee\u5f55\u4e0b\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\uff0c\u540d\u79f0\u3010" + fileData.getName() + "\u3011\u5df2\u5b58\u5728!";
            throw new Exception(message);
        }
        fileData.setUsername(user.getUsername());
        fileData.setUserid(user.getId());
        return (FileData)this.fileDao.save(fileData);
    }

    public void deleteOne(String id) throws Exception {
        List<FileData> mapList = this.fileDao.queryFileDataByByParentId(id);
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> absoluteUrls = new ArrayList<String>();
        for (FileData map : mapList) {
            ids.add(ObjectUtil.isNotNull((Object)map.getId()) ? map.getId() : "null");
            absoluteUrls.add(ObjectUtil.isNotNull((Object)map.getAbsoluteurl()) ? map.getAbsoluteurl() : "null");
            absoluteUrls.add(ObjectUtil.isNotNull((Object)map.getAbsoluteimgurl()) ? map.getAbsoluteimgurl() : "null");
        }
        if (ObjectUtil.isNull(ids)) {
            return;
        }
        this.fileDao.deleteFileDataByIds(ids);
        if (ObjectUtil.isNotNull(absoluteUrls)) {
            for (String absoluteurl : absoluteUrls) {
                if (!ObjectUtil.isNotNull((Object)absoluteurl) || "null".equals(absoluteurl)) continue;
                this.deleteFile(absoluteurl);
            }
        }
    }

    public FileData findOne(String id) {
        FileData fileData = (FileData)this.fileDao.findById(id).get();
        return fileData;
    }

    public void saveFileData(FileData fileData) {
        this.fileDao.save(fileData);
    }

    public void deleteFile(String absoluteurl) throws Exception {
        if (ObjectUtil.isNull((Object)absoluteurl)) {
            String message = "\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!";
            throw new Exception(message);
        }
        File file = new File(absoluteurl);
        if (!file.exists()) {
            String message = "\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!";
            throw new Exception(message);
        }
        file.delete();
    }

    public long count(String filterParam) {
        return this.fileDao.count((Specification)new QuerySpecification(filterParam));
    }

    public FileData findOneImage(String id) {
        return (FileData)this.fileDao.findById(id).get();
    }

    public byte[] getFile(FileData file) {
        byte[] fileStream = null;
        try {
            String path = file.getUrl();
            File file1 = new File(path);
            FileInputStream input = new FileInputStream(file1);
            fileStream = IOUtils.toByteArray((InputStream)input);
            ((InputStream)input).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileStream;
    }

    public List<FileData> queryAllDataById(String id, String filterParam, String sortParam) {
        List<FileData> fileDataList = new ArrayList<FileData>();
        List<String> ids = this.fileDao.queryIdsByParentId(id);
        if (ids == null || ids.size() <= 0) {
            return fileDataList;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(filterParam);
        if (ids.size() == 1) {
            stringBuffer.append(";Q_id_S_EQ=" + ids.get(0));
        } else if (ids.size() > 1) {
            for (int i = 0; i < ids.size(); ++i) {
                if (i == 0) {
                    stringBuffer.append(";Q_id_S_IN=" + ids.get(i));
                }
                stringBuffer.append("," + ids.get(i));
            }
        }
        fileDataList = this.fileDao.findAll((Specification)new QuerySpecification(stringBuffer.toString()), QueryParamUtil.parseSortParams((String)sortParam));
        return fileDataList;
    }

    public Page<FileData> queryAllDataById(String id, String filterParam, String sortParam, int start, int limit) {
        List<String> ids = this.fileDao.queryIdsByParentId(id);
        if (ids == null || ids.size() <= 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(filterParam);
        if (ids.size() == 1) {
            stringBuffer.append(";Q_id_S_EQ=" + ids.get(0));
        } else if (ids.size() > 1) {
            for (int i = 0; i < ids.size(); ++i) {
                if (i == 0) {
                    stringBuffer.append(";Q_id_S_IN=" + ids.get(i));
                }
                stringBuffer.append("," + ids.get(i));
            }
        }
        Page file = this.fileDao.findAll((Specification)new QuerySpecification(stringBuffer.toString()), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        return file;
    }

    public String querySysConfig(String key) {
        SysConfig config = this.sysConfigDao.queryByKey(key);
        if (config == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)config.getValue())) {
            return "";
        }
        return config.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(MultipartFile file, FileData fileData) throws Exception {
        String sourceFileName = file.getOriginalFilename();
        String uploadFileName = ObjectUtil.isNotNull((Object)fileData.getName()) ? fileData.getName() : sourceFileName.substring(0, sourceFileName.lastIndexOf("."));
        String uploadFileType = sourceFileName.substring(sourceFileName.lastIndexOf("."));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sysConfig = new StringBuffer();
        sysConfig.append(this.querySysConfig("uploadFile-dir") + File.separator + "fileResource");
        File file1 = new File(sysConfig.toString());
        if (!file1.exists()) {
            file1.mkdir();
        }
        sysConfig.append(File.separator + sdf.format(new Date()));
        file1 = new File(sysConfig.toString());
        if (!file1.exists()) {
            file1.mkdir();
        }
        String tempFileName = sysConfig.append(File.separator + uploadFileName + uploadFileType).toString();
        File uploadFileSave = new File(tempFileName);
        FileInputStream in = (FileInputStream)file.getInputStream();
        FileOutputStream out = new FileOutputStream(uploadFileSave);
        try {
            byte[] buffer = new byte[0x100000];
            int len = 0;
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            in.close();
            out.close();
        }
        return uploadFileSave.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(MultipartFile file, String fileName) throws Exception {
        String sourceFileName = file.getOriginalFilename();
        String uploadFileName = ObjectUtil.isNotNull((Object)fileName) ? fileName : sourceFileName.substring(0, sourceFileName.lastIndexOf("."));
        String uploadFileType = sourceFileName.substring(sourceFileName.lastIndexOf("."));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sysConfig = new StringBuffer();
        sysConfig.append(this.querySysConfig("uploadFile-dir") + File.separator + "fileResource");
        File file1 = new File(sysConfig.toString());
        if (!file1.exists()) {
            file1.mkdir();
        }
        sysConfig.append(File.separator + sdf.format(new Date()));
        file1 = new File(sysConfig.toString());
        if (!file1.exists()) {
            file1.mkdir();
        }
        String tempFileName = sysConfig.append(File.separator + uploadFileName + uploadFileType).toString();
        File uploadFileSave = new File(tempFileName);
        InputStream in = file.getInputStream();
        FileOutputStream out = new FileOutputStream(uploadFileSave);
        try {
            byte[] buffer = new byte[0x100000];
            int len = 0;
            while ((len = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            in.close();
            ((OutputStream)out).close();
        }
        return uploadFileSave.getAbsolutePath();
    }

    public void exportExcel(HttpServletResponse response, List<Map<String, Object>> mapList, String[] templateTitleArray, String[] templateNameArray) throws Exception {
        if (mapList == null || mapList.size() <= 0) {
            this.logger.error((Object)(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5b98\uff01"));
            throw new IllegalAccessException("\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5b98\uff01");
        }
        BigExcelWriter writer = ExcelUtil.getBigWriter();
        for (int i = 0; i < templateTitleArray.length; ++i) {
            writer.addHeaderAlias(templateTitleArray[i], templateNameArray[i]);
        }
        StyleSet style = writer.getStyleSet();
        CellStyle headCellStyle = style.getHeadCellStyle();
        Font font = writer.createFont();
        font.setBold(true);
        font.setFontHeightInPoints((short)12);
        headCellStyle.setFont(font);
        writer.setColumnWidth(-1, 20);
        writer.setDefaultRowHeight(20);
        writer.merge(mapList.size() - 1, (Object)"\u5728\u7ebf\u67e5\u8be2\u5bfc\u51fa\u7ed3\u679c");
        writer.write(mapList, true);
        writer.setOnlyAlias(true);
        String fileName = "\u5728\u7ebf\u67e5\u8be2\u5bfc\u51fa\u7ed3\u679c\uff1a" + mapList.size() + "\u6761";
        ServletOutputStream out = null;
        try {
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;Filename=" + URLEncoder.encode(fileName, "UTF-8") + ".xlsx");
            response.setHeader("Content-Transfer-Encoding", "binary");
            out = response.getOutputStream();
            writer.flush((OutputStream)out, true);
            System.out.println("\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "######\u5bfc\u51fa\uff0cExcel\u5f02\u5e38\uff1a" + e.getMessage()));
                throw new IllegalAccessException("######\u5bfc\u51fa\uff0cExcel\u5f02\u5e38\uff1a" + e.getMessage().substring(0, e.getMessage().length() - 1));
            }
            catch (Throwable throwable) {
                writer.close();
                IoUtil.close(out);
                throw throwable;
            }
        }
        writer.close();
        IoUtil.close((Closeable)out);
    }
}

