/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.service;

import com.geoway.base.support.QueryParamUtil;
import com.geoway.base.support.QuerySpecification;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.stxf.service.GtyService;
import com.geoway.zhgd.dao.IProjectRcjgVoDao;
import com.geoway.zhgd.dao.ProjectGdbhCbbcgdZbkHjDao;
import com.geoway.zhgd.domain.ProjectGdbhCbbcgdZbkHj;
import com.geoway.zhgd.domain.ProjectRcjgVo;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectGdbhCbbcgdZbkHjService {
    @Autowired
    private ProjectGdbhCbbcgdZbkHjDao projectGdbhCbbcgdZbkHjDao;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private GtyService gtyService;
    @Autowired
    private IProjectRcjgVoDao iProjectRcjgVoDao;
    @Value(value="${project.gty.dir}")
    protected String gtyDir;
    @Autowired
    JdbcTemplate jdbcTemplate;
    private static final String WF_PROJECT = "myProcess_zbhj";
    private static final Map WF_PROJECT_VARIABLES = new HashMap(){
        {
            this.put("check", null);
        }
    };

    public Page<ProjectGdbhCbbcgdZbkHj> getPageList(String filterParam, String sortParam, Integer page, Integer pageSize) {
        return this.projectGdbhCbbcgdZbkHjDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)(page - 1), (int)pageSize, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
    }

    @Transactional(rollbackFor={Exception.class})
    public ProjectGdbhCbbcgdZbkHj addOne(ProjectGdbhCbbcgdZbkHj entity) {
        String id = entity.getId();
        String projectId = entity.getProjectId();
        if (id == null && projectId != null) {
            this.projectGdbhCbbcgdZbkHjDao.deleteByProjectId(projectId);
            entity.setCheckState("p0");
            entity.setCreateTime(new Date());
        }
        entity.setUpdateTime(new Date());
        return (ProjectGdbhCbbcgdZbkHj)this.projectGdbhCbbcgdZbkHjDao.save((Object)entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteOne(String id) {
        this.projectGdbhCbbcgdZbkHjDao.deleteById((Object)id);
    }

    public ProjectGdbhCbbcgdZbkHj queryOne(String id) {
        return this.projectGdbhCbbcgdZbkHjDao.queryById(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public ProjectGdbhCbbcgdZbkHj addHJ(String projectId, String rcjgRecordId) {
        ProjectGdbhCbbcgdZbkHj entity = new ProjectGdbhCbbcgdZbkHj();
        entity.setProjectId(projectId);
        entity.setRcjgRecordId(rcjgRecordId);
        ProjectGdbhCbbcgdZbkHj zbkHj = this.addOne(entity);
        return zbkHj;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<String> startProcess(String businessKey, SysUser user) {
        ArrayList<String> result = new ArrayList<String>();
        for (String bk : businessKey.split(",")) {
            Optional reviewSjOpt = this.projectGdbhCbbcgdZbkHjDao.findById((Object)bk);
            if (!reviewSjOpt.isPresent()) continue;
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(WF_PROJECT, WF_PROJECT_VARIABLES);
            String flowId = processInstance.getId();
            this.runtimeService.updateBusinessKey(flowId, bk);
            ProjectGdbhCbbcgdZbkHj stxfProjectSetup = (ProjectGdbhCbbcgdZbkHj)reviewSjOpt.get();
            stxfProjectSetup.setProcessId(flowId);
            this.projectGdbhCbbcgdZbkHjDao.save((Object)stxfProjectSetup);
            this.claimThenComplete(flowId, null, user.getId(), null);
            result.add(flowId);
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public String claimThenComplete(String flowId, Map variables, String userId, ProjectGdbhCbbcgdZbkHj projectGdbhCbbcgdZbkHj) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(flowId)).active().singleResult();
        this.taskService.claim(task.getId(), userId);
        this.taskService.complete(task.getId(), variables);
        String defKey = task.getTaskDefinitionKey();
        ProjectGdbhCbbcgdZbkHj entity = projectGdbhCbbcgdZbkHj;
        if (entity == null) {
            entity = this.projectGdbhCbbcgdZbkHjDao.findByProcessId(flowId);
        }
        entity.setCheckState(defKey);
        if (variables != null && variables.containsKey("check")) {
            entity.setCheckResult(Integer.valueOf(Integer.parseInt(variables.get("check").toString())));
        }
        this.projectGdbhCbbcgdZbkHjDao.save((Object)entity);
        return defKey;
    }

    public void generateHjGty(String ids) throws SQLException, IOException {
        String[] idArr = ids.split(",");
        ArrayList<Map<String, Object>> XZGDFW = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> PZD = new ArrayList<Map<String, Object>>();
        List hjList = this.projectGdbhCbbcgdZbkHjDao.queryByIds(idArr);
        for (ProjectGdbhCbbcgdZbkHj zbkHj : hjList) {
            String id = zbkHj.getId();
            String projectId = zbkHj.getProjectId();
            ProjectRcjgVo projectRcjgVo = this.iProjectRcjgVoDao.findProjectRcjgVoByProjectVoId(projectId);
            String sql = "";
            if ("lsk".equals(projectRcjgVo.getKlx())) {
                sql = "SELECT\n    t1.xzqdm,    t1.xzqmc,    t1.f_jbxx_xmlx AS xmlx,    t1.f_ys_xmbh AS ys_xmbh,    t1.f_xmmc AS jbxx_xmmc,    t1.f_jbxx_xzqdm AS jbxx_xzqdm,    t1.f_ys_gm_zgm AS ys_gm_zgm,    t1.f_ys_tz_ztz AS ys_tz_ztz,    t1.f_ys_yswh AS ys_yswh,    t1.f_ys_ysrq AS ys_ysrq,    t1.f_gdmj AS bcgdmj,    t1.f_stmj AS jzstmj,    t1.f_ys_cx_jsqg AS tzgzqzldb,    t1.f_ys_cx_jshg AS tzgzhzldb,    st_astext ( t2.f_shape ) AS wkt FROM    tb_project_gdbh_cbbcgd_lsk t1    LEFT JOIN tb_project_gdbh_cbbcgd_lsk_xmfw t2 ON t1.f_id = t2.f_project_id  where t1.f_id = '" + projectId + "'";
            } else if ("fhk".equals(projectRcjgVo.getKlx())) {
                sql = "SELECT     t1.xzqdm,     t1.xzqmc,     t2.f_xmlx AS xmlx,    t1.f_xmzgbm AS xmzgbm,    t2.f_ys_xmbh AS ys_xmbh,     t1.f_name AS jbxx_xmmc,     t1.f_xzqhdm AS jbxx_xzqdm,     t1.f_xzqmc AS jbxx_xzqmc,     t1.f_ys_gm_zgm AS ys_gm_zgm,     t1.f_ys_tz_ztz AS ys_tz_ztz,     t1.f_pf_pfwh AS pf_pfwh,     t1.f_pf_pfrq AS pf_pfrq,     t1.f_ys_yswh AS ys_yswh,     t1.f_ys_ysrq AS ys_ysrq,     t1.f_jgysfzr AS jgysfzr,     t1.f_bcgdmj AS bcgdmj,     t1.f_bcgdpjzldb AS bcgdpjzldb,     t1.f_jzgdmj AS jzgdmj,     t1.f_jzstmj AS jzstmj,     t1.f_tzgzgdmj AS tzgzgdmj,     t1.f_tzgzstmj AS tzgzstmj,     t1.f_tzgzqzldb AS tzgzqzldb,     t1.f_tzgzhzldb AS tzgzhzldb,    st_astext(t2.f_shape) as wkt  FROM tb_project_gdbh_cbbcgd_fhk t1    LEFT JOIN tb_project_gdbh_cbbcgd_fhk_xmfw t2 ON t1.f_id = t2.f_project_id  where t1.f_id = '" + projectId + "'";
            }
            Map xmMap = this.jdbcTemplate.queryForMap(sql);
            Object ys_xmbh = xmMap.get("ys_xmbh");
            Object jbxx_xmmc = xmMap.get("jbxx_xmmc");
            sql = "select f_dikuai_no as dikuai_no, f_pl_name as pl_name, f_dikuai_area as dikuaiarea,f_purpose as purpose, f_map_no as map_no, f_patchtype as patchtype, f_landtype as landtype, f_avggrade1 as avggrade1, f_avggrade2 as avggrade2, f_shap as wkt from tb_project_gdbh_cbbcgd_hjsq_hjdk where f_hj_id = '" + id + "'";
            List xzdks = this.jdbcTemplate.queryForList(sql);
            for (Map xzdk : xzdks) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.putAll(xzdk);
                map.put("klx", "hj");
                map.put("ys_xmbh", (String)ys_xmbh);
                XZGDFW.add(map);
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String time = sdf.format(new Date());
        String dir = this.gtyDir + "/hj/HJ_" + time;
        this.gtyService.generateGty(XZGDFW, PZD, dir);
    }
}

