/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.service;

import com.geoway.base.metadata.constant.FieldTypeEnum;
import com.geoway.base.metadata.dao.IModelMapFieldDao;
import com.geoway.base.metadata.domain.ModelMapField;
import com.geoway.base.metadata.domain.ModelObjectinfo;
import com.geoway.base.metadata.service.ModelFieldsService;
import com.geoway.base.metadata.service.ModelGroupService;
import com.geoway.base.metadata.service.ModelManageService;
import com.geoway.base.metadata.service.ModelObjectinfoService;
import com.geoway.base.support.SnowflakeIdWorker;
import com.geoway.onemap.core.domain.Region;
import com.geoway.onemap.core.service.RegionService;
import com.geoway.onemap.core.support.RegionUtil;
import com.geoway.onemap.stxf.utils.ShpUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ProjectManageService {
    public static Logger logger = LoggerFactory.getLogger(ProjectManageService.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    ModelFieldsService modelFieldsService;
    @Autowired
    ModelGroupService modelGroupService;
    @Autowired
    ModelObjectinfoService modelObjectinfoService;
    @Autowired
    IModelMapFieldDao iModelMapFieldDao;
    @Autowired
    RegionService regionService;
    @Autowired
    ModelManageService modelManageService;

    public void zbk2Lib(String userid, String tableName) {
        boolean valid = this.validateZbk(userid, tableName);
        if (!valid) {
            throw new RuntimeException("\u5b58\u5728\u5f02\u5e38\u6570\u636e\uff0c\u5bfc\u5165\u5931\u8d25");
        }
        String sql = "update " + tableName + " set f_iscountry = 1 where f_userid = '" + userid + "'";
        this.jdbcTemplate.update(sql);
        sql = "update " + tableName + " set f_isprovince = 1 where f_userid = '" + userid + "' and f_type = '\u6302\u94a9\u6307\u6807'";
        this.jdbcTemplate.update(sql);
        sql = "update " + tableName + " set f_userid = NULL,f_state=1 where f_userid = '" + userid + "'";
        this.jdbcTemplate.update(sql);
    }

    public void importShp2Table(String shpPath, String modelid, String geomid) throws Exception {
        SnowflakeIdWorker worker = new SnowflakeIdWorker();
        ModelObjectinfo modelObjectinfo = this.modelObjectinfoService.findById(modelid);
        ModelObjectinfo geomModelObjectinfo = this.modelObjectinfoService.findById(geomid);
        List modelMapFields = this.iModelMapFieldDao.findByModelid(modelid);
        List geomModelMapFields = this.iModelMapFieldDao.findByModelid(geomid);
        List<Map<String, Object>> list = ShpUtils.getShpProperties(shpPath, null);
        List zbkModelMapFields = this.iModelMapFieldDao.findByModelid("4-10");
        if (modelObjectinfo != null && modelMapFields.size() > 0) {
            String sql = null;
            String geomSql = null;
            String zbkSql = null;
            int size = list.size();
            int index = 0;
            int limit = 1000;
            boolean flag = true;
            HashMap regionMap = new HashMap();
            while (flag) {
                int startIndex = index * limit;
                int endIndex = (index + 1) * limit;
                if ((index + 1) * limit > size) {
                    endIndex = size;
                    flag = false;
                }
                List<Map<String, Object>> subList = list.subList(startIndex, endIndex);
                ++index;
                ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
                ArrayList<Object[]> batchGeoArgs = new ArrayList<Object[]>();
                ArrayList<Object[]> zbkBatchArgs = new ArrayList<Object[]>();
                for (Map<String, Object> map : subList) {
                    List geomids;
                    boolean intoZbk = true;
                    String wtlx = map.get("WTLX").toString();
                    String xmfl = map.get("XMFL").toString();
                    if (wtlx == null || xmfl == null || StringUtils.isEmpty((CharSequence)wtlx.toString()) || StringUtils.isEmpty((CharSequence)xmfl.toString())) continue;
                    if (wtlx.toString().equals("\u5220\u9664\u9879\u76ee") || xmfl.toString().equals("\u91cd\u5927\u5de5\u7a0b") || xmfl.toString().equals("\u57fa\u672c\u519c\u7530\u6574\u7406\u9879\u76ee")) {
                        intoZbk = false;
                    }
                    sql = "insert into " + modelObjectinfo.getTableName() + "(";
                    geomSql = "insert into " + geomModelObjectinfo.getTableName() + "(";
                    ArrayList<String> fieldNames = new ArrayList<String>();
                    ArrayList<String> vals = new ArrayList<String>();
                    ArrayList<Object> objs = new ArrayList<Object>();
                    ArrayList<Object> geomObjs = new ArrayList<Object>();
                    zbkSql = "insert into tb_project_gdbh_cbbcgd_zbk (";
                    ArrayList<String> zbkFieldNames = new ArrayList<String>();
                    ArrayList<String> zbkVals = new ArrayList<String>();
                    ArrayList<Object> zbkObjs = new ArrayList<Object>();
                    String zy = "\u6307\u6807\u6765\u6e90\uff1a\u5386\u53f2\u9879\u76ee\u5165\u5e93";
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        List finds2;
                        List finds;
                        if (entry.getKey().equals("the_geom")) {
                            finds = geomModelMapFields.stream().filter(m -> m.getFieldType().equals("geomtry")).collect(Collectors.toList());
                            if (finds.size() <= 0) continue;
                            geomSql = geomSql + ((ModelMapField)finds.get(0)).getMapField() + ",";
                            geomObjs.add(entry.getValue().toString());
                            continue;
                        }
                        finds = modelMapFields.stream().filter(m -> m.getMapField() != null && m.getOrgininalField() != null && m.getOrgininalField().equals(entry.getKey())).collect(Collectors.toList());
                        if (finds.size() > 0) {
                            ModelMapField modelMapField = (ModelMapField)finds.get(0);
                            fieldNames.add(modelMapField.getMapField());
                            if ("timestamp".equalsIgnoreCase(modelMapField.getFieldType())) {
                                vals.add("to_date(?, 'yyyy-MM-dd hh24:mi:ss')");
                            } else if ("date".equalsIgnoreCase(modelMapField.getFieldType())) {
                                vals.add("to_date(?, 'yyyy-MM-dd')");
                            } else {
                                vals.add("?");
                            }
                            Object obj = this.fieldTypeChange(modelMapField, entry.getValue());
                            objs.add(obj);
                            if ("4".equals(modelid)) {
                                if (modelMapField.getMapField().equals("f_ys_ysrq")) {
                                    zbkFieldNames.add("f_date");
                                    zbkVals.add("to_date(?, 'yyyy-MM-dd hh24:mi:ss')");
                                    Object date = this.fieldTypeChange(modelMapField, entry.getValue());
                                    zbkObjs.add(date);
                                }
                                if (modelMapField.getMapField().equals("f_ys_xmbh")) {
                                    zy = zy + "\uff0c\u9879\u76ee\u7f16\u53f7\uff1a" + obj.toString();
                                }
                                if (modelMapField.getMapField().equals("f_xmmc")) {
                                    zy = zy + "\uff0c\u9879\u76ee\u540d\u79f0\uff1a" + obj.toString();
                                }
                            }
                        }
                        if (!"4".equals(modelid) || !intoZbk || (finds2 = zbkModelMapFields.stream().filter(m -> m.getMapField() != null && m.getOrgininalField() != null && m.getOrgininalField().equals(entry.getKey())).collect(Collectors.toList())).size() <= 0) continue;
                        ModelMapField modelMapField = (ModelMapField)finds2.get(0);
                        zbkFieldNames.add(modelMapField.getMapField());
                        if ("timestamp".equalsIgnoreCase(modelMapField.getFieldType())) {
                            zbkVals.add("to_date(?, 'yyyy-MM-dd hh24:mi:ss')");
                        } else if ("date".equalsIgnoreCase(modelMapField.getFieldType())) {
                            zbkVals.add("to_date(?, 'yyyy-MM-dd')");
                        } else {
                            zbkVals.add("?");
                        }
                        Object obj = this.fieldTypeChange(modelMapField, entry.getValue());
                        zbkObjs.add(obj);
                    }
                    List ids = modelMapFields.stream().filter(m -> m.getMapField() != null && m.getFieldType().equals("id")).collect(Collectors.toList());
                    if (ids.size() > 0) {
                        fieldNames.add(((ModelMapField)ids.get(0)).getMapField());
                        vals.add("?");
                        Long id = worker.nextId();
                        objs.add(id);
                        geomObjs.add(id);
                    }
                    sql = sql + StringUtils.join(fieldNames, (String)",");
                    sql = sql + ") values (" + StringUtils.join(vals, (String)",") + ")";
                    batchArgs.add(objs.toArray());
                    List foreignkeys = geomModelMapFields.stream().filter(m -> m.getMapField() != null && m.getFieldType().equals("foreign_key")).collect(Collectors.toList());
                    if (foreignkeys.size() > 0) {
                        geomSql = geomSql + ((ModelMapField)foreignkeys.get(0)).getMapField() + ",";
                    }
                    if ((geomids = geomModelMapFields.stream().filter(m -> m.getMapField() != null && m.getFieldType().equals("id")).collect(Collectors.toList())).size() > 0) {
                        geomSql = geomSql + ((ModelMapField)ids.get(0)).getMapField();
                        geomObjs.add(worker.nextId());
                    }
                    geomSql = geomSql + ") values (st_GeomFromText(?,4490),?,?)";
                    batchGeoArgs.add(geomObjs.toArray());
                    if (!"4".equals(modelid) || !intoZbk) continue;
                    zbkFieldNames.add("f_type");
                    zbkVals.add("?");
                    zbkObjs.add("\u5386\u53f2\u9879\u76ee\u5165\u5e93");
                    zbkFieldNames.add("f_isprovince");
                    zbkVals.add("?");
                    zbkObjs.add(1);
                    zbkFieldNames.add("f_zy");
                    zbkVals.add("?");
                    zbkObjs.add(zy);
                    zbkFieldNames.add("f_state");
                    zbkVals.add("?");
                    zbkObjs.add(1);
                    List zbkids = zbkModelMapFields.stream().filter(m -> m.getMapField() != null && m.getFieldType().equals("id")).collect(Collectors.toList());
                    if (zbkids.size() > 0) {
                        zbkFieldNames.add(((ModelMapField)ids.get(0)).getMapField());
                        zbkVals.add("?");
                        zbkObjs.add(worker.nextId());
                    }
                    zbkSql = zbkSql + StringUtils.join(zbkFieldNames, (String)",");
                    zbkSql = zbkSql + ") values (" + StringUtils.join(zbkVals, (String)",") + ")";
                    zbkBatchArgs.add(zbkObjs.toArray());
                }
                logger.error("\u5f00\u59cb\u63d2\u5165" + startIndex + "\u81f3" + endIndex + "\u6761\u6570\u636e");
                this.jdbcTemplate.batchUpdate(sql, batchArgs);
                this.jdbcTemplate.batchUpdate(geomSql, batchGeoArgs);
                if ("4".equals(modelid)) {
                    this.jdbcTemplate.batchUpdate(zbkSql, zbkBatchArgs);
                }
                logger.error("\u63d2\u5165" + endIndex + "\u6761\u6570\u636e\u7ed3\u675f");
            }
        }
    }

    public void uploadExcel(List<List<Object>> objects, String modelid, String userId) throws Exception {
        if (objects.size() > 0) {
            SnowflakeIdWorker worker = new SnowflakeIdWorker();
            ModelObjectinfo modelObjectinfo = this.modelObjectinfoService.findById(modelid);
            String tablename = modelObjectinfo.getTableName();
            List modelMapFields = this.iModelMapFieldDao.findByModelid(modelid);
            if (modelObjectinfo != null && modelMapFields.size() > 0) {
                String sql = "insert into " + modelObjectinfo.getTableName() + "(";
                List<Object> header = objects.get(0);
                ArrayList<String> fieldNames = new ArrayList<String>();
                ArrayList<String> vals = new ArrayList<String>();
                List ids = modelMapFields.stream().filter(m -> m.getMapField() != null && m.getFieldType().equals("id")).collect(Collectors.toList());
                if (ids.size() > 0) {
                    fieldNames.add(((ModelMapField)ids.get(0)).getMapField());
                    vals.add("?");
                }
                HashMap<Integer, ModelMapField> indexMap = new HashMap<Integer, ModelMapField>();
                HashMap regionMap = new HashMap();
                int dateIndex = -1;
                int xzqmcIndex = -1;
                String maxdate = null;
                for (int i = 0; i < header.size(); ++i) {
                    Object obj = header.get(i);
                    List finds = modelMapFields.stream().filter(m -> m.getMapField() != null && m.getOrgininalField() != null && m.getOrgininalField().equals(obj.toString())).collect(Collectors.toList());
                    if (finds.size() > 0) {
                        ModelMapField modelMapField = (ModelMapField)finds.get(0);
                        indexMap.put(i, modelMapField);
                        fieldNames.add(modelMapField.getMapField());
                        if ("timestamp".equalsIgnoreCase(modelMapField.getFieldType())) {
                            vals.add("to_date(?, 'yyyy-MM-dd hh24:mi:ss')");
                        } else if ("date".equalsIgnoreCase(modelMapField.getFieldType())) {
                            vals.add("to_date(?, 'yyyy-MM-dd')");
                        } else {
                            vals.add("?");
                        }
                    }
                    if (!"10".equals(modelid)) continue;
                    if ("\u65e5\u671f".equals(obj.toString())) {
                        dateIndex = i;
                        String dateSql = "select to_char(max(f_date), 'yyyy/MM/dd') as maxdate from " + tablename + " where f_iscountry = 1";
                        Map map = this.jdbcTemplate.queryForMap(dateSql);
                        if (map.get("maxdate") == null) continue;
                        maxdate = map.get("maxdate").toString();
                        continue;
                    }
                    if (!"\u6307\u6807\u6240\u5728\u884c\u653f\u533a".equals(obj.toString())) continue;
                    xzqmcIndex = i;
                }
                if ("10".equals(modelid)) {
                    fieldNames.add("f_userid");
                    fieldNames.add("f_state");
                    fieldNames.add("xzqdm");
                    vals.add("?");
                    vals.add("?");
                    vals.add("?");
                }
                sql = sql + StringUtils.join(fieldNames, (String)",");
                sql = sql + ") values (" + StringUtils.join(vals, (String)",") + ")";
                ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
                for (int i = 1; i < objects.size(); ++i) {
                    ArrayList<Object> objs = new ArrayList<Object>();
                    objs.add(worker.nextId());
                    List<Object> list = objects.get(i);
                    String state = "0";
                    String xzqdm = "";
                    for (int j = 0; j < list.size(); ++j) {
                        if (indexMap.containsKey(j)) {
                            Object obj = this.fieldTypeChange((ModelMapField)indexMap.get(j), list.get(j));
                            objs.add(obj);
                        }
                        if (!"10".equals(modelid)) continue;
                        if (dateIndex != -1 && dateIndex == j && maxdate != null) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
                            Date maxDate = sdf.parse(maxdate);
                            Date d = null;
                            d = list.get(j) instanceof Date ? (Date)list.get(j) : sdf.parse(list.get(j).toString());
                            state = d.getTime() > maxDate.getTime() ? "0" : "1";
                        }
                        if (xzqmcIndex == -1 || xzqmcIndex != j || !StringUtils.isBlank((CharSequence)(xzqdm = RegionUtil.findCodeByNames((String)list.get(j).toString(), (String)"\\.", (int)3, (JdbcTemplate)this.jdbcTemplate)))) continue;
                        state = "2";
                    }
                    if ("10".equals(modelid)) {
                        objs.add(userId);
                        objs.add(state);
                        objs.add(xzqdm == null ? "" : xzqdm);
                    }
                    batchArgs.add(objs.toArray());
                }
                this.jdbcTemplate.batchUpdate(sql, batchArgs);
            }
        }
    }

    public Object fieldTypeChange(ModelMapField modelMapField, Object object) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Object obj = null;
        if (object != null && StringUtils.isNotBlank((CharSequence)object.toString())) {
            switch (FieldTypeEnum.valueOf((String)modelMapField.getFieldType().toUpperCase())) {
                case VARCHAR: {
                    obj = object.toString();
                    break;
                }
                case INT2: {
                    obj = Integer.parseInt(object.toString());
                    break;
                }
                case INT4: {
                    obj = Integer.parseInt(object.toString());
                    break;
                }
                case NUMERIC: {
                    obj = Double.parseDouble(object.toString());
                    break;
                }
                case TIMESTAMP: {
                    sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    obj = sdf.format(object);
                    break;
                }
                case DATE: {
                    sdf = new SimpleDateFormat("yyyy-MM-dd");
                    obj = sdf.format(object);
                    break;
                }
                case GEOMETRY: {
                    obj = object.toString();
                    break;
                }
                default: {
                    throw new Exception("\u6ca1\u6709\u8be5\u7c7b\u578b\uff1a" + modelMapField.getFieldType());
                }
            }
        }
        return obj;
    }

    private boolean validateZbk(String userid, String tableName) {
        String sql = "select count(1) as count from " + tableName + " where f_state = '\u5f02\u5e38' and f_userid = '" + userid + "'";
        Map map = this.jdbcTemplate.queryForMap(sql);
        return "0".equals(map.get("count").toString());
    }

    @Transactional(rollbackFor={Exception.class})
    public Object[] zbStream(String tableName, String outRegionCode, String inRegionCode, Double gd, Double st, Double cn, String userid) throws Exception {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
        String dateStr = dateFormat.format(date);
        Region outRegion = this.regionService.queryRegionByCode(outRegionCode, null);
        Region inRegion = this.regionService.queryRegionByCode(inRegionCode, null);
        String outName = outRegionCode;
        String inName = inRegionCode;
        if (outRegion != null) {
            outName = outRegion.getName();
        }
        if (inRegion != null) {
            inName = inRegion.getName();
        }
        HashMap<String, Object> outMap = new HashMap<String, Object>();
        outMap.put("f_xzqhdm", outRegionCode);
        outMap.put("f_xzqmc", outName);
        outMap.put("f_date", dateStr);
        outMap.put("f_type", "\u6307\u6807\u8c03\u51fa");
        outMap.put("f_zy", "\u8c03\u51fa\u5230" + inRegionCode);
        outMap.put("f_gdmj", -gd.doubleValue());
        outMap.put("f_stmj", -st.doubleValue());
        outMap.put("f_cnzb", -cn.doubleValue());
        outMap.put("f_state", 1);
        outMap.put("f_iscountry", 0);
        outMap.put("f_isprovince", 1);
        Object outId = this.modelManageService.saveModel(outMap, tableName, userid, false);
        HashMap<String, Object> inMap = new HashMap<String, Object>();
        inMap.put("f_xzqhdm", inRegionCode);
        inMap.put("f_xzqmc", inName);
        inMap.put("f_date", dateStr);
        inMap.put("f_type", "\u6307\u6807\u8c03\u5165");
        inMap.put("f_zy", "\u7531" + outRegionCode + "\u8c03\u5165");
        inMap.put("f_gdmj", gd);
        inMap.put("f_stmj", st);
        inMap.put("f_cnzb", cn);
        inMap.put("f_state", 1);
        inMap.put("f_iscountry", 0);
        inMap.put("f_isprovince", 1);
        Object inId = this.modelManageService.saveModel(inMap, tableName, userid, false);
        return new Object[]{outId, inId};
    }
}

