/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.stxf.service;

import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.stxf.service.GdbhService;
import com.geoway.onemap.stxf.service.ProjectRcjgRecordService;
import com.geoway.zhgd.dao.IBaseFileDao;
import com.geoway.zhgd.dao.IProjectRcjgDao;
import com.geoway.zhgd.dao.IProjectRcjgProcessDao;
import com.geoway.zhgd.dao.IProjectRcjgRecordDao;
import com.geoway.zhgd.dao.IProjectRcjgVoDao;
import com.geoway.zhgd.domain.BaseFile;
import com.geoway.zhgd.domain.ProjectRcjg;
import com.geoway.zhgd.domain.ProjectRcjgProcess;
import com.geoway.zhgd.domain.ProjectRcjgRecord;
import com.geoway.zhgd.domain.ProjectRcjgVo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectRcjgProcessService {
    @Autowired
    private IProjectRcjgProcessDao projectRcjgProcessDao;
    @Autowired
    private IBaseFileDao baseFileDao;
    @Autowired
    private IProjectRcjgRecordDao projectRcjgRecordDao;
    @Autowired
    private TaskService taskService;
    @Autowired
    private IProjectRcjgDao projectRcjgDao;
    @Autowired
    private IProjectRcjgVoDao rcjgVoDao;
    @Autowired
    private GdbhService gdbhService;
    @Autowired
    private ProjectRcjgRecordService projectRcjgRecordService;

    public List<ProjectRcjgProcess> getRecordProcess(String recordId) {
        return this.projectRcjgProcessDao.findByRecordIdOrderByUpdateTime(recordId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void synResult(String recordId, Integer resultState, String fileIds, SysUser user) {
        ProjectRcjgProcess projectRcjgProcess = null;
        if (resultState == 3) {
            List processes = this.projectRcjgProcessDao.findByRecordIdOrderByUpdateTime(recordId);
            projectRcjgProcess = (ProjectRcjgProcess)processes.get(processes.size() - 1);
        } else {
            projectRcjgProcess = new ProjectRcjgProcess();
            projectRcjgProcess.setCreateTime(new Date());
            projectRcjgProcess.setRecordId(recordId);
        }
        projectRcjgProcess.setSubmitTime(new Date());
        projectRcjgProcess.setSubmitUserId(user.getId());
        projectRcjgProcess.setSubmitUserName(user.getAlisname());
        projectRcjgProcess.setUpdateTime(new Date());
        this.projectRcjgProcessDao.save((Object)projectRcjgProcess);
        ProjectRcjgRecord projectRcjgRecord = (ProjectRcjgRecord)this.projectRcjgRecordDao.findById((Object)recordId).get();
        projectRcjgRecord.setUpdateTime(new Date());
        projectRcjgRecord.setResultState(Integer.valueOf(3));
        this.projectRcjgRecordDao.save((Object)projectRcjgRecord);
        this.setFileRelation(projectRcjgProcess.getId(), fileIds);
    }

    public ProjectRcjgProcess addOne(String recordId) {
        ProjectRcjgProcess projectRcjgProcess = new ProjectRcjgProcess();
        projectRcjgProcess.setCreateTime(new Date());
        projectRcjgProcess.setRecordId(recordId);
        this.projectRcjgProcessDao.save((Object)projectRcjgProcess);
        return projectRcjgProcess;
    }

    private void setFileRelation(String processId, String fileIds) {
        List files = this.baseFileDao.findByRelationId(processId);
        if (files.size() == 0) {
            String relationId = "529c0ac9-b481-4483-8eea-a9bb565f4a3f";
            List origin = this.baseFileDao.findByRelationId(relationId);
            ArrayList<BaseFile> copy = new ArrayList<BaseFile>();
            for (BaseFile file : origin) {
                BaseFile newItem = new BaseFile();
                BeanUtils.copyProperties((Object)file, (Object)newItem);
                newItem.setRelationId(processId);
                newItem.setId(null);
                copy.add(newItem);
            }
            this.baseFileDao.saveAll(copy);
        }
    }

    public void submit(String recordIds, SysUser user) {
        for (String recordId : recordIds.split(",")) {
            ProjectRcjgRecord record = (ProjectRcjgRecord)this.projectRcjgRecordDao.findById((Object)recordId).get();
            record.setResultState(Integer.valueOf(4));
            record.setUpdateTime(new Date());
            this.projectRcjgRecordDao.save((Object)record);
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(record.getProcessId())).list();
            for (Task task : tasks) {
                this.claimComplete(task, user.getId(), new HashMap<String, Object>());
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void checkProcess(ProjectRcjgProcess process, SysUser user) throws Exception {
        ProjectRcjgVo recordVo;
        ProjectRcjgRecord record = this.projectRcjgRecordDao.findProjectRcjgRecordById(process.getRecordId());
        record.setUpdateTime(new Date());
        record.setCheckRemark(process.getCheckRemark());
        record.setResultState(process.getResultState());
        record.setCheckUserId(user.getId());
        record.setCheckUserName(user.getUsername());
        record.setCheckTime(new Date());
        if (record.getResultState() == 6) {
            record.setJudgeMatterTime(new Date());
        }
        this.projectRcjgRecordDao.save((Object)record);
        process.setUpdateTime(new Date());
        this.projectRcjgProcessDao.save((Object)process);
        ProjectRcjg rcjg = this.projectRcjgDao.findProjectRcjgByProjectId(record.getProjectId());
        if (record.getResultState() == 5) {
            recordVo = this.rcjgVoDao.findProjectRcjgVoByProjectVoId(record.getProjectId());
            if ("fhk".equalsIgnoreCase(recordVo.getKlx())) {
                this.gdbhService.saveFHK2ZBK(record.getProjectId(), user.getId(), "+", "\u7701\u7ea7\u89e3\u9501\u6307\u6807", Long.parseLong(record.getId()));
            } else if ("lsk".equalsIgnoreCase(recordVo.getKlx())) {
                this.gdbhService.saveLSK2ZBK(record.getProjectId(), user.getId(), "+", "\u7701\u7ea7\u89e3\u9501\u6307\u6807", Long.parseLong(record.getId()));
            }
            rcjg.setState(Integer.valueOf(0));
        } else if (record.getResultState() == 7) {
            recordVo = this.rcjgVoDao.findProjectRcjgVoByProjectVoId(record.getProjectId());
            if ("fhk".equalsIgnoreCase(recordVo.getKlx())) {
                this.gdbhService.saveFHK2ZBK(record.getProjectId(), user.getId(), "-", "\u51bb\u7ed3\u6307\u6807", Long.parseLong(record.getId()));
            } else if ("lsk".equalsIgnoreCase(recordVo.getKlx())) {
                this.gdbhService.saveLSK2ZBK(record.getProjectId(), user.getId(), "-", "\u51bb\u7ed3\u6307\u6807", Long.parseLong(record.getId()));
            }
        } else {
            rcjg.setState(Integer.valueOf(0));
        }
        this.projectRcjgDao.save((Object)rcjg);
        String keyWF = "check";
        Integer valueWF = record.getResultState();
        HashMap<String, Object> visiables = new HashMap<String, Object>();
        visiables.put(keyWF, valueWF);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(record.getProcessId())).list();
        for (Task task : tasks) {
            this.claimComplete(task, user.getId(), visiables);
        }
        if (record.getResultState() == 7) {
            this.projectRcjgRecordService.generateHsGty(record.getProjectId(), "rcjg");
        }
    }

    private void claimComplete(Task task, String userId, Map<String, Object> visiables) {
        this.taskService.claim(task.getId(), userId);
        this.taskService.complete(task.getId(), visiables);
    }
}

