/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.base.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.zbph.constant.base.EnumCheckResult;
import com.geoway.onemap.zbph.constant.base.EnumIsCheck;
import com.geoway.onemap.zbph.constant.base.EnumProcessStateType;
import com.geoway.onemap.zbph.domain.base.AbstractXmxx;
import com.geoway.onemap.zbph.domain.base.BaseProcessXmxx;
import com.geoway.onemap.zbph.domain.base.ProcessInstance;
import com.geoway.onemap.zbph.domain.base.ProcessModel;
import com.geoway.onemap.zbph.domain.base.ProcessOper;
import com.geoway.onemap.zbph.domain.base.ProcessStep;
import com.geoway.onemap.zbph.domain.base.RefObject;
import com.geoway.onemap.zbph.service.base.AbstractProcessXmxxService;
import com.geoway.onemap.zbph.service.base.ProcessInstanceService;
import com.geoway.onemap.zbph.service.base.ProcessModelService;
import com.geoway.onemap.zbph.service.base.impl.AbstractXmxxServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractProcessXmxxServiceImpl<T extends BaseProcessXmxx>
extends AbstractXmxxServiceImpl<T>
implements AbstractProcessXmxxService<T> {
    @Autowired
    protected ProcessInstanceService processInstanceService;
    @Autowired
    protected ProcessModelService processModelService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(T xmxx, SysUser sysUser) {
        try {
            if (StrUtil.isBlank((CharSequence)((AbstractXmxx)xmxx).getXmid())) {
                ProcessModel processModel = this.processModelService.findProcessModel(sysUser, ((BaseProcessXmxx)xmxx).getProcessModelGroup());
                ProcessInstance processInstance = this.processInstanceService.createInstance(processModel, sysUser);
                ((BaseProcessXmxx)xmxx).setProcessId(processInstance.getId());
                ((BaseProcessXmxx)xmxx).setProcessStateStr(processInstance.getProcessStateStr());
                ((BaseProcessXmxx)xmxx).setProcessState(processInstance.getProcessState());
            }
            super.saveOrUpdate(xmxx, sysUser);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveOrUpdate(Iterable<T> xmxxs, SysUser sysUser, boolean checkValid) {
        try {
            ProcessModel processModel = null;
            for (BaseProcessXmxx t : xmxxs) {
                if (!StrUtil.isBlank((CharSequence)t.getXmid()) || sysUser == null) continue;
                if (processModel == null) {
                    processModel = this.processModelService.findProcessModel(sysUser, t.getProcessModelGroup());
                }
                ProcessInstance processInstance = this.processInstanceService.createInstance(processModel, sysUser);
                t.setProcessId(processInstance.getId());
                t.setProcessStateStr(processInstance.getProcessStateStr());
                t.setProcessState(processInstance.getProcessState());
            }
            super.batchSaveOrUpdate(xmxxs, sysUser, checkValid);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void forcePass(List<String> id, SysUser sysUser, String comment, String checkFileName, String checkFilePath, String tag) {
        this.audit(EnumCheckResult.ForcePass, id, sysUser, comment, checkFileName, checkFilePath, "", tag, EnumIsCheck.UnCheck);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void pass(List<String> ids, @NotNull SysUser sysUser, String comment, String checkFileName, String checkFilePath, String tag) {
        this.audit(EnumCheckResult.Pass, ids, sysUser, comment, checkFileName, checkFilePath, "", tag, EnumIsCheck.UnCheck);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void revert(List<String> id, @NotNull SysUser sysUser, String comment, String checkFileName, String checkFilePath, String tag) {
        this.audit(EnumCheckResult.Revert, id, sysUser, comment, checkFileName, checkFilePath, "", tag, EnumIsCheck.UnCheck);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void refuse(List<String> ids, SysUser sysUser, String comment, String checkFileName, String checkFilePath, String tag) {
        this.audit(EnumCheckResult.Refused, ids, sysUser, comment, checkFileName, checkFilePath, "", tag, EnumIsCheck.UnCheck);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void stop(List<String> ids, SysUser sysUser, String comment, String checkFileName, String checkFilePath, String tag) {
        this.audit(EnumCheckResult.Stop, ids, sysUser, comment, checkFileName, checkFilePath, "", tag, EnumIsCheck.UnCheck);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void forcePass(List<String> id, @NotNull SysUser sysUser, String comment, String checkFileName, String checkFilePath, String tag, EnumIsCheck isCheck) {
        this.audit(EnumCheckResult.ForcePass, id, sysUser, comment, checkFileName, checkFilePath, "", tag, isCheck);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void pass(List<String> id, @NotNull SysUser sysUser, String comment, String checkFileName, String checkFilePath, String tag, EnumIsCheck isCheck) {
        this.audit(EnumCheckResult.Pass, id, sysUser, comment, checkFileName, checkFilePath, "", tag, isCheck);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void revert(List<String> id, @NotNull SysUser sysUser, String comment, String checkFileName, String checkFilePath, String tag, EnumIsCheck isCheck) {
        this.audit(EnumCheckResult.Revert, id, sysUser, comment, checkFileName, checkFilePath, "", tag, isCheck);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void refuse(List<String> id, SysUser sysUser, String comment, String checkFileName, String checkFilePath, String tag, EnumIsCheck isCheck) {
        this.audit(EnumCheckResult.Refused, id, sysUser, comment, checkFileName, checkFilePath, "", tag, isCheck);
    }

    @Override
    public void refuse(List<String> id, SysUser sysUser, String comment, String checkFileName, String checkFilePath, String refuseState, String tag, EnumIsCheck isCheck) {
        this.audit(EnumCheckResult.Refused, id, sysUser, comment, checkFileName, checkFilePath, refuseState, tag, isCheck);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void stop(List<String> id, SysUser sysUser, String comment, String checkFileName, String checkFilePath, String tag, EnumIsCheck isCheck) {
        this.audit(EnumCheckResult.Stop, id, sysUser, comment, checkFileName, checkFilePath, "", tag, isCheck);
    }

    private void audit(EnumCheckResult checkResult, List<String> ids, SysUser sysUser, String comment, String checkFileName, String checkFilePath, String auditState, String tag, EnumIsCheck isCheck) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        List details = super.findByIds(ids, this.getProcessFields());
        List<String> processIds = details.stream().map(f -> f.getProcessId()).collect(Collectors.toList());
        List<ProcessInstance> processInstances = this.processInstanceService.findByIds(processIds);
        RefObject<Boolean> finishedObject = new RefObject<Boolean>(false);
        ProcessStep curStep = null;
        switch (checkResult) {
            case Pass: {
                curStep = this.processInstanceService.pass(sysUser, processInstances, comment, checkFileName, checkFilePath, tag, finishedObject);
                break;
            }
            case Refused: {
                curStep = this.processInstanceService.refused(sysUser, processInstances, comment, checkFileName, checkFilePath, auditState, tag);
                break;
            }
            case Revert: {
                curStep = this.processInstanceService.revert(sysUser, processInstances, comment, checkFileName, checkFilePath, tag);
                break;
            }
            case ForcePass: {
                curStep = this.processInstanceService.forcePass(sysUser, processInstances, comment, checkFileName, checkFilePath, tag, finishedObject);
                break;
            }
            case Stop: {
                curStep = this.processInstanceService.stop(sysUser, processInstances, comment, checkFileName, checkFilePath, tag, finishedObject);
            }
        }
        BaseProcessXmxx template = (BaseProcessXmxx)this.getDefault();
        template.setProcessState(curStep.getProcessState());
        template.setProcessStateStr(curStep.getProcessStateStr());
        template.setUpdateDate(DateUtil.now());
        if (EnumIsCheck.Check == isCheck) {
            template.setIsCheck(Integer.parseInt(isCheck.toValue()));
        }
        List<String> xmids = details.stream().map(f -> f.getXmid()).collect(Collectors.toList());
        this.updateByIds(xmids, template);
    }

    @Override
    public T findByProcessId(String processId) {
        BaseProcessXmxx t = (BaseProcessXmxx)this.getDefault();
        return (T)((BaseProcessXmxx)this.findOne(String.format(";Q_%s_S_EQ=%s", t.getProcessIdFieldName(), processId)));
    }

    @Override
    public List<T> findByProcessIds(List<String> processIds) {
        return this.findByProcessIds(processIds, null);
    }

    @Override
    public List<T> findByProcessIds(List<String> processId, List<String> fields) {
        BaseProcessXmxx t = (BaseProcessXmxx)this.getDefault();
        return this.findByFilter(String.format(";Q_%s_S_IN=%s", t.getProcessIdFieldName(), String.join((CharSequence)",", processId)), fields);
    }

    @Override
    public ProcessModel findProcessModel(SysUser sysUser, String group) {
        if (StrUtil.isBlank((CharSequence)group)) {
            BaseProcessXmxx t = (BaseProcessXmxx)this.getDefault();
            group = t.getProcessModelGroup();
        }
        return this.processModelService.findProcessModel(sysUser, group);
    }

    @Override
    public Page<T> findPageByFilter(SysUser sysUser, String group, EnumProcessStateType processType, String filterParam, String sortParam, String groupCode, boolean queryChildXzq, int start, int limit) {
        if (StrUtil.isBlank((CharSequence)group)) {
            BaseProcessXmxx t = (BaseProcessXmxx)this.getDefault();
            group = t.getProcessModelGroup();
        }
        Map<EnumProcessStateType, Map<String, String>> temp = this.processModelService.getProcessStateMap(sysUser, group);
        return this.findPageByFilter(temp.get(processType).keySet().stream().collect(Collectors.toList()), sysUser, filterParam, sortParam, groupCode, queryChildXzq, start, limit);
    }

    @Override
    public Map<String, Map<String, String>> getProcessStateMap(SysUser sysUser, String group) {
        if (StrUtil.isBlank((CharSequence)group)) {
            BaseProcessXmxx t = (BaseProcessXmxx)this.getDefault();
            group = t.getProcessModelGroup();
        }
        Map<EnumProcessStateType, Map<String, String>> temp = this.processModelService.getProcessStateMap(sysUser, group);
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        temp.forEach((k, v) -> result.put(k.toValue(), (Map<String, String>)v));
        return result;
    }

    @Override
    public ProcessStep getCurProcessStep(String xmid) {
        List details = super.findByIds(Collections.singleton(xmid), this.getProcessFields());
        List<String> processIds = details.stream().map(f -> f.getProcessId()).collect(Collectors.toList());
        List<ProcessInstance> processInstances = this.processInstanceService.findByIds(processIds);
        if (processInstances == null || processInstances.size() == 0) {
            return null;
        }
        return this.processModelService.getStepByProcessState(processInstances.get(0).getProcessModel(), processInstances.get(0).getProcessState());
    }

    @Override
    public Map<String, ProcessOper> getProcessOperMap(SysUser sysUser, String group) {
        if (StrUtil.isBlank((CharSequence)group)) {
            BaseProcessXmxx t = (BaseProcessXmxx)this.getDefault();
            group = t.getProcessModelGroup();
        }
        return this.processModelService.getProcessOperMap(sysUser, group);
    }

    @Override
    public void exportExcelByProcessState(HttpServletResponse response, String fileName, SysUser sysUser, String group, EnumProcessStateType stateType, String filterParam, String sortParam, String groupCode, Map<String, Map> map, String templateName, boolean queryChildXzq) {
        if (StrUtil.isBlank((CharSequence)group)) {
            BaseProcessXmxx t = (BaseProcessXmxx)this.getDefault();
            group = t.getProcessModelGroup();
        }
        Map<EnumProcessStateType, Map<String, String>> temp = this.processModelService.getProcessStateMap(sysUser, group);
        List<String> relatedProcessStates = temp.get(stateType).keySet().stream().collect(Collectors.toList());
        filterParam = this.getFilterParam(relatedProcessStates, sysUser, filterParam, queryChildXzq);
        this.exportExcel(response, fileName, filterParam, sortParam, groupCode, map, templateName);
    }

    @Override
    public Map<String, Long> getCountGroupByProcessState(SysUser sysUser, String group, String filterParam, boolean queryChildXzq) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        if (StrUtil.isBlank((CharSequence)group)) {
            BaseProcessXmxx t = (BaseProcessXmxx)this.getDefault();
            group = t.getProcessModelGroup();
        }
        Map<EnumProcessStateType, Map<String, String>> temp = this.processModelService.getProcessStateMap(sysUser, group);
        for (Map.Entry<EnumProcessStateType, Map<String, String>> kv : temp.entrySet()) {
            if (kv.getValue().keySet().size() == 0) {
                result.put(kv.getKey().toValue(), 0L);
                continue;
            }
            Long count = this.findPageByFilter(kv.getValue().keySet().stream().collect(Collectors.toList()), sysUser, filterParam, "", "", queryChildXzq, 1, 15).getTotalElements();
            result.put(kv.getKey().toValue(), count);
        }
        return result;
    }

    protected Page<T> findPageByFilter(List<String> relatedProcessStates, SysUser sysUser, String filterParam, String sortParam, String groupCode, boolean queryChildXzq, int start, int limit) {
        filterParam = this.getFilterParam(relatedProcessStates, sysUser, filterParam, queryChildXzq);
        return super.findPageByFilter(filterParam, sortParam, groupCode, start, limit);
    }

    protected String getCutXzqDm(String xzqDm) {
        if (xzqDm.endsWith("00")) {
            xzqDm = this.getCutXzqDm(xzqDm.substring(0, xzqDm.length() - 2));
        }
        return xzqDm;
    }

    protected String getFilterParam(List<String> relatedProcessStates, SysUser sysUser, String filterParam, boolean queryChildXzq) {
        BaseProcessXmxx t = (BaseProcessXmxx)this.getDefault();
        filterParam = queryChildXzq ? filterParam + String.format(";Q_%s_S_LK=%s", t.getXzqdmFieldName(), this.getCutXzqDm(sysUser.getXzqdm())) : filterParam + String.format(";Q_%s_S_EQ=%s", t.getXzqdmFieldName(), sysUser.getXzqdm());
        if (relatedProcessStates != null && relatedProcessStates.size() > 0) {
            filterParam = filterParam + String.format(";Q_%s_S_IN=%s", t.getProcessstateFieldName(), String.join((CharSequence)",", relatedProcessStates));
        }
        return filterParam;
    }

    protected List<String> getProcessFields() {
        BaseProcessXmxx defaultObject = (BaseProcessXmxx)this.getDefault();
        ArrayList<String> result = new ArrayList<String>();
        result.add(defaultObject.getXmidFieldName());
        result.add(defaultObject.getProcessIdFieldName());
        result.add(defaultObject.getProcessstateFieldName());
        return result;
    }
}

