/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.base.impl;

import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.stxf.service.BaseFileService;
import com.geoway.onemap.zbph.domain.base.BaseXmfj;
import com.geoway.onemap.zbph.service.base.BaseXmfjService;
import com.geoway.zhgd.domain.BaseFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BaseXmfjServiceImpl
implements BaseXmfjService {
    @Autowired
    private BaseFileService baseFileService;
    @Value(value="${project.uploadDir}")
    private String uploadDir;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchInsert(List<BaseXmfj> baseXmfjs, SysUser user) {
        for (BaseXmfj baseXmfj : baseXmfjs) {
            this.baseFileService.uploadFile2(new File(this.uploadDir + File.separator + baseXmfj.getPath()), baseXmfj.getXmid(), baseXmfj.getRelation_type(), user, baseXmfj.getType());
        }
    }

    @Override
    public List<BaseXmfj> findByXmid(String xmid) {
        List<BaseFile> baseFiles = this.baseFileService.findByRelationId(xmid);
        ArrayList<BaseXmfj> baseXmfjs = new ArrayList<BaseXmfj>();
        for (BaseFile baseFile : baseFiles) {
            BaseXmfj baseXmfj = new BaseXmfj();
            baseXmfj.setFile_id(baseFile.getId());
            baseXmfj.setXmid(baseFile.getRelationId());
            baseXmfj.setPath(baseFile.getCreatePath());
            baseXmfj.setType(baseFile.getMediaType());
            baseXmfj.setName(baseFile.getFileName());
            baseXmfj.setUploadTime(baseFile.getUploadTime());
            baseXmfj.setRelation_type(baseFile.getRelationType());
            baseXmfjs.add(baseXmfj);
        }
        return baseXmfjs;
    }

    @Override
    public List<BaseXmfj> findByXmidAndRelateType(String xmid, String type) {
        List<BaseFile> baseFiles = this.baseFileService.findByRelationId(xmid, type);
        ArrayList<BaseXmfj> baseXmfjs = new ArrayList<BaseXmfj>();
        for (BaseFile baseFile : baseFiles) {
            BaseXmfj baseXmfj = new BaseXmfj();
            baseXmfj.setFile_id(baseFile.getId());
            baseXmfj.setXmid(baseFile.getRelationId());
            baseXmfj.setPath(baseFile.getCreatePath());
            baseXmfj.setType(baseFile.getMediaType());
            baseXmfj.setName(baseFile.getFileName());
            baseXmfj.setUploadTime(baseFile.getUploadTime());
            baseXmfj.setRelation_type(baseFile.getRelationType());
            baseXmfjs.add(baseXmfj);
        }
        return baseXmfjs;
    }

    @Override
    public void deleteByXmId(String xmid) {
        this.baseFileService.deleteByRelationId(xmid);
    }

    @Override
    public void deleteByXmIdAndRelateType(String xmid, String relateType) {
        this.baseFileService.deleteByRelationIdAndRelationType(xmid, relateType);
    }
}

