/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.base.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.onemap.stxf.dto.TaskBlockDTO;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.service.base.DataVerifyTaskService;
import com.geoway.onemap.zbph.service.base.impl.VerifyTaskManageServiceImpl;
import com.geoway.onemap.zbph.supoort.GeoserverUtil;
import com.geoway.zhgd.dao.VerifyTaskDao;
import com.geoway.zhgd.domain.VerifyTask;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class DataVerifyTaskServiceImpl
implements DataVerifyTaskService {
    @Autowired
    private GeoserverUtil geoserverUtil;
    @Autowired
    private VerifyTaskDao verifyTaskDao;
    @Autowired
    private ThreadPoolTaskExecutor executor;
    @Value(value="${project.fxfw.service.param:}")
    private String paramConfig;

    @Override
    public String createTask(Map xmxx, List<TaskBlockDTO> blockDTO, Map param, String service, VerifyTask task) {
        VerifyTask verifyTask;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationGUID", ConfigConstant.GeoServerConfig.Service_Key);
        map.put("AnalysisID", String.valueOf(LocalDateTime.now().toInstant(ZoneOffset.of("+8")).getEpochSecond()));
        map.put("async", true);
        map.put("swapRule", true);
        map.put("getImage", true);
        map.put("bufferDistance", 10);
        map.put("drawBlocks", false);
        map.put("SFFHTX", "true");
        if (param != null) {
            map.putAll(param);
        }
        if (StringUtils.isNotBlank((CharSequence)this.paramConfig)) {
            map.putAll((Map)JSONObject.parseObject((String)this.paramConfig, Map.class));
        }
        map.put("filter", xmxx);
        map.put("Blocks", blockDTO);
        String params = JSON.toJSONString(map);
        JSONObject result = this.geoserverUtil.httpCreateTask(service, params);
        String taskId = result.getString("UniqueTaskID");
        task = task != null ? ((verifyTask = this.verifyTaskDao.findByPidAndType(task.getPid(), task.getType())) == null ? task : verifyTask) : VerifyTask.builder().customClass(VerifyTaskManageServiceImpl.class.getName()).build();
        task.setTaskId(taskId);
        task.setStatus(Integer.valueOf(0));
        task.setServiceName(service);
        this.verifyTaskDao.save((Object)task);
        if (StringUtils.isBlank((CharSequence)task.getPid())) {
            task.setPid(task.getId());
            this.verifyTaskDao.save((Object)task);
        }
        return task.getId();
    }

    @Override
    public JSONObject createYzfx(List<TaskBlockDTO> blockDTO, Map param, String service) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationGUID", ConfigConstant.GeoServerConfig.Service_Key);
        map.put("AnalysisID", String.valueOf(LocalDateTime.now().toInstant(ZoneOffset.of("+8")).getEpochSecond()));
        map.put("SFFHTX", "true");
        map.put("SFFHTB", "true");
        if (param != null) {
            map.putAll(param);
        }
        if (StringUtils.isNotBlank((CharSequence)this.paramConfig)) {
            map.putAll((Map)JSONObject.parseObject((String)this.paramConfig, Map.class));
        }
        map.put("Blocks", blockDTO);
        String params = JSON.toJSONString(map);
        JSONObject result = this.geoserverUtil.httpCreateByType(service, "yzfx", params);
        return result;
    }

    @Override
    public List queryResult(String id, String type, String limitType, Boolean result, Integer verify) {
        VerifyTask task = this.findTask(id, type);
        return this.geoserverUtil.httpFindResult(task.getServiceName(), limitType, result, task.getTaskId(), verify);
    }

    @Override
    public List queryAnalysResult(String id, String type) {
        VerifyTask task = this.findTask(id, type);
        HashMap map = new HashMap();
        JSONArray infoArray = this.geoserverUtil.httpFindInfo(task.getServiceName());
        for (Object o : infoArray) {
            JSONObject obj = (JSONObject)o;
            List services = obj.getJSONArray("services").toJavaList(JSONObject.class);
            services.forEach(f -> map.put(f.getString("serviceId"), f.getString("chartData")));
        }
        List array = this.geoserverUtil.httpFindAnalysResult(task.getTaskId()).toJavaList(JSONObject.class);
        array = array.stream().filter(f -> {
            Object o = f.get((Object)"result");
            return o != null;
        }).collect(Collectors.toList());
        array.stream().forEach(f -> {
            int status = f.getIntValue("status");
            String result = f.getString("result");
            if (status == 1) {
                f.put("result", (Object)JSON.parseObject((String)result));
            }
            f.put("charJson", map.get(f.getString("serviceId")));
        });
        return array;
    }

    @Override
    public void deleteByPid(String pid) {
        this.verifyTaskDao.deleteByPid(pid);
    }

    @Override
    public VerifyTask getTaskById(String id) {
        return this.verifyTaskDao.findById((Object)id).orElse(null);
    }

    private VerifyTask findTask(String id, String type) {
        VerifyTask task = this.verifyTaskDao.findByPid(id);
        if (task == null) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u4efb\u52a1\uff01");
        }
        return task;
    }
}

