/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.base.impl;

import cn.hutool.core.util.StrUtil;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.JsonUtils;
import com.geoway.onemap.zbph.constant.base.EnumProcessStateType;
import com.geoway.onemap.zbph.dao.base.ProcessModelRepository;
import com.geoway.onemap.zbph.domain.base.CheckStateDict;
import com.geoway.onemap.zbph.domain.base.ProcessModel;
import com.geoway.onemap.zbph.domain.base.ProcessOper;
import com.geoway.onemap.zbph.domain.base.ProcessStateDict;
import com.geoway.onemap.zbph.domain.base.ProcessStep;
import com.geoway.onemap.zbph.domain.base.TaskListenerDetail;
import com.geoway.onemap.zbph.domain.base.TaskListenerDetailDict;
import com.geoway.onemap.zbph.service.base.CheckStateDictService;
import com.geoway.onemap.zbph.service.base.ProcessModelService;
import com.geoway.onemap.zbph.service.base.ProcessStateDictService;
import com.geoway.onemap.zbph.service.base.TaskListenerDictService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessModelServiceImpl
implements ProcessModelService {
    @Autowired
    private ProcessModelRepository processModelRepository;
    @Autowired
    private ProcessStateDictService processStateDictService;
    @Autowired
    private CheckStateDictService checkStateDictService;
    @Autowired
    private TaskListenerDictService taskListenerDictService;

    @Override
    public void saveOrUpdate(ProcessModel processModel) {
        processModel.setId(UUID.randomUUID().toString());
        this.processModelRepository.save(processModel);
    }

    @Override
    public List<ProcessModel> findByIds(List<String> ids) {
        List<ProcessModel> models = this.processModelRepository.findByIds(ids);
        models.forEach(f -> this.wrapProcessModel((ProcessModel)f));
        return models;
    }

    @Override
    public List<ProcessModel> findByGroup(String groupName) {
        List<ProcessModel> models = this.processModelRepository.findByGroup(groupName);
        models = models.stream().filter(f -> f.getEnable().equals(1)).collect(Collectors.toList());
        models.forEach(f -> this.wrapProcessModel((ProcessModel)f));
        return models;
    }

    private void wrapProcessModel(ProcessModel model) {
        List steps = JsonUtils.jsonToList((String)model.getDetail(), ProcessStep.class);
        for (ProcessStep step : steps) {
            ProcessStateDict processStateDict;
            if (StrUtil.isNotBlank((CharSequence)step.getProcessState()) && StrUtil.isBlank((CharSequence)step.getProcessStateStr())) {
                processStateDict = this.processStateDictService.findByState(step.getProcessState());
                step.setProcessStateStr(processStateDict == null ? "" : processStateDict.getProcessStateStr());
            }
            if (StrUtil.isNotBlank((CharSequence)step.getCheckState()) && StrUtil.isBlank((CharSequence)step.getCheckStateStr())) {
                CheckStateDict checkStateDict = this.checkStateDictService.findByState(step.getCheckState());
                step.setCheckStateStr(checkStateDict == null ? "" : checkStateDict.getCheckStateStr());
            }
            if (StrUtil.isNotBlank((CharSequence)step.getRefusedState()) && StrUtil.isBlank((CharSequence)step.getRefusedStateStr())) {
                List<String> refusedStates = step.getRefusedStates();
                ArrayList<String> refusedStateStrs = new ArrayList<String>();
                for (String refusedState : refusedStates) {
                    ProcessStateDict processStateDict2 = this.processStateDictService.findByState(refusedState);
                    refusedStateStrs.add(processStateDict2 == null ? "" : processStateDict2.getProcessStateStr());
                }
                step.setRefusedStateStr(String.join((CharSequence)",", refusedStateStrs));
            }
            if (StrUtil.isNotBlank((CharSequence)step.getStopState()) && StrUtil.isBlank((CharSequence)step.getStopStateStr())) {
                processStateDict = this.processStateDictService.findByState(step.getStopState());
                step.setStopStateStr(processStateDict == null ? "" : processStateDict.getProcessStateStr());
            }
            if (StrUtil.isNotBlank((CharSequence)step.getRevertState()) && StrUtil.isBlank((CharSequence)step.getRevertStateStr())) {
                processStateDict = this.processStateDictService.findByState(step.getRevertState());
                step.setRevertStateStr(processStateDict == null ? "" : processStateDict.getProcessStateStr());
            }
            if (step.getTaskListeners() == null) continue;
            Iterator<TaskListenerDetail> iterator = step.getTaskListeners().iterator();
            while (iterator.hasNext()) {
                TaskListenerDetail taskListenerDetail;
                TaskListenerDetailDict listenerDict = this.taskListenerDictService.findByName((taskListenerDetail = iterator.next()).getClassName());
                taskListenerDetail.setClassName(listenerDict == null ? taskListenerDetail.getClassName() : listenerDict.getClassName());
            }
        }
        model.setSteps(steps);
    }

    @Override
    public ProcessModel findByName(String name) {
        ProcessModel model = this.processModelRepository.findByName(name);
        this.wrapProcessModel(model);
        return model;
    }

    @Override
    public ProcessModel findById(String id) {
        ProcessModel processModel = this.processModelRepository.findById(id).orElse(null);
        this.wrapProcessModel(processModel);
        return processModel;
    }

    @Override
    public Map<EnumProcessStateType, Map<String, String>> getProcessStateMap(SysUser sysUser, String group) {
        List<ProcessModel> models = this.findByGroup(group);
        Map<String, String> totalMap = this.getTotalProcessStateMap(models);
        HashMap<EnumProcessStateType, Map<String, String>> result = new HashMap<EnumProcessStateType, Map<String, String>>();
        List<Object> states = new ArrayList<String>();
        List<EnumProcessStateType> all = EnumProcessStateType.getAll();
        for (EnumProcessStateType processType : all) {
            switch (processType) {
                case Completed: {
                    states = this.getCompletedProcessStates(sysUser, models);
                    break;
                }
                case Undo: {
                    states = this.getUndoProcessStates(sysUser, models);
                    break;
                }
                case Done: {
                    states = this.getDoneProcessStates(sysUser, models);
                    break;
                }
                case undoLast: {
                    states = this.getUndoLastProcessStates(sysUser, models);
                    break;
                }
                case Refused: {
                    states = this.getRefusedProcessStates(sysUser, models);
                    break;
                }
                case Audit: {
                    states = this.getAuditProcessStates(sysUser, models);
                    break;
                }
                case All: {
                    states.addAll(this.getDoneProcessStates(sysUser, models));
                    states.addAll(this.getUndoProcessStates(sysUser, models));
                    break;
                }
                case Whole: {
                    states.addAll(totalMap.keySet());
                    break;
                }
                case Current: {
                    states = this.getCurrentProcessStates(sysUser, models);
                    break;
                }
                case Revert: {
                    states = this.getRevertState(sysUser, models);
                    break;
                }
                case Stoped: {
                    states = this.getStopedProcessStates(sysUser, models);
                    break;
                }
                case Unstop: {
                    states = this.getUnStopProcessStates(sysUser, models);
                    break;
                }
                default: {
                    states = this.getCompletedProcessStates(sysUser, models);
                }
            }
            HashMap temp = new HashMap();
            states.forEach(f -> {
                String cfr_ignored_0 = (String)temp.put(f, totalMap.get(f));
            });
            result.put(processType, temp);
        }
        return result;
    }

    @Override
    public Map<String, String> getBeforeProcessStates(String group, String processStates) {
        List<ProcessModel> models = this.findByGroup(group);
        Map<String, String> totalMap = this.getTotalProcessStateMap(models);
        ArrayList<String> temp = new ArrayList<String>();
        for (ProcessModel model : models) {
            for (int i = 0; i < model.getSteps().size(); ++i) {
                ProcessStep step = model.getSteps().get(i);
                ProcessStep beforeStep = null;
                if (i > 0) {
                    beforeStep = model.getSteps().get(i - 1);
                }
                if (!step.getProcessState().equals(processStates) || beforeStep == null) continue;
                temp.addAll(beforeStep.getRelateStates());
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        temp.forEach(f -> {
            String cfr_ignored_0 = (String)result.put((String)f, (String)totalMap.get(f));
        });
        return result;
    }

    @Override
    public ProcessModel findProcessModel(SysUser sysUser, String group) {
        List<ProcessModel> models = this.findByGroup(group);
        List userRoleNames = sysUser.getRoles().stream().map(f -> f.getRolename()).collect(Collectors.toList());
        ArrayList<ProcessModel> relateModels = new ArrayList<ProcessModel>();
        for (ProcessModel model : models) {
            if (model.getEnable().equals(0)) continue;
            List<String> modelRoles = Arrays.asList(model.getRoleNames().split(","));
            if (modelRoles.contains("*")) {
                relateModels.add(model);
                continue;
            }
            if (userRoleNames.stream().filter(f -> modelRoles.contains(f)).count() <= 0L) continue;
            relateModels.add(model);
        }
        if (relateModels.size() > 1) {
            throw new RuntimeException("\u53ea\u80fd\u5173\u8054\u4e00\u4e2a\u586b\u62a5\u6d41\u7a0b");
        }
        if (relateModels.size() == 0) {
            throw new RuntimeException("\u89d2\u8272\u3010" + String.join((CharSequence)"\u3001", userRoleNames) + "\u3011\u672a\u67e5\u8be2\u5206\u7ec4\u4e3a\u3010" + group + "\u3011\u7684\u6a21\u578b\uff01");
        }
        return (ProcessModel)relateModels.get(0);
    }

    @Override
    public Map<String, ProcessOper> getProcessOperMap(SysUser sysUser, String group) {
        List<ProcessModel> models = this.findByGroup(group);
        List userRoleNames = sysUser.getRoles().stream().map(f -> f.getRolename()).collect(Collectors.toList());
        HashMap<String, ProcessOper> operMap = new HashMap<String, ProcessOper>();
        for (ProcessModel model : models) {
            for (ProcessStep step : model.getSteps()) {
                for (ProcessOper processOper : step.getRelateOpers()) {
                    if (!processOper.getRelatedRoles().contains("*") && processOper.getRelatedRoles().stream().filter(f -> userRoleNames.contains(f)).count() <= 0L) continue;
                    if (processOper.getRelatedStates() == null || processOper.getRelatedStates().size() == 0) {
                        processOper.setRelatedStates(step.getRelateStates());
                    }
                    processOper.getRelatedStates().forEach(f -> operMap.put((String)f, processOper));
                }
            }
        }
        return operMap;
    }

    @Override
    public String getNextProcessStateByPass(String id, String curState) {
        ProcessModel processModel = this.findById(id);
        for (int i = 0; i < processModel.getSteps().size() - 1; ++i) {
            ProcessStep processStep = processModel.getSteps().get(i);
            if (!processStep.getRelateStates().contains(curState)) continue;
            return processModel.getSteps().get(i + 1).getProcessState();
        }
        return "";
    }

    @Override
    public String getNextProcessStateByRevert(String id, String curState) {
        ProcessModel processModel = this.findById(id);
        for (int i = 0; i < processModel.getSteps().size() - 1; ++i) {
            ProcessStep processStep = processModel.getSteps().get(i);
            if (!processStep.getRelateStates().contains(curState)) continue;
            return processStep.getRefusedStates().get(0);
        }
        return null;
    }

    @Override
    public ProcessStep getStepByProcessState(String id, String state) {
        ProcessModel processModel = this.findById(id);
        for (int i = 0; i < processModel.getSteps().size(); ++i) {
            ProcessStep processStep = processModel.getSteps().get(i);
            if (!processStep.getRelateStates().contains(state)) continue;
            return processStep;
        }
        return null;
    }

    @Override
    public String getNextProcessStateByPass(ProcessModel processModel, String curState) {
        for (int i = 0; i < processModel.getSteps().size() - 1; ++i) {
            ProcessStep processStep = processModel.getSteps().get(i);
            if (!processStep.getRelateStates().contains(curState)) continue;
            if (processStep.getNextState().containsKey(curState)) {
                return processStep.getNextState().get(curState);
            }
            return processModel.getSteps().get(i + 1).getProcessState();
        }
        return "";
    }

    @Override
    public String getNextProcessStateByRevert(ProcessModel processModel, String curState) {
        for (int i = 0; i < processModel.getSteps().size() - 1; ++i) {
            ProcessStep processStep = processModel.getSteps().get(i);
            if (!processStep.getRelateStates().contains(curState)) continue;
            return processStep.getRefusedStates().get(0);
        }
        return null;
    }

    @Override
    public ProcessStep getStepByProcessState(ProcessModel processModel, String state) {
        for (int i = 0; i < processModel.getSteps().size(); ++i) {
            ProcessStep processStep = processModel.getSteps().get(i);
            if (!processStep.getRelateStates().contains(state) && !state.equals(processStep.getStopState())) continue;
            return processStep;
        }
        return null;
    }

    private List<String> getCompletedProcessStates(SysUser sysUser, List<ProcessModel> models) {
        ArrayList<String> result = new ArrayList<String>();
        for (ProcessModel model : models) {
            for (ProcessStep step : model.getSteps()) {
                if (step.getRelatedRoles() == null || step.getRelatedRoles().stream().filter(f -> sysUser.getRoles().stream().filter(g -> g.getRolename().equals(f)).count() > 0L).count() <= 0L) continue;
                result.addAll(model.getSteps().get(model.getSteps().size() - 1).getRelateStates());
            }
        }
        return result;
    }

    private List<String> getDoneProcessStates(SysUser sysUser, List<ProcessModel> models) {
        ArrayList<String> result = new ArrayList<String>();
        for (ProcessModel model : models) {
            boolean done = false;
            for (ProcessStep step : model.getSteps()) {
                if (step.getRelatedRoles() != null && step.getRelatedRoles().stream().filter(f -> sysUser.getRoles().stream().filter(g -> g.getRolename().equals(f)).count() > 0L).count() > 0L) {
                    done = true;
                    for (String refusedState : step.getRefusedStates()) {
                        ProcessStep refusedStep = this.getStepByProcessState(model, refusedState);
                        if (refusedStep.getCheckState().equals(step.getCheckState())) continue;
                        result.addAll(step.getRefusedStates());
                    }
                    if (!StrUtil.isNotBlank((CharSequence)step.getStopState())) continue;
                    result.add(step.getStopState());
                    continue;
                }
                if (!done) continue;
                result.addAll(step.getRelateStates());
                if (!StrUtil.isNotBlank((CharSequence)step.getStopState())) continue;
                result.add(step.getStopState());
            }
        }
        return result;
    }

    private List<String> getStopedProcessStates(SysUser sysUser, List<ProcessModel> models) {
        ArrayList<String> result = new ArrayList<String>();
        for (ProcessModel model : models) {
            boolean done = false;
            for (ProcessStep step : model.getSteps()) {
                if (step.getRelatedRoles() != null && step.getRelatedRoles().stream().filter(f -> sysUser.getRoles().stream().filter(g -> g.getRolename().equals(f)).count() > 0L).count() > 0L) {
                    done = true;
                }
                if (!done || !StrUtil.isNotBlank((CharSequence)step.getStopState())) continue;
                result.add(step.getStopState());
            }
        }
        return result;
    }

    private List<String> getUnStopProcessStates(SysUser sysUser, List<ProcessModel> models) {
        ArrayList<String> result = new ArrayList<String>();
        block0: for (ProcessModel model : models) {
            for (ProcessStep step : model.getSteps()) {
                if (step.getRelatedRoles() == null || step.getRelatedRoles().stream().filter(f -> sysUser.getRoles().stream().filter(g -> g.getRolename().equals(f)).count() > 0L).count() == 0L || StrUtil.isBlank((CharSequence)step.getStopState())) continue;
                result.addAll(step.getRelateStates());
                result.remove(step.getStopState());
                continue block0;
            }
        }
        return result;
    }

    private List<String> getUndoProcessStates(SysUser sysUser, List<ProcessModel> models) {
        ArrayList<String> result = new ArrayList<String>();
        for (ProcessModel model : models) {
            for (ProcessStep step : model.getSteps()) {
                if (step.getRelatedRoles() == null || step.getRelatedRoles().stream().filter(f -> sysUser.getRoles().stream().filter(g -> g.getRolename().equals(f)).count() > 0L).count() <= 0L) continue;
                result.addAll(step.getRelateStates());
                if (!StrUtil.isNotBlank((CharSequence)step.getStopState())) continue;
                result.remove(step.getStopState());
            }
        }
        return result;
    }

    private List<ProcessModel> getRelatedModels(SysUser sysUser, List<ProcessModel> models) {
        ArrayList<ProcessModel> result = new ArrayList<ProcessModel>();
        for (ProcessModel model : models) {
            for (ProcessStep step : model.getSteps()) {
                if (step.getRelatedRoles() == null || step.getRelatedRoles().stream().filter(f -> sysUser.getRoles().stream().filter(g -> g.getRolename().equals(f)).count() > 0L).count() <= 0L) continue;
                result.add(model);
            }
        }
        return result;
    }

    private List<String> getUndoLastProcessStates(SysUser sysUser, List<ProcessModel> models) {
        ArrayList<String> result = new ArrayList<String>();
        for (ProcessModel model : models) {
            for (int i = 0; i < model.getSteps().size(); ++i) {
                ProcessStep step = model.getSteps().get(i);
                ProcessStep nextStep = null;
                if (i < model.getSteps().size() - 1) {
                    nextStep = model.getSteps().get(i + 1);
                }
                if (step.getRelatedRoles() == null || step.getRelatedRoles().stream().filter(f -> sysUser.getRoles().stream().filter(g -> g.getRolename().equals(f)).count() > 0L).count() <= 0L) continue;
                if (nextStep == null) {
                    result.addAll(step.getRelateStates());
                    continue;
                }
                if (nextStep.getCheckState().equals(step.getCheckState())) continue;
                result.addAll(step.getRelateStates());
            }
        }
        return result;
    }

    private List<String> getRefusedProcessStates(SysUser sysUser, List<ProcessModel> models) {
        List<String> undoStates = this.getUndoProcessStates(sysUser, models);
        for (ProcessModel model : models) {
            for (ProcessStep step : model.getSteps()) {
                if (step.getRelatedRoles() == null || step.getRelatedRoles().stream().filter(f -> sysUser.getRoles().stream().filter(g -> g.getRolename().equals(f)).count() > 0L).count() <= 0L) continue;
                undoStates.remove(step.getProcessState());
                undoStates.removeAll(step.getRefusedStates());
            }
        }
        return undoStates;
    }

    private List<String> getAuditProcessStates(SysUser sysUser, List<ProcessModel> models) {
        List<String> doneStates = this.getDoneProcessStates(sysUser, models);
        List<String> completeStates = this.getCompletedProcessStates(sysUser, models);
        List<String> stopStates = this.getStopedProcessStates(sysUser, models);
        doneStates.removeAll(completeStates);
        doneStates.removeAll(stopStates);
        return doneStates;
    }

    private List<String> getCurrentProcessStates(SysUser sysUser, List<ProcessModel> models) {
        List<String> undo = this.getUndoProcessStates(sysUser, models);
        List<String> refused = this.getRefusedProcessStates(sysUser, models);
        undo.removeAll(refused);
        return undo;
    }

    private List<String> getRevertState(SysUser sysUser, List<ProcessModel> models) {
        List<String> currentStates = this.getUndoProcessStates(sysUser, models);
        ArrayList<String> result = new ArrayList<String>();
        for (ProcessModel model : this.getRelatedModels(sysUser, models)) {
            for (ProcessStep step : model.getSteps()) {
                if (step.getRevertState() == null || !currentStates.contains(step.getRevertState())) continue;
                result.add(step.getProcessState());
            }
        }
        return result;
    }

    private Map<String, String> getTotalProcessStateMap(List<ProcessModel> models) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (ProcessModel model : models) {
            result.putAll(this.getTotalProcessStateMap(model));
        }
        return result;
    }

    @Override
    public Map<String, String> getTotalProcessStateMap(ProcessModel model) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (ProcessStep step : model.getSteps()) {
            result.put(step.getProcessState(), step.getProcessStateStr());
            result.putAll(step.getRefusedStatesMap());
            if (StrUtil.isNotBlank((CharSequence)step.getStopState()) && StrUtil.isNotBlank((CharSequence)step.getStopStateStr())) {
                result.put(step.getStopState(), step.getStopStateStr());
            }
            if (!StrUtil.isNotBlank((CharSequence)step.getRevertState()) || !StrUtil.isNotBlank((CharSequence)step.getRevertStateStr())) continue;
            result.put(step.getRevertState(), step.getRevertStateStr());
        }
        return result;
    }
}

