/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.xfstbrk.impl;

import cn.hutool.core.date.DateUtil;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.SpringContextUtil;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.constant.base.EnumIsCheck;
import com.geoway.onemap.zbph.constant.base.EnumProcessStateType;
import com.geoway.onemap.zbph.constant.base.EnumStatType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKInputMethod;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKInputType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKPzType;
import com.geoway.onemap.zbph.domain.base.ProcessInstance;
import com.geoway.onemap.zbph.domain.base.ProcessStep;
import com.geoway.onemap.zbph.domain.base.RefObject;
import com.geoway.onemap.zbph.domain.xfsgdtbrk.ZbkTbrkDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKConfigDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKInputDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKSpatialDetail;
import com.geoway.onemap.zbph.dto.zbkmanager.ZBKInputDTO;
import com.geoway.onemap.zbph.service.base.impl.AbstractProcessXmxxServiceImpl;
import com.geoway.onemap.zbph.service.xfstbrk.ZbkTbrkDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKConfigDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKManagerService;
import com.geoway.onemap.zbph.supoort.LockUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ZbkTbrkDetailServiceImpl
extends AbstractProcessXmxxServiceImpl<ZbkTbrkDetail>
implements ZbkTbrkDetailService {
    @Autowired
    private ZBKManagerService zbkManagerService;
    @Autowired
    private ZBKConfigDetailService zbkConfigDetailService;

    @Override
    public String getTableName() {
        return ZbkTbrkDetail.getTableName();
    }

    @Override
    public void exportShp(HttpServletResponse response, String fileName, String filterParam, String sortParam, String groupCode, Map<String, Map> map) {
        this.exportShp(response, fileName, filterParam, sortParam, groupCode, map, ConfigConstant.TbrkConfig.FieldMap);
    }

    private double getTotalYrk(String xzq) {
        ZbkTbrkDetail t = (ZbkTbrkDetail)this.getDefault();
        String filterParam = String.format("Q_%s_S_LK=%s;Q_%s_S_NE=-1", t.getXmXzqdmFieldName(), this.getCutXzqDm(xzq), "rklx");
        HashMap<String, EnumStatType> statFields = new HashMap<String, EnumStatType>();
        statFields.put("tbdlmj", EnumStatType.Sum);
        List<Map<String, Object>> objects = this.stat(filterParam, statFields, new String[0]);
        if (objects == null || objects.size() == 0) {
            return 0.0;
        }
        if (objects.get(0).values().toArray()[0] == null) {
            return 0.0;
        }
        return Double.parseDouble(objects.get(0).values().toArray()[0].toString());
    }

    private List<String> getProcessFieldsWithSpatial() {
        ZbkTbrkDetail defaultObject = (ZbkTbrkDetail)this.getDefault();
        ArrayList<String> result = new ArrayList<String>();
        result.add(defaultObject.getXmidFieldName());
        result.add(defaultObject.getXzqdmFieldName());
        result.add(defaultObject.getXzqmcFieldName());
        result.add("tbdlmj");
        result.add("dlbm");
        result.add("gddb");
        result.add("tbbh");
        result.add("dlbm");
        result.add("dlmc");
        result.add("shape");
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void pass(List<String> ids, @NotNull SysUser sysUser, String comment, String checkFileName, String checkFilePath, String tag, EnumIsCheck isCheck) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        long start = System.currentTimeMillis();
        List details = super.findByIds(ids, this.getProcessFields());
        System.out.println("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        ArrayList<ZBKInputDTO> inputDTOS = new ArrayList<ZBKInputDTO>();
        Date now = new Date();
        List<String> processIds = details.stream().map(f -> f.getProcessId()).collect(Collectors.toList());
        start = System.currentTimeMillis();
        List<ProcessInstance> processInstances = this.processInstanceService.findByIds(processIds);
        System.out.println("\u67e5\u8be2\u6d41\u7a0b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        RefObject<Boolean> finishedObject = new RefObject<Boolean>(false);
        ProcessStep curStep = this.processInstanceService.pass(sysUser, processInstances, comment, checkFileName, checkFilePath, tag, finishedObject);
        System.out.println("\u6d41\u8f6c\u6d41\u7a0b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        if (finishedObject.get().booleanValue()) {
            List zbkTbrkDetailWithSpatial = super.findByIds((Iterable<String>)details.stream().map(f -> f.getXmid()).collect(Collectors.toList()), this.getProcessFieldsWithSpatial());
            for (ZbkTbrkDetail spatialDetail : zbkTbrkDetailWithSpatial) {
                ZBKInputDTO dto = new ZBKInputDTO();
                ZBKInputDetail zbkInputDetail = new ZBKInputDetail();
                zbkInputDetail.setZbxzqmc(spatialDetail.getXzqmc());
                zbkInputDetail.setZbxzqdm(spatialDetail.getXzqdm());
                zbkInputDetail.setCzxzqmc(spatialDetail.getXzqmc());
                zbkInputDetail.setCzxzqdm(spatialDetail.getXzqdm());
                zbkInputDetail.setDkxzqmc(spatialDetail.getXzqmc());
                zbkInputDetail.setDkxzqdm(spatialDetail.getXzqdm());
                zbkInputDetail.setCzlx(EnumZBKInputType.ZBBBRK.toValue());
                zbkInputDetail.setZblx(tag);
                zbkInputDetail.setGdmj(spatialDetail.getTbdlmj());
                if (spatialDetail.getDlbm().equals("0101")) {
                    zbkInputDetail.setStmj(spatialDetail.getTbdlmj());
                }
                zbkInputDetail.setCnzb(0.0);
                zbkInputDetail.setGddb(spatialDetail.getGddb() == null ? 0.0 : spatialDetail.getGddb());
                zbkInputDetail.setDlmc(spatialDetail.getDlmc());
                zbkInputDetail.setDlbm(spatialDetail.getDlbm());
                zbkInputDetail.setXmbh(spatialDetail.getTbbh());
                zbkInputDetail.setXmmc(spatialDetail.getTbbh());
                zbkInputDetail.setXmjgysrq(now);
                zbkInputDetail.setDkbh(spatialDetail.getTbbh());
                zbkInputDetail.setDkid(spatialDetail.getXmid());
                zbkInputDetail.setDkmc(spatialDetail.getTbbh());
                zbkInputDetail.setUsername(sysUser.getAlisname());
                zbkInputDetail.setUserid(sysUser.getId());
                zbkInputDetail.setRklx(EnumZBKInputMethod.TBRK.toValue());
                ZBKSpatialDetail zbkSpatialDetail = new ZBKSpatialDetail();
                zbkSpatialDetail.setDlbm(spatialDetail.getDlbm());
                zbkSpatialDetail.setDlmc(spatialDetail.getDlmc());
                zbkSpatialDetail.setQdlbm("");
                zbkSpatialDetail.setQdlmc("");
                zbkSpatialDetail.setTbmj(spatialDetail.getTbdlmj());
                zbkSpatialDetail.setShape(spatialDetail.getShape());
                dto.setZbkInputDetail(zbkInputDetail);
                dto.setZbkSpatialDetail(zbkSpatialDetail);
                inputDTOS.add(dto);
            }
        }
        ZbkTbrkDetail template = new ZbkTbrkDetail();
        String rklsh = "";
        if (inputDTOS.size() > 0) {
            LockUtil lockUtil = (LockUtil)SpringContextUtil.getBean(LockUtil.class);
            Map<String, List<ZBKInputDTO>> groupByResult = inputDTOS.stream().collect(Collectors.groupingBy(f -> f.getZbkInputDetail().getZbxzqdm()));
            for (Map.Entry<String, List<ZBKInputDTO>> kv : groupByResult.entrySet()) {
                lockUtil.getLock("TBRK" + kv.getKey());
                ZBKConfigDetail configDetail = this.zbkConfigDetailService.findByXzqdm(kv.getKey()).stream().filter(f -> f.getType().equals(EnumZBKPzType.XFSZBRKSX.toValue())).findFirst().orElse(null);
                if (configDetail == null) {
                    throw new RuntimeException(" \u5165\u5e93\u6d89\u53ca\u7684\u884c\u653f\u533a\u672a\u914d\u7f6e\u5165\u5e93\u4e0a\u9650");
                }
                if (!(this.getTotalYrk(kv.getKey()) + kv.getValue().stream().mapToDouble(f -> f.getZbkInputDetail().getGdmj()).sum() > configDetail.getValue())) continue;
                throw new RuntimeException(" \u8d85\u8fc7\u5f53\u524d\u7528\u6237\u7684\u6240\u5728\u884c\u653f\u533a\u5212\u7684\u5165\u5e93\u4e0a\u9650");
            }
            template.setRklx(tag);
            rklsh = this.zbkManagerService.input(inputDTOS);
        }
        System.out.println("\u56fe\u6591\u5165\u6307\u6807\u5e93\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        template.setRklsh(rklsh);
        template.setProcessState(curStep.getProcessState());
        template.setProcessStateStr(curStep.getProcessStateStr());
        template.setUpdateDate(DateUtil.now());
        List<String> xmids = details.stream().map(f -> f.getXmid()).collect(Collectors.toList());
        start = System.currentTimeMillis();
        this.updateByIds(xmids, template);
        System.out.println("\u4fee\u6539\u9879\u76ee\u72b6\u6001\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
    }

    @Override
    public Map<String, Map<String, String>> getProcessStateMap(SysUser sysUser, String group) {
        Map<EnumProcessStateType, Map<String, String>> temp = this.processModelService.getProcessStateMap(sysUser, group);
        Map<String, String> beforeInnerCheck = this.processModelService.getBeforeProcessStates(group, "p01");
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        temp.forEach((k, v) -> result.put(k.toValue(), (Map<String, String>)v));
        result.put("beforeInnerCheck", beforeInnerCheck);
        return result;
    }
}

