/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zbkhandler.impl;

import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKOutputType;
import com.geoway.onemap.zbph.domain.zbkkj.ZbkkjXmxx;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKDKDetail;
import com.geoway.onemap.zbph.domain.zxxdflzygd.ZxxdFLZygdBcgdDetail;
import com.geoway.onemap.zbph.dto.zbkmanager.ZBKOutputDTO;
import com.geoway.onemap.zbph.service.zbkhandler.ZbkReduceHandler;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDKDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKManagerService;
import com.geoway.onemap.zbph.service.zbkmanager.impl.ZBKOutputUtil;
import com.geoway.onemap.zbph.service.zbtj.kj.ZbkkjXmxxService;
import com.geoway.onemap.zbph.service.zxxdflzygd.ZxxdFLZygdBcgdDetailService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZbkReduceHandlerImpl
implements ZbkReduceHandler {
    @Autowired
    private ZxxdFLZygdBcgdDetailService zxxdFlZygdBcgdDetailService;
    @Autowired
    private ZBKDKDetailService zbkdkDetailService;
    @Autowired
    private ZBKManagerService zbkManagerService;
    @Autowired
    private ZbkkjXmxxService xmxxService;

    @Override
    public void reduce(ZbkkjXmxx zbkkjXmxx, SysUser sysUser) {
        List<ZxxdFLZygdBcgdDetail> bcgdList = this.zxxdFlZygdBcgdDetailService.findByXmbh(zbkkjXmxx.getXmbh());
        ArrayList<ZBKOutputDTO> outputDTOS = new ArrayList<ZBKOutputDTO>();
        for (ZxxdFLZygdBcgdDetail bcgdDetail : bcgdList) {
            List<ZBKDKDetail> zbkdkDetails = this.zbkdkDetailService.findListByDkbh(bcgdDetail.getDkbh());
            zbkdkDetails = zbkdkDetails.stream().sorted(Comparator.comparing(ZBKDKDetail::getDate).thenComparing(ZBKDKDetail::getGdmjsy)).collect(Collectors.toList());
            List<ZBKOutputDTO> tempOutput = ZBKOutputUtil.getZBKOutputDTOs(zbkdkDetails, bcgdDetail.getBcmj(), 0.0);
            tempOutput.forEach(zbkOutputDTO -> {
                zbkOutputDTO.setCzxzqdm(sysUser.getXzqdm());
                zbkOutputDTO.setCzxzqmc(sysUser.getFullXzqmc());
                zbkOutputDTO.setCzlx(EnumZBKOutputType.BCGDHJCK.toValue());
                zbkOutputDTO.setXmbh(zbkkjXmxx.getXmbh());
                zbkOutputDTO.setXmmc(zbkkjXmxx.getXmmc());
                zbkOutputDTO.setUserid(zbkkjXmxx.getUserId());
                zbkOutputDTO.setUsername(zbkkjXmxx.getUserName());
            });
            outputDTOS.addAll(tempOutput);
        }
        String lsh = this.zbkManagerService.output(outputDTOS);
        zbkkjXmxx.setKjsid(lsh);
    }

    @Override
    public void revert(ZbkkjXmxx zbkkjXmxx, SysUser sysUser) {
        ZbkkjXmxx temp = (ZbkkjXmxx)this.xmxxService.findById(zbkkjXmxx.getXmid());
        String lsh = this.zbkManagerService.revertOutput(temp.getKjsid(), sysUser);
        zbkkjXmxx.setCxsid(lsh);
    }
}

