/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.service.zbkhandler.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKInputType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKOutputType;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKDkOutputDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKInputDetail;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKOutputDetail;
import com.geoway.onemap.zbph.domain.zbtj.Zbhz;
import com.geoway.onemap.zbph.dto.zbkmanager.ZBKInputDTO;
import com.geoway.onemap.zbph.dto.zbkmanager.ZBKOutputDTO;
import com.geoway.onemap.zbph.service.zbkhandler.ZbkTransferHandler;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKDkOutputDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKInputDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKManagerService;
import com.geoway.onemap.zbph.service.zbkmanager.ZBKOutputDetailService;
import com.geoway.onemap.zbph.service.zbkmanager.impl.ZBKOutputUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ZbkTransferHandlerImpl
implements ZbkTransferHandler {
    @Value(value="${project.inputZbkSpatial.enable:false}")
    private Boolean inputZbkSpatialEnable;
    @Autowired
    private ZBKInputDetailService zbkInputDetailService;
    @Autowired
    private ZBKOutputDetailService zbkOutputDetailService;
    @Autowired
    private ZBKManagerService zbkManagerService;
    @Autowired
    private ZBKDkOutputDetailService zbkdkOutputDetailService;

    @Override
    public void transfer(Zbhz zbhz, SysUser sysUser) {
        String xzqin = zbhz.getHrXzqdm();
        String xzqinName = zbhz.getHrXzqmc();
        List<ZBKOutputUtil.ZBKOutputParam> outputParams = this.getZBKOutputParams(zbhz);
        List<ZBKOutputDTO> zbkOutputDTOS = ZBKOutputUtil.getZBKOutputDTOs(outputParams, zbhz.getLscn());
        ArrayList<ZBKInputDTO> zbkInputDTOS = new ArrayList<ZBKInputDTO>();
        for (ZBKOutputDTO zbkOutputDTO : zbkOutputDTOS) {
            zbkOutputDTO.setCzlx(this.getOutputType(zbhz, false).toValue());
            zbkOutputDTO.setCzxzqdm(sysUser.getXzqdm());
            zbkOutputDTO.setCzxzqmc(sysUser.getFullXzqmc());
            zbkOutputDTO.setCkxzqdm(xzqin);
            zbkOutputDTO.setCkxzqmc(xzqinName);
            zbkOutputDTO.setUserid(sysUser.getId());
            zbkOutputDTO.setUsername(sysUser.getAlisname());
            zbkOutputDTO.setXmmc(zbkOutputDTO.getZbkdkDetail().getXmmc());
            zbkOutputDTO.setXmbh(zbkOutputDTO.getZbkdkDetail().getXmbh());
        }
        String cklsh = this.zbkManagerService.output(zbkOutputDTOS);
        List<ZBKOutputDetail> outputDetails = this.zbkOutputDetailService.findListBySid(cklsh);
        List<ZBKInputDetail> inputDetails = this.zbkInputDetailService.findByZbids(outputDetails.stream().map(f -> f.getZbid()).collect(Collectors.toList()));
        for (ZBKOutputDetail outputDetail : outputDetails) {
            ZBKInputDetail tempInputDetail = inputDetails.stream().filter(f -> f.getId().equals(outputDetail.getZbid())).findFirst().orElse(null);
            ZBKInputDetail zbkInputDetail = new ZBKInputDetail();
            BeanUtil.copyProperties((Object)tempInputDetail, (Object)zbkInputDetail, (String[])new String[0]);
            zbkInputDetail.setCzlx(this.getInputType(zbhz, false).toValue());
            zbkInputDetail.setUserid(sysUser.getId());
            zbkInputDetail.setUsername(sysUser.getAlisname());
            zbkInputDetail.setCzxzqdm(sysUser.getXzqdm());
            zbkInputDetail.setCzxzqmc(sysUser.getFullXzqmc());
            zbkInputDetail.setZbxzqdm(xzqin);
            zbkInputDetail.setZbxzqmc(xzqinName);
            zbkInputDetail.setCnzb(outputDetail.getCnzb());
            zbkInputDetail.setGdmj(outputDetail.getGdmj());
            zbkInputDetail.setStmj(outputDetail.getStmj());
            zbkInputDetail.setSrcid(outputDetail.getId());
            if (this.inputZbkSpatialEnable.booleanValue()) {
                ZBKDkOutputDetail zbkDkOutputDetail = this.zbkdkOutputDetailService.findByCkmxid(outputDetail.getId());
                if (zbkDkOutputDetail.getGdShape() != null) {
                    zbkInputDetail.setGdShape(zbkDkOutputDetail.getGdShape());
                }
                if (zbkDkOutputDetail.getStShape() != null) {
                    zbkInputDetail.setStShape(zbkDkOutputDetail.getStShape());
                }
                if (zbkDkOutputDetail.getCnzbShape() != null) {
                    zbkInputDetail.setCnzbShape(zbkDkOutputDetail.getCnzbShape());
                }
            }
            ZBKInputDTO zbkInputDTO = new ZBKInputDTO();
            zbkInputDTO.setZbkInputDetail(zbkInputDetail);
            zbkInputDTOS.add(zbkInputDTO);
        }
        String rklsh = this.zbkManagerService.input(zbkInputDTOS);
        zbhz.setHzcklsh(cklsh);
        zbhz.setHzrklsh(rklsh);
    }

    protected List<ZBKOutputUtil.ZBKOutputParam> getZBKOutputParams(Zbhz zbdj) {
        ZBKOutputUtil.ZBKOutputParam outputParam;
        String sortParam;
        String filterParam;
        ArrayList<ZBKOutputUtil.ZBKOutputParam> results = new ArrayList<ZBKOutputUtil.ZBKOutputParam>();
        if (zbdj.getZbgm0101() > 0.0 || zbdj.getZbgm0102() > 0.0 || zbdj.getZbgm0103() > 0.0) {
            if (zbdj.getZbgm0101() > 0.0) {
                filterParam = String.format("Q_zblx_S_IN=%s;Q_zbxzqdm_S_EQ=%s;Q_dlbm_S_EQ=%s", zbdj.getZblx(), zbdj.getHcXzqdm(), "0101");
                sortParam = "SORT_date_ASC;SORT_gdmjsy_ASC";
                outputParam = new ZBKOutputUtil.ZBKOutputParam();
                outputParam.setSortParam(sortParam);
                outputParam.setFilterParam(filterParam);
                outputParam.setStmj(0.0);
                outputParam.setGdmj(zbdj.getZbgm0101());
                results.add(outputParam);
            }
            if (zbdj.getZbgm0102() > 0.0) {
                filterParam = String.format("Q_zblx_S_IN=%s;Q_zbxzqdm_S_EQ=%s;Q_dlbm_S_EQ=%s", zbdj.getZblx(), zbdj.getHcXzqdm(), "0102");
                sortParam = "SORT_date_ASC;SORT_gdmjsy_ASC";
                outputParam = new ZBKOutputUtil.ZBKOutputParam();
                outputParam.setSortParam(sortParam);
                outputParam.setFilterParam(filterParam);
                outputParam.setStmj(0.0);
                outputParam.setGdmj(zbdj.getZbgm0102());
                results.add(outputParam);
            }
            if (zbdj.getZbgm0103() > 0.0) {
                filterParam = String.format("Q_zblx_S_IN=%s;Q_zbxzqdm_S_EQ=%s;Q_dlbm_S_EQ=%s", zbdj.getZblx(), zbdj.getHcXzqdm(), "0103");
                sortParam = "SORT_date_ASC;SORT_gdmjsy_ASC";
                outputParam = new ZBKOutputUtil.ZBKOutputParam();
                outputParam.setSortParam(sortParam);
                outputParam.setFilterParam(filterParam);
                outputParam.setGdmj(zbdj.getZbgm0103());
                outputParam.setStmj(0.0);
                results.add(outputParam);
            }
            if (zbdj.getStgm() > 0.0) {
                filterParam = String.format("Q_zblx_S_IN=%s;Q_zbxzqdm_S_EQ=%s", zbdj.getZblx(), zbdj.getHcXzqdm());
                sortParam = "SORT_date_ASC;SORT_gdmjsy_ASC";
                outputParam = new ZBKOutputUtil.ZBKOutputParam();
                outputParam.setSortParam(sortParam);
                outputParam.setFilterParam(filterParam);
                outputParam.setStmj(zbdj.getStgm());
                outputParam.setGdmj(0.0);
                results.add(outputParam);
            }
        } else {
            filterParam = String.format("Q_zblx_S_IN=%s;Q_zbxzqdm_S_EQ=%s", zbdj.getZblx(), zbdj.getHcXzqdm());
            sortParam = "SORT_date_ASC;SORT_gdmjsy_ASC;";
            outputParam = new ZBKOutputUtil.ZBKOutputParam();
            outputParam.setSortParam(sortParam);
            outputParam.setFilterParam(filterParam);
            outputParam.setStmj(zbdj.getStgm());
            outputParam.setGdmj(zbdj.getZbgm());
            results.add(outputParam);
        }
        if (zbdj.getLscn() > 0.0) {
            filterParam = String.format("Q_zblx_S_IN=%s;Q_zbxzqdm_S_EQ=%s", zbdj.getZblx(), zbdj.getHcXzqdm());
            sortParam = "SORT_date_ASC;SORT_cnzbsy_ASC";
            outputParam = new ZBKOutputUtil.ZBKOutputParam();
            outputParam.setSortParam(sortParam);
            outputParam.setFilterParam(filterParam);
            outputParam.setStmj(0.0);
            outputParam.setGdmj(0.0);
            results.add(outputParam);
        }
        return results;
    }

    private EnumZBKOutputType getOutputType(Zbhz zbhz, boolean revert) {
        if (!revert) {
            if (zbhz.getHcXzqdm().substring(0, 4).equals(zbhz.getHrXzqdm().substring(0, 4))) {
                return EnumZBKOutputType.SNKXTJCK;
            }
            return EnumZBKOutputType.SNKSTJCK;
        }
        return EnumZBKOutputType.CXTJCK;
    }

    private EnumZBKInputType getInputType(Zbhz zbhz, boolean revert) {
        if (!revert) {
            if (zbhz.getHcXzqdm().substring(0, 4).equals(zbhz.getHrXzqdm().substring(0, 4))) {
                return EnumZBKInputType.SNKXTJRK;
            }
            return EnumZBKInputType.SNKSTJRK;
        }
        return EnumZBKInputType.CXTJRK;
    }

    @Override
    public void revert(Zbhz zbhz, SysUser sysUser) {
        String xzqout = zbhz.getHcXzqdm();
        String xzqoutName = zbhz.getHcXzqmc();
        if (StrUtil.isBlank((CharSequence)zbhz.getHzcklsh()) || StrUtil.isBlank((CharSequence)zbhz.getHzrklsh())) {
            throw new RuntimeException("\u5c1a\u672a\u8fdb\u884c\u5212\u8f6c\u64cd\u4f5c\uff0c\u65e0\u9700\u64a4\u9500\uff01");
        }
        String hzrklsh = zbhz.getHzrklsh();
        String hzcklsh = zbhz.getHzcklsh();
        String cxrklsh = this.zbkManagerService.revertInput(hzrklsh, sysUser);
        String cxcklsh = this.zbkManagerService.revertOutput(hzcklsh, sysUser);
        zbhz.setCxrklsh(cxrklsh);
        zbhz.setCxcklsh(cxcklsh);
    }
}

