/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.supoort;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.RowWriteHandler;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class EasyExcelUtil
implements RowWriteHandler {
    private int mergeRowIndex;
    private int[] mergeColumnIndex;
    private int[] signNum;
    private int total;
    private int lastRow;
    private int firstCol;
    private int lastCol;
    private int firstRow;
    private int mergeCount = 1;

    private EasyExcelUtil() {
    }

    private EasyExcelUtil(int mergeRowIndex, int[] mergeColumnIndex, int[] signNum, int total) {
        this.mergeRowIndex = mergeRowIndex;
        this.mergeColumnIndex = mergeColumnIndex;
        this.signNum = signNum;
        this.total = total;
    }

    public static <T> void createExcel(HttpServletResponse response, String fileName, List<T> exportList, Class<T> clazz) throws IOException {
        EasyExcelUtil.createExcel(response, fileName, exportList, clazz, null);
    }

    public static <T> void createExcel(HttpServletResponse response, String fileName, List<List<String>> headers, List<List<Object>> datas) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String utf8fileName = URLEncoder.encode(fileName, "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + utf8fileName + ".xlsx");
        ExcelWriterSheetBuilder excelWriterSheetBuilder = EasyExcel.write((OutputStream)response.getOutputStream()).head(headers).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy()).sheet(fileName);
        excelWriterSheetBuilder.doWrite(datas);
    }

    public static <T> void createExcel(HttpServletResponse response, String fileName, String template, List datas) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String utf8fileName = URLEncoder.encode(fileName, "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + utf8fileName + ".xlsx");
        ExcelWriterSheetBuilder excelWriterSheetBuilder = EasyExcel.write((OutputStream)response.getOutputStream()).withTemplate(template).sheet(fileName);
        excelWriterSheetBuilder.doFill((Object)datas);
    }

    public static List<List<String>> readWithoutHead(InputStream inputStream) {
        StringExcelListener listener = new StringExcelListener();
        ExcelReader excelReader = EasyExcelFactory.read((InputStream)inputStream, null, (ReadListener)listener).headRowNumber(Integer.valueOf(0)).build();
        excelReader.read();
        List<List<String>> datas = listener.getDatas();
        excelReader.finish();
        return datas;
    }

    public static <T> void createExcel(HttpServletResponse response, String fileName, List<T> exportList, Class<T> clazz, CellMerge cellMerge) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String utf8fileName = URLEncoder.encode(fileName, "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + utf8fileName + ".xlsx");
        ExcelWriterSheetBuilder excelWriterSheetBuilder = null;
        excelWriterSheetBuilder = clazz != null ? EasyExcel.write((OutputStream)response.getOutputStream(), clazz).sheet(fileName) : EasyExcel.write((OutputStream)response.getOutputStream()).sheet(fileName);
        if (cellMerge != null) {
            int mergeRowIndex = 1;
            EasyExcelUtil excelMergeRowByRowStrategy = new EasyExcelUtil(mergeRowIndex, cellMerge.getMergeColumIndex(), cellMerge.getMergeRuleColumIndex(), exportList.size());
            excelWriterSheetBuilder.registerWriteHandler((WriteHandler)excelMergeRowByRowStrategy);
        }
        excelWriterSheetBuilder.doWrite(exportList);
    }

    public void beforeRowCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Integer integer, Integer integer1, Boolean aBoolean) {
    }

    public void afterRowCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Integer integer, Boolean aBoolean) {
    }

    public void afterRowDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Integer relativeRowIndex, Boolean isHead) {
        int curRowIndex = row.getRowNum();
        int lastCellNum = row.getLastCellNum();
        if (curRowIndex == 1) {
            this.firstRow = curRowIndex;
        }
        if (curRowIndex > this.mergeRowIndex && !row.getCell(0).getStringCellValue().equals("")) {
            for (int i = 0; i < lastCellNum; ++i) {
                if (i != this.mergeColumnIndex[i]) continue;
                this.mergeWithPrevAnyRow(writeSheetHolder.getSheet(), curRowIndex, row, this.signNum);
                break;
            }
        }
    }

    public void mergeWithPrevAnyRow(Sheet sheet, int curRowIndex, Row row, int[] signNum) {
        String preDataStr;
        Row preRow = row.getSheet().getRow(curRowIndex - 1);
        ArrayList<String> rowDataList = new ArrayList<String>();
        ArrayList<String> preDataList = new ArrayList<String>();
        for (int i : signNum) {
            Object currentData = row.getCell(i).getCellTypeEnum() == CellType.STRING ? row.getCell(i).getStringCellValue() : Double.valueOf(row.getCell(i).getNumericCellValue());
            Object preData = preRow.getCell(i).getCellTypeEnum() == CellType.STRING ? preRow.getCell(i).getStringCellValue() : Double.valueOf(preRow.getCell(i).getNumericCellValue());
            rowDataList.add(String.valueOf(currentData));
            preDataList.add(String.valueOf(preData));
        }
        String rowDataStr = String.join((CharSequence)",", rowDataList);
        boolean curEqualsPre = rowDataStr.equals(preDataStr = String.join((CharSequence)",", preDataList));
        if (curEqualsPre) {
            this.lastRow = curRowIndex;
            ++this.mergeCount;
        }
        if (!curEqualsPre && this.mergeCount > 1) {
            this.mergeSheet(this.firstRow, this.lastRow, this.mergeColumnIndex, sheet);
            this.mergeCount = 1;
        }
        if (this.mergeCount > 1 && this.total == curRowIndex) {
            this.mergeSheet(this.firstRow, this.lastRow, this.mergeColumnIndex, sheet);
            this.mergeCount = 1;
        }
        if (!curEqualsPre) {
            this.firstRow = curRowIndex;
        }
    }

    private void mergeSheet(int firstRow, int lastRow, int[] mergeColumnIndex, Sheet sheet) {
        int[] nArray = mergeColumnIndex;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int colNum;
            this.firstCol = colNum = nArray[i];
            this.lastCol = colNum;
            CellRangeAddress cellRangeAddress = new CellRangeAddress(firstRow, lastRow, this.firstCol, this.lastCol);
            sheet.addMergedRegion(cellRangeAddress);
        }
    }

    public static CellMerge setCellMerge(int[] mergeColumIndex, int[] mergeRuleColumIndex) {
        EasyExcelUtil excelUtil = new EasyExcelUtil();
        CellMerge cellMerge = excelUtil.new CellMerge();
        cellMerge.setMergeColumIndex(mergeColumIndex);
        cellMerge.setMergeRuleColumIndex(mergeRuleColumIndex);
        return cellMerge;
    }

    public static List<Map<String, Object>> getMap(String fileName) {
        final ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        EasyExcel.read((String)fileName, (ReadListener)new AnalysisEventListener<Map<String, Object>>(){
            private Map<Integer, String> headMap;

            public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
                this.headMap = headMap;
            }

            public void invoke(Map<String, Object> valueData, AnalysisContext context) {
                HashMap<String, Object> paramsMap = new HashMap<String, Object>();
                for (int i = 0; i < valueData.size(); ++i) {
                    String key = this.headMap.get(i);
                    Object value = valueData.get(i);
                    paramsMap.put(key, value);
                }
                dataList.add(paramsMap);
            }

            public void doAfterAllAnalysed(AnalysisContext analysisContext) {
            }
        }).sheet().doRead();
        return dataList;
    }

    public class CellMerge {
        private int[] mergeColumIndex;
        private int[] mergeRuleColumIndex;

        public int[] getMergeColumIndex() {
            return this.mergeColumIndex;
        }

        public int[] getMergeRuleColumIndex() {
            return this.mergeRuleColumIndex;
        }

        public void setMergeColumIndex(int[] mergeColumIndex) {
            this.mergeColumIndex = mergeColumIndex;
        }

        public void setMergeRuleColumIndex(int[] mergeRuleColumIndex) {
            this.mergeRuleColumIndex = mergeRuleColumIndex;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CellMerge)) {
                return false;
            }
            CellMerge other = (CellMerge)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getMergeColumIndex(), other.getMergeColumIndex())) {
                return false;
            }
            return Arrays.equals(this.getMergeRuleColumIndex(), other.getMergeRuleColumIndex());
        }

        protected boolean canEqual(Object other) {
            return other instanceof CellMerge;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getMergeColumIndex());
            result = result * 59 + Arrays.hashCode(this.getMergeRuleColumIndex());
            return result;
        }

        public String toString() {
            return "EasyExcelUtil.CellMerge(mergeColumIndex=" + Arrays.toString(this.getMergeColumIndex()) + ", mergeRuleColumIndex=" + Arrays.toString(this.getMergeRuleColumIndex()) + ")";
        }

        public CellMerge(int[] mergeColumIndex, int[] mergeRuleColumIndex) {
            this.mergeColumIndex = mergeColumIndex;
            this.mergeRuleColumIndex = mergeRuleColumIndex;
        }

        public CellMerge() {
        }
    }

    private static class StringExcelListener
    extends AnalysisEventListener {
        private List<List<String>> datas = new ArrayList<List<String>>();

        private StringExcelListener() {
        }

        public void invoke(Object object, AnalysisContext context) {
            HashMap stringMap = (HashMap)object;
            System.out.println("\u4e0d\u4e00\u5b9a\u5341\u5206\u51c6\u786e\u7684\u603b\u884c\u6570\uff1a" + context.getTotalCount());
            this.datas.add(new ArrayList(stringMap.values()));
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }

        public List<List<String>> getDatas() {
            return this.datas;
        }

        public void setDatas(List<List<String>> datas) {
            this.datas = datas;
        }
    }
}

