/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onemap.zbph.supoort;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class GtyGWApiUtil {
    private static final Logger log = LoggerFactory.getLogger(GtyGWApiUtil.class);
    @Autowired
    private RedisTemplate redisTemplate;
    private final String GTY_TOKEN = "gty_token";
    @Value(value="${project.gty.dir:''}")
    protected String gtyDir;
    @Value(value="${gty.base.url:'https://www.landcloud.org.cn:9553'}")
    protected String gtyUrl;
    @Value(value="${gty.token.url:'/mdc/v2/auth/tokenByKey'}")
    protected String gtyTokenUrl;
    @Value(value="${gty.store.url:'/mdc/v2/storage/tempurl'}")
    protected String gtyStore;
    @Value(value="${gty.notice.url:'/mdc/v2/taskData/gty'}")
    protected String noticeStore;
    @Value(value="${gty.import.log.url:'/mdc/v2/taskData/import/log'}")
    protected String importLog;
    @Value(value="${gty.queryresult.url:'/mdc/v2/taskData/queryDataDetail2'}")
    protected String queryResult;
    @Value(value="${gty.ak:'gwbe549e73-7d2b-4a5d-b090-450b22505ed0'}")
    protected String appKey;
    @Value(value="${gty.sk:'0a18f48-4f97-4559-9624-353752757dd2'}")
    protected String appSecret;
    @Value(value="${gty.bizId:'6c0f1af9-747a-4cc0-9652-4ae31ee3179f'}")
    protected String bizId;

    public String getToken() {
        String token = null;
        Object obj = this.redisTemplate.opsForValue().get((Object)"gty_token");
        if (obj != null) {
            JSONObject jsonObject = JSON.parseObject((String)obj.toString());
            Long currTime = System.currentTimeMillis();
            Long expireTime = jsonObject.getLong("expireTime");
            if (currTime - 5000L > expireTime) {
                JSONObject tokenInfo = this.httpGetToken();
                if (tokenInfo != null) {
                    token = tokenInfo.getString("accessToken");
                    this.redisTemplate.opsForValue().set((Object)"gty_token", (Object)JSON.toJSONString((Object)tokenInfo));
                }
            } else {
                token = jsonObject.getString("accessToken");
            }
        } else {
            JSONObject tokenInfo = this.httpGetToken();
            token = tokenInfo.getString("accessToken");
            this.redisTemplate.opsForValue().set((Object)"gty_token", (Object)JSON.toJSONString((Object)tokenInfo));
        }
        return token;
    }

    private JSONObject httpGetToken() {
        HttpRequest post = HttpUtil.createPost((String)(this.gtyUrl + this.gtyTokenUrl));
        post.header("appKey", this.appKey);
        post.header("appSecret", this.appSecret);
        return (JSONObject)this.getRes(post.execute(), this.gtyTokenUrl, null);
    }

    private Object getRes(HttpResponse execute, String path, Class clazz) {
        JSONObject jsonObject = JSONObject.parseObject((String)execute.body());
        String status = jsonObject.getString("status");
        if (!"true".equalsIgnoreCase(status)) {
            throw new RuntimeException("gty\u63a5\u53e3\u3010" + path + "\u3011\u8bf7\u6c42\u5f02\u5e38\uff0c" + jsonObject.getString("msg"));
        }
        return clazz == null ? jsonObject.getJSONObject("data") : jsonObject.getObject("data", clazz);
    }

    private HttpRequest getRequest(String path, Method method) {
        HttpRequest request = HttpUtil.createRequest((Method)method, (String)(this.gtyUrl + path));
        request.header("sysToken", this.getToken());
        log.info("\u8bf7\u6c42\u5730\u5740:{}\uff0csystoken: {}", (Object)(this.gtyUrl + path), (Object)this.getToken());
        return request;
    }

    public JSONObject queryResult(String bsm) {
        HttpRequest request = this.getRequest(this.queryResult, Method.POST);
        request.form("bizId", (Object)this.bizId);
        request.form("bsm", (Object)bsm);
        return (JSONObject)this.getRes(request.execute(), this.queryResult, null);
    }

    public JSONObject getImportResult(String id) {
        HttpRequest request = this.getRequest(this.importLog, Method.GET);
        request.form("id", (Object)id);
        return (JSONObject)this.getRes(request.execute(), this.importLog, null);
    }

    public JSONObject getTempUrl() {
        HttpRequest request = this.getRequest(this.gtyStore, Method.POST);
        request.body("{\"type\":\"gty\"}");
        return (JSONObject)this.getRes(request.execute(), this.gtyStore, null);
    }

    public String notice(String readUrl, String fileName, String filemd5) {
        HttpRequest request = this.getRequest(this.noticeStore, Method.POST);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bizId", this.bizId);
        map.put("filePath", readUrl);
        map.put("fileName", fileName);
        map.put("hash", filemd5);
        map.put("updateType", "0");
        request.body(JSON.toJSONString(map));
        return (String)this.getRes(request.execute(), this.noticeStore, String.class);
    }
}

