/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action;

import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.onemap.core.domain.system.SysUserBookMark;
import com.geoway.onemap.core.service.system.SysUserBookMarkService;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/bookMark"})
public class UserBookMarkAction {
    private Logger logger = Logger.getLogger(UserBookMarkAction.class);
    @Autowired
    SysUserBookMarkService bookMarkService;

    @RequestMapping(value={"/getBookMarkByUserId.action"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseObjectResponse getBookMarkByUserId(HttpServletRequest request, @RequestParam(value="filter") String filter, @RequestParam(value="page") Integer page, @RequestParam(value="size") Integer size) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            Page list = this.bookMarkService.queryByFilter(filter, page - 1, size.intValue());
            response.setData((Object)list);
        }
        catch (Exception ex) {
            response.setMessage(ex.getMessage());
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/addOneBookMark.action"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseObjectResponse addOneBookMark(HttpServletRequest request, @ModelAttribute SysUserBookMark sysUserBookMark) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            SysUserBookMark bookMark = this.bookMarkService.save(sysUserBookMark);
            response.setData((Object)bookMark);
        }
        catch (Exception ex) {
            response.setMessage(ex.getMessage());
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/deleteBookMarkByUserId.action"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseObjectResponse deleteBookMarkByUserId(HttpServletRequest request, @RequestParam(value="id") String id) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.bookMarkService.delete(id);
        }
        catch (Exception ex) {
            response.setMessage(ex.getMessage());
            response.setStatus("FAILURE");
        }
        return response;
    }
}

