/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.action.workflow;

import com.geoway.acti.service.WorkflowService;
import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.base.dto.EasyUIResponse;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.http.SysUserUtil;
import com.geoway.web.anno.RequireAuth;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/workflow"})
public class WorkflowAction {
    @Resource
    private WorkflowService flowService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;

    @RequestMapping(value={"/deploy.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse deploy(@RequestParam(name="name", required=false) String name, @RequestParam(name="classpathResource", required=false) String classpathResource, @RequestParam(name="token", required=false) String token) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        Deployment deployment = this.repositoryService.createDeployment().name(name).addClasspathResource(classpathResource).deploy();
        baseObjectResponse.setData((Object)deployment);
        return baseObjectResponse;
    }

    @RequireAuth
    @RequestMapping(value={"/startProcess"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse startProcess(HttpServletRequest request, @RequestParam(name="key") String key, @RequestParam(name="businessKey") String businessKey, @RequestParam(name="tableName") String tableName, @RequestParam(name="businessParam", required=false) String businessParam) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            List<String> list = this.flowService.startProcess(key, businessKey, tableName, businessParam, user.getId());
            baseObjectResponse.setData(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseObjectResponse.setStatus("FAILURE");
        }
        return baseObjectResponse;
    }

    @RequestMapping(value={"/claimThenComplete"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @RequireAuth
    public BaseResponse claimThenComplete(HttpServletRequest request, @RequestParam(name="ids") String ids, @RequestParam(name="keyWF", required=false) String keyWF, @RequestParam(name="valueWF", required=false) String valueWF, @RequestParam(name="tableName", required=false) String tableName, @RequestParam(name="businessParam", required=false) String businessParam, @RequestParam(name="otherBusinessParam", required=false) String otherBusinessParam) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            String result = this.flowService.claimThenComplete(ids, keyWF, valueWF, tableName, businessParam, otherBusinessParam, user.getId());
            baseObjectResponse.setData((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseObjectResponse.markFailure();
            baseObjectResponse.setMessage(e.getMessage());
        }
        return baseObjectResponse;
    }

    @RequestMapping(value={"/claimThenCompleteAdmin"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse claimThenCompleteAdmin(HttpServletRequest request, @RequestParam(name="ids") String ids, @RequestParam(name="keyWF", required=false) String keyWF, @RequestParam(name="valueWF", required=false) String valueWF, @RequestParam(name="tableName", required=false) String tableName, @RequestParam(name="businessParam", required=false) String businessParam, @RequestParam(name="otherBusinessParam", required=false) String otherBusinessParam) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            String userId = "1";
            String result = this.flowService.claimThenComplete(ids, keyWF, valueWF, tableName, businessParam, otherBusinessParam, userId);
            baseObjectResponse.setData((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseObjectResponse.markFailure();
            baseObjectResponse.setMessage(e.getMessage());
        }
        return baseObjectResponse;
    }

    @RequestMapping(value={"/startProcessInstanceByKey.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse startProcessInstanceByKey(HttpServletRequest request, @RequestParam(name="key") String key, @RequestParam(name="businessKey") String businessKey, @RequestParam(name="token") String token, @RequestParam(name="state", required=false) Integer state) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            List<String> list = this.flowService.startProcessInstanceByKey(key, businessKey, state, null, user.getId());
            baseObjectResponse.setData(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseObjectResponse.setStatus("FAILURE");
        }
        return baseObjectResponse;
    }

    @RequireAuth
    @RequestMapping(value={"/startProcessInstanceByKey2.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse startProcessInstanceByKey2(HttpServletRequest request, @RequestParam(name="key") String key, @RequestParam(name="businessKey") String businessKey, @RequestParam(name="tableName") String tableName, @RequestParam(name="token") String token, @RequestParam(name="state", required=false) Integer state) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            List<String> list = this.flowService.startProcessInstanceByKey(key, businessKey, state, tableName, user.getId());
            baseObjectResponse.setData(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseObjectResponse.setStatus("FAILURE");
        }
        return baseObjectResponse;
    }

    @RequireAuth
    @RequestMapping(value={"/deleteProcess"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse deleteProcessInstance(HttpServletRequest request, @RequestParam String businessKey, @RequestParam String tableName, @RequestParam(name="state", required=false) Integer state) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
        if (user == null) {
            return BaseObjectResponse.buildFailuaResponse((String)"\u672a\u6388\u6743\u7684\u64cd\u4f5c");
        }
        this.flowService.deleteProcessInstance(businessKey, tableName, state);
        return baseObjectResponse;
    }

    @RequireAuth
    @RequestMapping(value={"/commit.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse commit(HttpServletRequest request, @RequestParam(name="taskId", required=false) String taskId, @RequestParam(name="token", required=false) String token) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            this.taskService.complete(taskId);
            baseObjectResponse.setData((Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            baseObjectResponse.setData((Object)"FAILURE");
        }
        return baseObjectResponse;
    }

    @RequestMapping(value={"/claimAndComplete.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @RequireAuth
    public BaseResponse claimAndComplete(HttpServletRequest request, @RequestParam(name="ids") String ids, @RequestParam(name="keyWF", required=false) String keyWF, @RequestParam(name="valueWF", required=false) String valueWF, @RequestParam(name="tableName", required=false) String tableName) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
        try {
            this.flowService.claimAndComplete(ids, keyWF, valueWF, tableName, user.getId());
            baseObjectResponse.setData((Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            baseObjectResponse.markFailure();
            baseObjectResponse.setMessage(e.getMessage());
        }
        return baseObjectResponse;
    }

    @RequestMapping(value={"/findTasks.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @RequireAuth
    public BaseResponse findTasks(HttpServletRequest request, @RequestParam(name="key", required=false) String key, @RequestParam(name="token", required=false) String token) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            List list = this.taskService.createTaskQuery().taskCandidateOrAssigned(user.getId()).list();
            baseObjectResponse.setData((Object)list);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseObjectResponse.setStatus("FAILURE");
            baseObjectResponse.setMessage(e.getMessage());
        }
        return baseObjectResponse;
    }

    @RequireAuth
    @RequestMapping(value={"/findTaskPages.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findPages(HttpServletRequest request, @RequestParam(name="filterParam", required=false) String filterParam, @RequestParam(name="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(name="page", defaultValue="1") int page, @RequestParam(name="rows", defaultValue="10") int rows, @RequestParam(name="token", required=false) String token, @RequestParam(name="groupCode", required=false) String groupCode, @RequestParam(name="tableName") String tableName, @RequestParam(name="nodeName") String nodeName) {
        EasyUIResponse response = EasyUIResponse.buildSuccessResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            Page<Map<String, Object>> pages = this.flowService.findPages(nodeName, filterParam, tableName, groupCode, sortParam, rows, page, user.getId());
            response.setRows(pages.getContent());
            response.setTotal(Long.valueOf(pages.getTotalElements()));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/processDefinition"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse processDefinition() {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        baseObjectResponse.setData((Object)this.flowService.processDefinition());
        return baseObjectResponse;
    }

    @RequestMapping(value={"/delprocessDefinition/{key}"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse deletebyKey(@PathVariable String key) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        baseObjectResponse.setData((Object)this.flowService.deletebyKey(key));
        return baseObjectResponse;
    }

    @RequestMapping(value={"/processInstance"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseObjectResponse getProcessInstance(@RequestParam(name="key", required=true) String key) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            baseObjectResponse.setData((Object)this.flowService.getProcessInstance(key));
        }
        catch (Exception e) {
            e.printStackTrace();
            baseObjectResponse.setStatus("FAILURE");
        }
        return baseObjectResponse;
    }

    @RequestMapping(value={"/tasks"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseObjectResponse getProcessTaskByNode(@RequestParam(name="key", required=true) String key, @RequestParam(name="nodeName", required=false) String nodeName) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            baseObjectResponse.setData(this.flowService.getProcessTaskByNode(key, nodeName));
        }
        catch (Exception e) {
            e.printStackTrace();
            baseObjectResponse.setStatus("FAILURE");
        }
        return baseObjectResponse;
    }

    @RequestMapping(value={"/deleteProcess/{processId}"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse deleteProcessInstance(@PathVariable String processId) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processId).singleResult();
        if (instance != null) {
            this.runtimeService.deleteProcessInstance(processId, "\u7528\u6237\u64a4\u9500");
            baseObjectResponse.setMessage("\u5df2\u5220\u9664");
        } else {
            baseObjectResponse.markFailure();
            baseObjectResponse.setMessage("\u6d41\u7a0b\u4e0d\u5b58\u5728");
        }
        return baseObjectResponse;
    }

    @RequestMapping(value={"/processHis/{processId}"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse processInstanceHis(@PathVariable String processId) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        List re = this.flowService.processHis(processId);
        baseObjectResponse.setData((Object)re);
        return baseObjectResponse;
    }

    @RequestMapping(value={"/findFHKTaskPages.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findFHKTaskPages(HttpServletRequest request, @RequestParam(name="filterParam", required=false) String filterParam, @RequestParam(name="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(name="page", defaultValue="1") int page, @RequestParam(name="rows", defaultValue="10") int rows, @RequestParam(name="token", required=false) String token, @RequestParam(name="groupCode", required=false) String groupCode, @RequestParam(name="tableName") String tableName, @RequestParam(name="nodeName") String nodeName, @RequestParam(name="type", required=false) String type) {
        EasyUIResponse response = EasyUIResponse.buildSuccessResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            Page<Map<String, Object>> pages = this.flowService.findFHKTaskPages(nodeName, filterParam, tableName, groupCode, sortParam, rows, page, type, user.getId());
            response.setRows(pages.getContent());
            response.setTotal(Long.valueOf(pages.getTotalElements()));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/findJHKTaskPages.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findJHKTaskPages(HttpServletRequest request, @RequestParam(name="filterParam", required=false) String filterParam, @RequestParam(name="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(name="page", defaultValue="1") int page, @RequestParam(name="rows", defaultValue="10") int rows, @RequestParam(name="groupCode", required=false) String groupCode, @RequestParam(name="token", required=false) String token, @RequestParam(name="tableName") String tableName, @RequestParam(name="step") String step) {
        EasyUIResponse response = EasyUIResponse.buildSuccessResponse();
        try {
            SysUser user = SysUserUtil.getSysUser((HttpServletRequest)request);
            Page<Map<String, Object>> pages = this.flowService.findJHKTaskPages(tableName, groupCode, filterParam, sortParam, step, rows, page, user);
            response.setRows(pages.getContent());
            response.setTotal(Long.valueOf(pages.getTotalElements()));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }
}

