/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.stxf.config;

import com.alibaba.druid.pool.DruidDataSource;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class DataSourceConfig {
    @Value(value="${spring.datasource.username}")
    private String username;
    @Value(value="${spring.datasource.password}")
    private String password;
    @Value(value="${spring.datasource.url}")
    private String url;
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverClassName;

    @Bean
    public DataSource dataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setDriverClassName(this.driverClassName);
        dataSource.setUrl(this.url);
        dataSource.setUsername(this.username);
        dataSource.setPassword(this.password);
        dataSource.setInitialSize(5);
        dataSource.setMaxActive(50);
        dataSource.setMinIdle(5);
        dataSource.setMaxActive(10);
        dataSource.setTimeBetweenConnectErrorMillis(10000L);
        dataSource.setMinEvictableIdleTimeMillis(10000L);
        dataSource.setValidationQuery("select 2");
        return dataSource;
    }

    @Bean
    public JdbcTemplate jdbcTemplate(DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }
}

