-- public.tb_zbph_sync_jzzb definition

-- Drop table

-- DROP TABLE public.tb_zbph_sync_jzzb;

CREATE TABLE public.tb_zbph_sync_jzzb (
	f_xzqdm varchar NULL, -- 储备指标行政区代码
	f_xzqmc varchar NULL, -- 储备指标行政区名称
	f_ycbkslzb numeric(20, 4) NULL, -- 原储备库数量指标
	f_ycbkstzb numeric(20, 4) NULL, -- 原储备库水田指标
	f_ycbklscn numeric(20, 4) NULL, -- 原储备库粮食产能
	f_ygjtcslzb numeric(20, 4) NULL, -- 原国家统筹数量指标
	f_ygjtcstzb numeric(20, 4) NULL, -- 原国家统筹水田指标
	f_ygjtclscn numeric(20, 4) NULL, -- 原国家统筹粮食产能
	f_jzsdjslzb numeric(20, 4) NULL, -- 结转时冻结未解冻数量指标
	f_jzsdjstzb numeric(20, 4) NULL, -- 结转时冻结未解冻水田指标
	f_jzsdjlscn numeric(20, 4) NULL, -- 结转时冻结未解冻粮食产能
	f_cnslzb numeric(20, 4) NULL, -- 承诺数量指标
	f_cnstzb numeric(20, 4) NULL, -- 承诺水田指标
	f_cnlscn numeric(20, 4) NULL, -- 承诺粮食产能
	f_jzsd varchar NULL, -- 结转时点
	f_bz varchar NULL, -- 备注
	f_synctime timestamp NULL DEFAULT now(), -- 同步时间
	f_id varchar NULL -- 主键
);
COMMENT ON TABLE public.tb_zbph_sync_jzzb IS '结转指标同步';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_sync_jzzb.f_xzqdm IS '储备指标行政区代码';
COMMENT ON COLUMN public.tb_zbph_sync_jzzb.f_xzqmc IS '储备指标行政区名称';
COMMENT ON COLUMN public.tb_zbph_sync_jzzb.f_ycbkslzb IS '原储备库数量指标';
COMMENT ON COLUMN public.tb_zbph_sync_jzzb.f_ycbkstzb IS '原储备库水田指标';
COMMENT ON COLUMN public.tb_zbph_sync_jzzb.f_ycbklscn IS '原储备库粮食产能';
COMMENT ON COLUMN public.tb_zbph_sync_jzzb.f_ygjtcslzb IS '原国家统筹数量指标';
COMMENT ON COLUMN public.tb_zbph_sync_jzzb.f_ygjtcstzb IS '原国家统筹水田指标';
COMMENT ON COLUMN public.tb_zbph_sync_jzzb.f_ygjtclscn IS '原国家统筹粮食产能';
COMMENT ON COLUMN public.tb_zbph_sync_jzzb.f_jzsdjslzb IS '结转时冻结未解冻数量指标';
COMMENT ON COLUMN public.tb_zbph_sync_jzzb.f_jzsdjstzb IS '结转时冻结未解冻水田指标';
COMMENT ON COLUMN public.tb_zbph_sync_jzzb.f_jzsdjlscn IS '结转时冻结未解冻粮食产能';
COMMENT ON COLUMN public.tb_zbph_sync_jzzb.f_cnslzb IS '承诺数量指标';
COMMENT ON COLUMN public.tb_zbph_sync_jzzb.f_cnstzb IS '承诺水田指标';
COMMENT ON COLUMN public.tb_zbph_sync_jzzb.f_cnlscn IS '承诺粮食产能';
COMMENT ON COLUMN public.tb_zbph_sync_jzzb.f_jzsd IS '结转时点';
COMMENT ON COLUMN public.tb_zbph_sync_jzzb.f_bz IS '备注';
COMMENT ON COLUMN public.tb_zbph_sync_jzzb.f_synctime IS '同步时间';
COMMENT ON COLUMN public.tb_zbph_sync_jzzb.f_id IS '主键';

-- public.tb_zbph_sync_hiszb definition

-- Drop table

-- DROP TABLE public.tb_zbph_sync_hiszb;

CREATE TABLE public.tb_zbph_sync_hiszb (
	f_lsh varchar NULL, -- 流水号
	f_cbzbxzqdm varchar NULL, -- 储备指标行政区代码
	f_cbzbxzqmc varchar NULL, -- 储备指标行政区名称
	f_czxzqdm varchar NULL, -- 操作行政区代码
	f_czxzqmc varchar NULL, -- 操作行政区名称
	f_czlx varchar NULL, -- 操作类型
	f_zblx varchar NULL, -- 指标类型
	f_zbgm numeric(20, 4) NULL, -- 指标规模
	f_stgm numeric(20, 4) NULL, -- 水田规模
	f_lscn numeric(20, 4) NULL, -- 粮食产量
	f_czr varchar NULL, -- 操作人
	f_zy varchar NULL, -- 摘要
	f_czrq varchar NULL, -- 操作日期
	f_czlxzw varchar NULL, -- 操作类型名称
	f_zblxzw varchar NULL, -- 指标类型名称
	f_jczlxmc varchar NULL, -- 旧操作类型名称
	f_yy varchar NULL, -- 核减冻结原因
	f_cjrq timestamp NULL, -- 创建日期
	f_synctime timestamp NULL DEFAULT now(), -- 同步时间
	f_id varchar NULL -- 主键
);
COMMENT ON TABLE public.tb_zbph_sync_hiszb IS '部系统历史指标';

-- Column comments

COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_lsh IS '流水号';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_cbzbxzqdm IS '储备指标行政区代码';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_cbzbxzqmc IS '储备指标行政区名称';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_czxzqdm IS '操作行政区代码';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_czxzqmc IS '操作行政区名称';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_czlx IS '操作类型';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_zblx IS '指标类型';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_zbgm IS '指标规模';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_stgm IS '水田规模';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_lscn IS '粮食产量';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_czr IS '操作人';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_zy IS '摘要';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_czrq IS '操作日期';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_czlxzw IS '操作类型名称';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_zblxzw IS '指标类型名称';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_jczlxmc IS '旧操作类型名称';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_yy IS '核减冻结原因';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_cjrq IS '创建日期';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_synctime IS '同步时间';
COMMENT ON COLUMN public.tb_zbph_sync_hiszb.f_id IS '主键';