/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.schedual.scheduler;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.onemap.core.domain.Region;
import com.geoway.onemap.core.service.RegionService;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKInputType;
import com.geoway.onemap.zbph.constant.zbkmanager.EnumZBKOutputType;
import com.geoway.onemap.zbph.dao.zbkmanager.ZBKInputDetailRepository;
import com.geoway.onemap.zbph.dao.zbkmanager.ZBKOperateDetailRepository;
import com.geoway.onemap.zbph.dao.zbkmanager.ZBKOutputDetailRepository;
import com.geoway.onemap.zbph.domain.zbkmanager.ZBKOperateDetail;
import com.geoway.onemap.zbph.domain.zgck.ZgckXmxx;
import com.geoway.onemap.zbph.service.zbsync.ZbsyncService;
import com.geoway.onemap.zbph.service.zgck.ZgckXmxxService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@EnableAsync
@Component
@ConditionalOnProperty(name={"ministerial.scheduler.enabled"}, havingValue="true")
public class MinisterialScheduler {
    private static final Logger log = LoggerFactory.getLogger(MinisterialScheduler.class);
    @Value(value="${ministerial.pcode}")
    private String pcode;
    @Value(value="${project.zbsync.nonSync.zblx:}")
    private String zblxNonSync;
    @Autowired
    private RegionService regionService;
    @Autowired
    private ZbsyncService zbsyncService;
    @Autowired
    private ZBKOperateDetailRepository zbkOperateDetailRepository;
    @Autowired
    private ZBKInputDetailRepository zbkInputDetailRepository;
    @Autowired
    private ZBKOutputDetailRepository zbkOutputDetailRepository;
    @Autowired
    private ZgckXmxxService zgckXmxxService;
    private List<String> nonSyncZblxs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getNonSyncZblxs() {
        if (!CollectionUtils.isEmpty(this.nonSyncZblxs) || !StringUtils.isNotBlank((CharSequence)this.zblxNonSync)) return this.nonSyncZblxs;
        Class<MinisterialScheduler> clazz = MinisterialScheduler.class;
        synchronized (MinisterialScheduler.class) {
            if (!CollectionUtils.isEmpty(this.nonSyncZblxs)) return this.nonSyncZblxs;
            this.nonSyncZblxs = Arrays.asList(this.zblxNonSync.split(","));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nonSyncZblxs;
        }
    }

    @Scheduled(cron="${ministerial.getZbsx.cron}")
    public void getZbsx() {
        log.info("\u6267\u884c5.2.1. \u83b7\u53d6\u6307\u6807\u4e0a\u9650\u5b9a\u65f6\u4efb\u52a1\u3002\u3002\u3002\u3002");
        String zbnd = DateUtil.format((Date)new Date(), (String)"yyyy");
        JSONObject zbsx = this.zbsyncService.getZbsx(this.pcode, zbnd);
        log.info("\u83b7\u53d6\u6307\u6807\u4e0a\u9650\u7ed3\u679c\uff1a{}", (Object)zbsx);
    }

    @Scheduled(cron="${ministerial.syncJczbk.cron}")
    public void syncJczbk() {
        log.info("\u6267\u884c5.2.2. \u57fa\u7840\u6307\u6807\u5e93\u4fe1\u606f\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1\u3002\u3002\u3002\u3002");
        String code = this.pcode.substring(0, 2) + "%";
        List regions = this.regionService.queryAllRegionByCode(code, null);
        for (Region region : regions) {
            JSONArray result = this.zbsyncService.syncJczbk(region.getCode());
            log.info(region.getName() + "\u540c\u6b65\u57fa\u7840\u6307\u6807\u5e93\u7ed3\u679c\uff1a{}", (Object)result);
        }
    }

    @Scheduled(cron="${ministerial.addZbkQdl.cron}")
    public void addZbkQdl() {
        log.info("\u5b9a\u65f6\u83b7\u53d6\u6307\u6807\u524d\u5730\u7c7b\u63d2\u5165\u5230\u6307\u6807\u524d\u5730\u7c7b\u8868\u4e2d");
        this.zbsyncService.insertZbkQdl();
    }

    @Scheduled(cron="${ministerial.syncZbgx.cron}")
    public void syncZbgx() {
        log.info("\u6267\u884c5.2.5. \u5efa\u8bbe\u9879\u76ee\u6302\u94a9\u8865\u5145\u8015\u5730\u6307\u6807\u4fe1\u606f\uff08\u5360\u8865\u5173\u7cfb\uff09\u6302\u94a9\u5b9a\u65f6\u4efb\u52a1\u3002\u3002\u3002\u3002");
        List jgczmxs = this.zbkOperateDetailRepository.findByCzlxAndSyncFlag(EnumZBKOutputType.JSXMGGCK.toValue(), "0");
        if (CollectionUtils.isEmpty((Collection)jgczmxs)) {
            log.info("\u6ca1\u6709\u53ef\u6267\u884c\u6302\u94a9\u540c\u6b65\u7684\u4efb\u52a1\u3002\u3002\u3002\u3002");
            return;
        }
        List cklshs = jgczmxs.stream().map(ZBKOperateDetail::getLsh).distinct().collect(Collectors.toList());
        String cklsh = String.join((CharSequence)",", cklshs);
        String filterStr = "Q_f_cksid_S_IN=" + cklsh;
        if (CollectionUtils.isNotEmpty(this.getNonSyncZblxs())) {
            filterStr = filterStr + ";Q_f_cklx_S_NOTIN=" + String.join((CharSequence)",", this.nonSyncZblxs);
        }
        List zgckXmxxes = this.zgckXmxxService.findByFilter(filterStr);
        for (ZgckXmxx zgckXmxx : zgckXmxxes) {
            JSONObject result = this.zbsyncService.syncZbgx(zgckXmxx.getXmid());
            log.info(zgckXmxx.getXmmc() + "\u6302\u94a9\u8865\u5145\u8015\u5730\u6307\u6807\u4fe1\u606f\uff08\u5360\u8865\u5173\u7cfb\uff09\u6302\u94a9\u7ed3\u679c\uff1a{}", (Object)result);
        }
    }

    @Scheduled(cron="${ministerial.cxggZbgx.cron}")
    public void cxggZbgx() {
        log.info("\u6267\u884c5.2.6. \u5efa\u8bbe\u9879\u76ee\u6302\u94a9\u8865\u5145\u8015\u5730\u6307\u6807\u4fe1\u606f\uff08\u5360\u8865\u5173\u7cfb\uff09\u89e3\u6302\u5b9a\u65f6\u4efb\u52a1\u3002\u3002\u3002\u3002");
        List jgczmxs = this.zbkOperateDetailRepository.findByCzlxAndSyncFlag(EnumZBKInputType.FNJSZYGDJGRK.toValue(), "0");
        if (CollectionUtils.isEmpty((Collection)jgczmxs)) {
            log.info("\u6ca1\u6709\u53ef\u6267\u884c\u89e3\u6302\u540c\u6b65\u7684\u4efb\u52a1\u3002\u3002\u3002\u3002");
            return;
        }
        List gllshs = jgczmxs.stream().map(ZBKOperateDetail::getGllsh).distinct().collect(Collectors.toList());
        List ckMxdatas = this.zbkOperateDetailRepository.findByLsh_2In(gllshs);
        List cksids = ckMxdatas.stream().map(ZBKOperateDetail::getLsh).distinct().collect(Collectors.toList());
        String cksidsStr = String.join((CharSequence)",", cksids);
        String filterStr = "Q_f_cksid_S_IN=" + cksidsStr;
        if (CollectionUtils.isNotEmpty(this.getNonSyncZblxs())) {
            filterStr = filterStr + ";Q_f_cklx_S_NOTIN=" + String.join((CharSequence)",", this.nonSyncZblxs);
        }
        List zgckXmxxes = this.zgckXmxxService.findByFilter(filterStr);
        for (ZgckXmxx zgckXmxx : zgckXmxxes) {
            JSONObject result = this.zbsyncService.cxggZbgx(zgckXmxx.getXmid());
            log.info(zgckXmxx.getXmmc() + "\u6302\u94a9\u8865\u5145\u8015\u5730\u6307\u6807\u4fe1\u606f\uff08\u5360\u8865\u5173\u7cfb\uff09\u89e3\u6302\u7ed3\u679c\uff1a{}", (Object)result);
        }
    }

    @Scheduled(cron="${ministerial.hxZbgx.cron}")
    public void hxZbgx() {
        log.info("\u6267\u884c5.2.7. \u5efa\u8bbe\u9879\u76ee\u6302\u94a9\u8865\u5145\u8015\u5730\u6307\u6807\u4fe1\u606f\uff08\u5360\u8865\u5173\u7cfb\uff09\u6838\u9500\uff08\u7701\u7ea7\u83b7\u53d6\uff09\u5b9a\u65f6\u4efb\u52a1\u3002\u3002\u3002\u3002");
        this.zbsyncService.hxZbgx(null);
    }

    @Scheduled(cron="${ministerial.getAllzb.cron}")
    public void getAllzb() {
        log.info("\u6267\u884c5.2.8. \u83b7\u53d6\u57fa\u7840\u6307\u6807\u5e93\u6570\u636e(\u542b\u5404\u7c7b\u6307\u6807)\u5b9a\u65f6\u4efb\u52a1\u3002\u3002\u3002\u3002");
        String code = this.pcode.substring(0, 2) + "%";
        List regions = this.regionService.queryAllRegionByCode(code, null);
        for (Region region : regions) {
            JSONObject result = this.zbsyncService.getAllzb(region.getCode(), null);
            log.info(region.getName() + "\u83b7\u53d6\u57fa\u7840\u6307\u6807\u5e93\u6570\u636e(\u542b\u5404\u7c7b\u6307\u6807)\u7ed3\u679c\uff1a{}", (Object)result);
        }
    }

    @Scheduled(cron="${ministerial.getAllzbczmx.cron}")
    public void getAllzbczmx() {
        log.info("\u6267\u884c5.2.9. \u83b7\u53d6\u90e8\u7ea7\u64cd\u4f5c\u6307\u6807\u64cd\u4f5c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1\u3002\u3002\u3002\u3002");
        JSONObject result = this.zbsyncService.getAllzbczmx(this.pcode, null);
        log.info(this.pcode + "\u83b7\u53d6\u57fa\u7840\u6307\u6807\u5e93\u6570\u636e(\u542b\u5404\u7c7b\u6307\u6807)\u7ed3\u679c\uff1a{}", (Object)result);
    }
}

