/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.schedual.job;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.onemap.core.domain.system.SimpleRole;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.service.DictService;
import com.geoway.onemap.core.support.HttpConnectionUtil;
import com.geoway.onemap.stxf.service.GtyService;
import com.geoway.onemap.stxf.service.ProjectRcjgProcessService;
import com.geoway.onemap.stxf.service.ProjectRcjgRecordService;
import com.geoway.onemap.zbph.domain.base.ProcessStep;
import com.geoway.onemap.zbph.domain.xfsbcgdlx.XfsbcgdLxXmxx;
import com.geoway.onemap.zbph.domain.xfsbcgdys.XfsbcgdYsXmxx;
import com.geoway.onemap.zbph.service.base.ProcessInstanceService;
import com.geoway.onemap.zbph.service.xfsbcgdlx.XfsbcgdLxXmxxService;
import com.geoway.onemap.zbph.service.xfsbcgdys.XfsbcgdYsXmxxService;
import com.geoway.zhgd.dao.IBaseFileDao;
import com.geoway.zhgd.dao.IProjectRcjgRecordDao;
import com.geoway.zhgd.domain.BaseFile;
import com.geoway.zhgd.domain.OutCheckGty;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class FruitParseJob2 {
    private static final Logger log = LoggerFactory.getLogger(FruitParseJob2.class);
    @Value(value="${project.uploadDir}")
    private String uploadDir;
    @Value(value="${workflow.url}")
    private String workFlowUrl;
    @Value(value="${update.project.state.url}")
    private String updateProjectStateUrl;
    @Autowired
    private DictService dictService;
    @Autowired
    private IBaseFileDao baseFileDao;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    IProjectRcjgRecordDao rcjgRecordDao;
    @Autowired
    ProjectRcjgProcessService projectRcjgProcessService;
    @Autowired
    ProjectRcjgRecordService projectRcjgRecordService;
    @Autowired
    GtyService gtyService;
    @Autowired
    private XfsbcgdLxXmxxService lxXmxxService;
    @Autowired
    private XfsbcgdYsXmxxService ysXmxxService;
    @Autowired
    private ProcessInstanceService processInstanceService;

    @Transactional(rollbackFor={Exception.class})
    public Boolean parseOutResult(OutCheckGty outCheckGty) throws Exception {
        JSONObject jsonObject = this.gtyService.queryResult(outCheckGty.getBsm());
        String statusResult = jsonObject.getString("status");
        if (!"true".equalsIgnoreCase(statusResult)) {
            throw new Exception(jsonObject.getString("msg"));
        }
        JSONObject checkResult = jsonObject.getJSONObject("data");
        JSONObject feature = checkResult.getJSONObject("feature");
        JSONArray medias = checkResult.getJSONArray("medias");
        if (medias.size() == 0) {
            return false;
        }
        String dkId = outCheckGty.getDkId();
        Date now = new Date();
        ArrayList<BaseFile> baseFiles = new ArrayList<BaseFile>();
        for (Object media : medias) {
            JSONObject mediaRs = (JSONObject)media;
            String serverPath = mediaRs.getString("serverpath");
            if (StringUtils.isBlank((CharSequence)serverPath)) {
                log.error("\u6210\u679c\u5730\u5740\u4e3a\u7a7a\uff1a" + mediaRs.toJSONString());
                continue;
            }
            JSONObject signJO = this.gtyService.getSignUrl(serverPath);
            serverPath = signJO.getString("data");
            String[] serverPathSplit = serverPath.split("\\?")[0].split("/");
            String fileName = serverPathSplit[serverPathSplit.length - 1];
            String localFolder = this.uploadDir + "/fruit/" + dkId;
            new File(localFolder).mkdirs();
            HttpConnectionUtil.downLoadFromUrl((String)serverPath, (String)fileName, (String)localFolder);
            BaseFile baseFile = new BaseFile();
            baseFiles.add(baseFile);
            baseFile.setRelationId(dkId);
            baseFile.setUploadTime(now);
            int fjlx = mediaRs.getInteger("type");
            if (fjlx == 1) {
                baseFile.setMediaType("ZP");
                baseFile.setFileType(Integer.valueOf(1));
                JSONObject metaData = new JSONObject();
                metaData.put("psjd", (Object)mediaRs.getDouble("azimuth"));
                metaData.put("latitude", (Object)mediaRs.getDouble("lat"));
                metaData.put("longitude", (Object)mediaRs.getDouble("lon"));
                metaData.put("psry", (Object)mediaRs.getString("username"));
                String pssj = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mediaRs.getLong("time"));
                metaData.put("pssj", (Object)pssj);
                baseFile.setMetaData(metaData.toJSONString());
            } else if (fjlx == 2) {
                baseFile.setMediaType("SP");
                baseFile.setFileType(Integer.valueOf(3));
                baseFile.setMetaData(mediaRs.getString("metarecord"));
            }
            baseFile.setFileName(fileName);
            baseFile.setCreatePath("/fruit/" + dkId + "/" + fileName);
            baseFile.setFileFormat(fileName.substring(fileName.lastIndexOf(".") + 1));
        }
        if (baseFiles.size() > 0) {
            this.setFilesRelationType(outCheckGty.getXmjd(), outCheckGty.getProjectId(), baseFiles, this.getTableNameByCode(outCheckGty.getXmjd()));
        }
        return true;
    }

    private String getJhkFhkInfo(String code, String projectId) {
        String state = "";
        if ("jhk".equals(code)) {
            XfsbcgdLxXmxx xmxx = (XfsbcgdLxXmxx)this.lxXmxxService.findById(projectId);
            state = xmxx.getProcessState();
        } else {
            XfsbcgdYsXmxx xmxx = (XfsbcgdYsXmxx)this.ysXmxxService.findById(projectId);
            state = xmxx.getProcessState();
        }
        return state;
    }

    private String getTableNameByCode(String code) {
        String tableName = null;
        switch (code) {
            case "jhk": {
                tableName = "tb_zbph_bcgdlx_xmxx";
                break;
            }
            case "fhk": {
                tableName = "tb_zbph_bcgdys_xmxx";
                break;
            }
            case "rcjg": {
                tableName = "v_project_rcjg_record";
                break;
            }
            case "jd": {
                tableName = "tb_project_gdbh_cbbcgd_zbk_jd";
                break;
            }
            case "hj": {
                tableName = "tb_project_gdbh_cbbcgd_zbk_hj";
                break;
            }
        }
        return tableName;
    }

    private void setFilesRelationType(String code, String projectId, List<BaseFile> baseFiles, String tableName) {
        if ("fhk".equals(code) || "jhk".equals(code)) {
            String checkState = this.getJhkFhkInfo(code, projectId);
            String relationType = null;
            if ("fhk".equals(code)) {
                relationType = "p05".equals(checkState) ? "CCJZ" : "ZGJZ";
                relationType = "CCJZ";
            } else if ("jhk".equals(code)) {
                relationType = "JHJZ";
            }
            for (BaseFile baseFile : baseFiles) {
                baseFile.setRelationType(relationType);
            }
            this.baseFileDao.saveAll(baseFiles);
        }
    }

    public void doFlow(String code, String projectId) {
        if ("jhk".equals(code)) {
            this.lxUploadFlow(projectId);
        } else {
            this.ysUploadFlow(projectId);
        }
    }

    private void doJhkFhkFlow(String code, String projectId, String tableName) {
        JSONArray data = new JSONArray();
        JSONObject jo = new JSONObject();
        data.add((Object)jo);
        jo.put("f_check_state", (Object)"p06");
        jo.put("f_iswy", (Object)1);
        jo.put("f_id", (Object)projectId);
        String postStr = String.format("data=%s&tableName=%s", data, tableName);
        String result = HttpConnectionUtil.AccessUrl((String)this.updateProjectStateUrl, (String)postStr);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (jsonObject != null) {
            String status = jsonObject.getString("status");
            if (!"OK".equalsIgnoreCase(status)) {
                throw new RuntimeException(jsonObject.getString("message"));
            }
        } else {
            throw new RuntimeException(jsonObject.getString("\u6d41\u7a0b\u63a5\u53e3\u8c03\u7528\u5931\u8d25, result=" + result));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    protected void lxUploadFlow(String xmid) {
        XfsbcgdLxXmxx xmxx = (XfsbcgdLxXmxx)this.lxXmxxService.findById(xmid);
        SysUser user = this.getUser(xmxx.getXzqdm(), "\u5916\u4e1a\u6838\u67e5-\u7cfb\u7edf", xmxx.getProcessId());
        this.lxXmxxService.pass(Arrays.asList(xmid.split(",")), user, "\u5b8c\u6210\u5916\u4e1a\u6838\u67e5", "", "", null);
        xmxx = (XfsbcgdLxXmxx)this.lxXmxxService.findById(xmid);
        xmxx.setIswy(Double.valueOf(1.0));
        this.lxXmxxService.saveOrUpdate((Object)xmxx, null);
    }

    @Transactional(rollbackFor={Exception.class})
    protected void ysUploadFlow(String xmid) {
        XfsbcgdYsXmxx xmxx = (XfsbcgdYsXmxx)this.ysXmxxService.findById(xmid);
        SysUser user = this.getUser(xmxx.getXzqdm(), "\u5916\u4e1a\u6838\u67e5-\u7cfb\u7edf", xmxx.getProcessId());
        this.ysXmxxService.pass(Arrays.asList(xmid.split(",")), user, "\u5b8c\u6210\u5916\u4e1a\u6838\u67e5", "", "", null);
        xmxx = (XfsbcgdYsXmxx)this.ysXmxxService.findById(xmid);
        xmxx.setIswy(Double.valueOf(1.0));
        this.ysXmxxService.saveOrUpdate((Object)xmxx, null);
    }

    private SysUser getUser(String xzqdm, String name, String processId) {
        ProcessStep processStep = this.processInstanceService.getCurrentStep(processId);
        SysUser sysUser = new SysUser();
        sysUser.setAlisname(name);
        sysUser.setUsername(name);
        sysUser.setXzqdm(xzqdm);
        sysUser.setId(name);
        HashSet<SimpleRole> roles = new HashSet<SimpleRole>();
        SimpleRole simpleRole = new SimpleRole();
        simpleRole.setRolename((String)processStep.getRelatedRoles().get(0));
        roles.add(simpleRole);
        sysUser.setRoles(roles);
        return sysUser;
    }
}

