package com.geoway.start;


import com.geoway.atlas.license.authorize.LicenseCheck;
import com.geoway.stxf.config.AppSetting;
import com.geoway.web.listener.LoadMessageListener;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.scheduling.annotation.EnableScheduling;


@EnableConfigurationProperties({AppSetting.class})
@EnableCaching
@EnableScheduling
@EnableJpaAuditing
@ServletComponentScan(basePackages = "com.geoway.web.config")
@ComponentScan({"com.geoway.base","com.geoway.web","com.geoway.onemap","com.geoway.stxf","com.geoway.zhgd","com.geoway.acti"})
@SpringBootApplication
public class LandApplication {
    public static void main(String[] args) {
        synchronized(LicenseCheck.class) {
            try {
                LicenseCheck.isValid(65040);
            } catch (Exception ex) {
                throw new RuntimeException("系统未授权，不能启动，请联系管理员");
            }
        }
        SpringApplication app=new SpringApplication(LandApplication.class);
        app.addListeners(new LoadMessageListener(" 占补平衡服务"));
        app.run(args);
    }
}
