/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaShopOrderService;
import cn.binarywang.wx.miniapp.bean.shop.WxMaShopOrderInfo;
import cn.binarywang.wx.miniapp.bean.shop.request.WxMaShopOrderPayRequest;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopAddOrderResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopBaseResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopGetOrderListResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopGetOrderResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopGetPaymentParamsResponse;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.gson.JsonObject;
import java.text.Format;
import java.util.Date;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaShopOrderServiceImpl
implements WxMaShopOrderService {
    private static final Logger log = LoggerFactory.getLogger(WxMaShopOrderServiceImpl.class);
    private final Format dateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    private static final String MATCH_KEY = "is_matched";
    private final WxMaService wxMaService;

    @Override
    public Boolean checkScene(Integer scene) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/scene/check", GsonHelper.buildJsonObject((Object[])new Object[]{"scene", scene}));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return jsonObject.get(MATCH_KEY).getAsBoolean();
    }

    @Override
    public WxMaShopAddOrderResponse addOrder(WxMaShopOrderInfo orderInfo) throws WxErrorException {
        return this.post("https://api.weixin.qq.com/shop/order/add", orderInfo, WxMaShopAddOrderResponse.class);
    }

    @Override
    public WxMaShopBaseResponse orderPay(WxMaShopOrderPayRequest request) throws WxErrorException {
        return this.post("https://api.weixin.qq.com/shop/order/pay", request, WxMaShopBaseResponse.class);
    }

    @Override
    public WxMaShopGetOrderResponse getOrder(Long orderId, String outOrderId, String openid) throws WxErrorException {
        return this.post("https://api.weixin.qq.com/shop/order/get", GsonHelper.buildJsonObject((Object[])new Object[]{"order_id", orderId, "out_order_id", outOrderId, "openid", openid}), WxMaShopGetOrderResponse.class);
    }

    @Override
    public WxMaShopGetOrderListResponse getOrderList(Integer page, Integer pageSize, Boolean desc, Date startCreateTime, Date endCreateTime) throws WxErrorException {
        JsonObject object = new JsonObject();
        object.addProperty("page", (Number)(page == null ? 1 : page));
        object.addProperty("page_size", (Number)(pageSize == null ? 10 : pageSize));
        object.addProperty("desc", (Number)(desc != false ? 1 : 2));
        if (startCreateTime != null) {
            object.addProperty("start_create_time", this.dateFormat.format(startCreateTime));
        }
        if (endCreateTime != null) {
            object.addProperty("end_create_time", this.dateFormat.format(endCreateTime));
        }
        return this.post("https://api.weixin.qq.com/shop/order/get_list", object, WxMaShopGetOrderListResponse.class);
    }

    @Override
    public WxMaShopGetPaymentParamsResponse getPaymentParams(String orderId, String outOrderId, String openid) throws WxErrorException {
        return this.post("https://api.weixin.qq.com/shop/order/getpaymentparams", GsonHelper.buildJsonObject((Object[])new Object[]{"order_id", orderId, "out_order_id", outOrderId, "openid", openid}), WxMaShopGetPaymentParamsResponse.class);
    }

    private <T> T post(String url, Object params, Class<T> classOfT) throws WxErrorException {
        String responseContent = this.wxMaService.post(url, params);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (T)WxMaGsonBuilder.create().fromJson(responseContent, classOfT);
    }

    public WxMaShopOrderServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

