/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.AbstractPedanticEnforcer;
import com.github.ferstl.maven.pomenforcers.ErrorReport;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerRule;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerVisitor;
import com.github.ferstl.maven.pomenforcers.priority.PriorityOrdering;
import com.github.ferstl.maven.pomenforcers.util.CommaSeparatorUtils;
import com.github.ferstl.maven.pomenforcers.util.XmlUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PedanticPluginElementEnforcer
extends AbstractPedanticEnforcer {
    private static final Set<String> DEFAULT_ORDER = Sets.newLinkedHashSet(Arrays.asList("groupId", "artifactId", "version", "extensions", "inherited", "configuration", "dependencies", "executions"));
    private PriorityOrdering<String, String> elementOrdering = new PriorityOrdering(DEFAULT_ORDER, Function.identity());
    private boolean checkPlugins = true;
    private boolean checkPluginManagement = true;

    public void setElementPriorities(String elements) {
        LinkedHashSet elementPriorities = Sets.newLinkedHashSet();
        CommaSeparatorUtils.splitAndAddToCollection(elements, elementPriorities);
        elementPriorities.addAll(DEFAULT_ORDER);
        this.elementOrdering = new PriorityOrdering(elementPriorities, Function.identity());
    }

    public void setCheckPlugins(boolean checkPlugins) {
        this.checkPlugins = checkPlugins;
    }

    public void setCheckPluginManagement(boolean checkPluginManagement) {
        this.checkPluginManagement = checkPluginManagement;
    }

    @Override
    protected PedanticEnforcerRule getDescription() {
        return PedanticEnforcerRule.PLUGIN_ELEMENT;
    }

    @Override
    protected void doEnforce(ErrorReport report) {
        if (this.checkPluginManagement) {
            this.analyzeNodes("pluginManagement", "/project/build/pluginManagement/plugins/plugins", report);
        }
        if (this.checkPlugins) {
            this.analyzeNodes("plugins", "/project/build/plugins/plugin", report);
        }
    }

    private void analyzeNodes(String context, String rootPath, ErrorReport errorReport) {
        NodeList nodes = XmlUtils.evaluateXPathAsNodeList(rootPath, this.getPom());
        ArrayList<Map<String, String>> unorderedNodes = new ArrayList<Map<String, String>>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NodeList nodeElements = node.getChildNodes();
            Map<String, String> elementMap = this.createElementMap(nodeElements);
            if (this.isOrdered(elementMap.keySet())) continue;
            unorderedNodes.add(elementMap);
        }
        this.report(context, errorReport, unorderedNodes);
    }

    private Map<String, String> createElementMap(NodeList elements) {
        LinkedHashMap<String, String> elementMap = new LinkedHashMap<String, String>();
        for (int j = 0; j < elements.getLength(); ++j) {
            Node element = elements.item(j);
            if (!(element instanceof Element)) continue;
            elementMap.put(element.getNodeName(), element.getTextContent());
        }
        return elementMap;
    }

    private boolean isOrdered(Collection<String> keys) {
        return this.elementOrdering.isOrdered(keys);
    }

    private void report(String context, ErrorReport errorReport, List<Map<String, String>> unorderedNodes) {
        if (unorderedNodes.isEmpty()) {
            return;
        }
        ArrayList<String> actualOrder = new ArrayList<String>();
        ArrayList<String> requiredOrder = new ArrayList<String>();
        for (Map<String, String> elements : unorderedNodes) {
            actualOrder.addAll(this.prepareForDiff(elements.keySet(), elements));
            requiredOrder.addAll(this.prepareForDiff((Collection<String>)this.elementOrdering.immutableSortedCopy(elements.keySet()), elements));
        }
        errorReport.addLine("<" + context + ">:  Plugins have to be declared this way:");
        errorReport.emptyLine();
        errorReport.addDiff(actualOrder, requiredOrder, "Actual Order", "Required Order");
    }

    private List<String> prepareForDiff(Collection<String> keys, Map<String, String> elementContents) {
        ArrayList<String> result = new ArrayList<String>(keys.size());
        result.add("<plugin>");
        for (String key : keys) {
            result.add("  <" + key + ">" + elementContents.get(key) + "</" + key + ">");
        }
        result.add("</plugin>");
        result.add("");
        return result;
    }

    @Override
    protected void accept(PedanticEnforcerVisitor visitor) {
        visitor.visit(this);
    }
}

