/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.jdbc.AbstractJdbcWrapper;
import com.google.cloud.spanner.jdbc.JdbcDriver;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.rpc.Code;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class JdbcDataSource
extends AbstractJdbcWrapper
implements DataSource {
    private String url;
    private String credentials;
    private Boolean autocommit;
    private Boolean readonly;
    private Boolean retryAbortsInternally;

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    @Override
    public void setLoginTimeout(int seconds) {
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw JdbcSqlExceptionFactory.unsupported("java.util.logging is not used");
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.getUrl() == null) {
            throw JdbcSqlExceptionFactory.of("There is no URL specified for this data source", Code.FAILED_PRECONDITION);
        }
        if (!JdbcDriver.getRegisteredDriver().acceptsURL(this.getUrl())) {
            throw JdbcSqlExceptionFactory.of("The URL " + this.getUrl() + " is not valid for the data source " + this.getClass().getName(), Code.FAILED_PRECONDITION);
        }
        return DriverManager.getConnection(this.getUrl(), this.createProperties());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    private Properties createProperties() {
        Properties props = new Properties();
        if (this.credentials != null) {
            props.setProperty("credentials", this.credentials);
        }
        if (this.autocommit != null) {
            props.setProperty("autocommit", String.valueOf(this.autocommit));
        }
        if (this.readonly != null) {
            props.setProperty("readonly", String.valueOf(this.readonly));
        }
        if (this.retryAbortsInternally != null) {
            props.setProperty("retryAbortsInternally", String.valueOf(this.retryAbortsInternally));
        }
        return props;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public Boolean getAutocommit() {
        return this.autocommit;
    }

    public void setAutocommit(Boolean autocommit) {
        this.autocommit = autocommit;
    }

    public Boolean getReadonly() {
        return this.readonly;
    }

    public void setReadonly(Boolean readonly) {
        this.readonly = readonly;
    }

    public Boolean getRetryAbortsInternally() {
        return this.retryAbortsInternally;
    }

    public void setRetryAbortsInternally(Boolean retryAbortsInternally) {
        this.retryAbortsInternally = retryAbortsInternally;
    }

    static {
        try {
            Class.forName("com.google.cloud.spanner.jdbc.JdbcDriver");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("JdbcDataSource failed to load com.google.cloud.spanner.jdbc.JdbcDriver", e);
        }
    }
}

