/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.forms.fields.FormFieldValueNonTrimmingTextRenderer;
import com.itextpdf.forms.fields.PdfButtonFormField;
import com.itextpdf.forms.fields.PdfChoiceFormField;
import com.itextpdf.forms.fields.PdfSignatureFormField;
import com.itextpdf.forms.fields.PdfTextFormField;
import com.itextpdf.forms.util.DrawingUtil;
import com.itextpdf.io.codec.Base64;
import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.io.source.PdfTokenizer;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.DeviceCmyk;
import com.itextpdf.kernel.colors.DeviceGray;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.Matrix;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfResources;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.Style;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.property.BoxSizingPropertyValue;
import com.itextpdf.layout.property.Leading;
import com.itextpdf.layout.property.OverflowPropertyValue;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.property.TransparentColor;
import com.itextpdf.layout.property.VerticalAlignment;
import com.itextpdf.layout.renderer.IRenderer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfFormField
extends PdfObjectWrapper<PdfDictionary> {
    public static final int FF_MULTILINE = PdfFormField.makeFieldFlag(13);
    public static final int FF_PASSWORD = PdfFormField.makeFieldFlag(14);
    @Deprecated
    public static final int DEFAULT_FONT_SIZE = 12;
    @Deprecated
    public static final int MIN_FONT_SIZE = 4;
    @Deprecated
    public static final int DA_FONT = 0;
    @Deprecated
    public static final int DA_SIZE = 1;
    @Deprecated
    public static final int DA_COLOR = 2;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int TYPE_CHECK = 1;
    public static final int TYPE_CIRCLE = 2;
    public static final int TYPE_CROSS = 3;
    public static final int TYPE_DIAMOND = 4;
    public static final int TYPE_SQUARE = 5;
    public static final int TYPE_STAR = 6;
    public static final int HIDDEN = 1;
    public static final int VISIBLE_BUT_DOES_NOT_PRINT = 2;
    public static final int HIDDEN_BUT_PRINTABLE = 3;
    public static final int VISIBLE = 4;
    public static final int FF_READ_ONLY = PdfFormField.makeFieldFlag(1);
    public static final int FF_REQUIRED = PdfFormField.makeFieldFlag(2);
    public static final int FF_NO_EXPORT = PdfFormField.makeFieldFlag(3);
    @Deprecated
    public static final float X_OFFSET = 2.0f;
    protected static String[] typeChars = new String[]{"4", "l", "8", "u", "n", "H"};
    protected String text;
    protected ImageData img;
    protected PdfFont font;
    protected float fontSize = -1.0f;
    protected Color color;
    protected int checkType;
    protected float borderWidth = 1.0f;
    protected Color backgroundColor;
    protected Color borderColor;
    protected int rotation = 0;
    protected PdfFormXObject form;
    protected PdfAConformanceLevel pdfAConformanceLevel;

    public PdfFormField(PdfDictionary pdfObject) {
        super((PdfObject)pdfObject);
        PdfFormField.ensureObjectIsAddedToDocument((PdfObject)pdfObject);
        this.setForbidRelease();
        this.retrieveStyles();
    }

    protected PdfFormField(PdfDocument pdfDocument) {
        this((PdfDictionary)new PdfDictionary().makeIndirect(pdfDocument));
        PdfName formType = this.getFormType();
        if (formType != null) {
            this.put(PdfName.FT, (PdfObject)formType);
        }
    }

    protected PdfFormField(PdfWidgetAnnotation widget, PdfDocument pdfDocument) {
        this((PdfDictionary)new PdfDictionary().makeIndirect(pdfDocument));
        widget.makeIndirect(pdfDocument);
        this.addKid(widget);
        this.put(PdfName.FT, (PdfObject)this.getFormType());
    }

    public static int makeFieldFlag(int bitPosition) {
        return 1 << bitPosition - 1;
    }

    public static PdfFormField createEmptyField(PdfDocument doc) {
        return PdfFormField.createEmptyField(doc, null);
    }

    public static PdfFormField createEmptyField(PdfDocument doc, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfFormField field = new PdfFormField(doc);
        field.pdfAConformanceLevel = pdfAConformanceLevel;
        return field;
    }

    public static PdfButtonFormField createButton(PdfDocument doc, Rectangle rect, int flags) {
        return PdfFormField.createButton(doc, rect, flags, null);
    }

    public static PdfButtonFormField createButton(PdfDocument doc, Rectangle rect, int flags, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfButtonFormField field = new PdfButtonFormField(annot, doc);
        field.pdfAConformanceLevel = pdfAConformanceLevel;
        if (null != pdfAConformanceLevel) {
            annot.setFlag(4);
        }
        field.setFieldFlags(flags);
        return field;
    }

    public static PdfButtonFormField createButton(PdfDocument doc, int flags) {
        return PdfFormField.createButton(doc, flags, null);
    }

    public static PdfButtonFormField createButton(PdfDocument doc, int flags, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfButtonFormField field = new PdfButtonFormField(doc);
        field.pdfAConformanceLevel = pdfAConformanceLevel;
        field.setFieldFlags(flags);
        return field;
    }

    public static PdfTextFormField createText(PdfDocument doc) {
        return PdfFormField.createText(doc, (PdfAConformanceLevel)null);
    }

    public static PdfTextFormField createText(PdfDocument doc, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfTextFormField textFormField = new PdfTextFormField(doc);
        textFormField.pdfAConformanceLevel = pdfAConformanceLevel;
        return textFormField;
    }

    public static PdfTextFormField createText(PdfDocument doc, Rectangle rect) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        return new PdfTextFormField(annot, doc);
    }

    public static PdfTextFormField createText(PdfDocument doc, Rectangle rect, String name) {
        return PdfFormField.createText(doc, rect, name, "");
    }

    public static PdfTextFormField createText(PdfDocument doc, Rectangle rect, String name, String value) {
        return PdfFormField.createText(doc, rect, name, value, null, -1.0f);
    }

    public static PdfTextFormField createText(PdfDocument doc, Rectangle rect, String name, String value, PdfFont font, float fontSize) {
        return PdfFormField.createText(doc, rect, name, value, font, fontSize, false);
    }

    public static PdfTextFormField createText(PdfDocument doc, Rectangle rect, String name, String value, PdfFont font, float fontSize, boolean multiline) {
        return PdfFormField.createText(doc, rect, name, value, font, fontSize, multiline, null);
    }

    public static PdfTextFormField createText(PdfDocument doc, Rectangle rect, String name, String value, PdfFont font, float fontSize, boolean multiline, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfTextFormField field = new PdfTextFormField(annot, doc);
        field.pdfAConformanceLevel = pdfAConformanceLevel;
        if (null != pdfAConformanceLevel) {
            annot.setFlag(4);
        }
        super.updateFontAndFontSize(font, fontSize);
        field.setMultiline(multiline);
        field.setFieldName(name);
        field.setValue(value);
        return field;
    }

    public static PdfTextFormField createMultilineText(PdfDocument doc, Rectangle rect, String name, String value, PdfFont font, float fontSize) {
        return PdfFormField.createText(doc, rect, name, value, font, fontSize, true);
    }

    public static PdfTextFormField createMultilineText(PdfDocument doc, Rectangle rect, String name, String value) {
        return PdfFormField.createText(doc, rect, name, value, null, -1.0f, true);
    }

    public static PdfChoiceFormField createChoice(PdfDocument doc, int flags) {
        return PdfFormField.createChoice(doc, flags, null);
    }

    public static PdfChoiceFormField createChoice(PdfDocument doc, int flags, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfChoiceFormField field = new PdfChoiceFormField(doc);
        field.pdfAConformanceLevel = pdfAConformanceLevel;
        field.setFieldFlags(flags);
        return field;
    }

    public static PdfChoiceFormField createChoice(PdfDocument doc, Rectangle rect, int flags) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfChoiceFormField field = new PdfChoiceFormField(annot, doc);
        field.setFieldFlags(flags);
        return field;
    }

    public static PdfChoiceFormField createChoice(PdfDocument doc, Rectangle rect, String name, String value, PdfArray options, int flags) {
        return PdfFormField.createChoice(doc, rect, name, value, null, -1.0f, options, flags);
    }

    public static PdfChoiceFormField createChoice(PdfDocument doc, Rectangle rect, String name, String value, PdfArray options, int flags, PdfFont font, PdfAConformanceLevel pdfAConformanceLevel) {
        return PdfFormField.createChoice(doc, rect, name, value, font, 12.0f, options, flags, pdfAConformanceLevel);
    }

    public static PdfChoiceFormField createChoice(PdfDocument doc, Rectangle rect, String name, String value, PdfFont font, float fontSize, PdfArray options, int flags) {
        return PdfFormField.createChoice(doc, rect, name, value, font, fontSize, options, flags, null);
    }

    public static PdfChoiceFormField createChoice(PdfDocument doc, Rectangle rect, String name, String value, PdfFont font, float fontSize, PdfArray options, int flags, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfChoiceFormField field = new PdfChoiceFormField(annot, doc);
        field.pdfAConformanceLevel = pdfAConformanceLevel;
        if (null != pdfAConformanceLevel) {
            annot.setFlag(4);
        }
        super.updateFontAndFontSize(font, fontSize);
        field.put(PdfName.Opt, (PdfObject)options);
        field.setFieldFlags(flags);
        field.setFieldName(name);
        field.setListSelected(new String[]{value}, false);
        if ((flags & PdfChoiceFormField.FF_COMBO) == 0) {
            value = PdfFormField.optionsArrayToString(options);
        }
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, rect.getWidth(), rect.getHeight()));
        super.drawChoiceAppearance(rect, field.fontSize, value, xObject, 0);
        annot.setNormalAppearance((PdfDictionary)xObject.getPdfObject());
        return field;
    }

    public static PdfSignatureFormField createSignature(PdfDocument doc) {
        return PdfFormField.createSignature(doc, (PdfAConformanceLevel)null);
    }

    public static PdfSignatureFormField createSignature(PdfDocument doc, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfSignatureFormField signatureFormField = new PdfSignatureFormField(doc);
        signatureFormField.pdfAConformanceLevel = pdfAConformanceLevel;
        return signatureFormField;
    }

    public static PdfSignatureFormField createSignature(PdfDocument doc, Rectangle rect) {
        return PdfFormField.createSignature(doc, rect, null);
    }

    public static PdfSignatureFormField createSignature(PdfDocument doc, Rectangle rect, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfSignatureFormField signatureFormField = new PdfSignatureFormField(annot, doc);
        signatureFormField.pdfAConformanceLevel = pdfAConformanceLevel;
        if (null != pdfAConformanceLevel) {
            annot.setFlag(4);
        }
        return signatureFormField;
    }

    public static PdfButtonFormField createRadioGroup(PdfDocument doc, String name, String value) {
        return PdfFormField.createRadioGroup(doc, name, value, null);
    }

    public static PdfButtonFormField createRadioGroup(PdfDocument doc, String name, String value, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfButtonFormField radio = PdfFormField.createButton(doc, PdfButtonFormField.FF_RADIO);
        radio.setFieldName(name);
        radio.put(PdfName.V, (PdfObject)new PdfName(value));
        radio.pdfAConformanceLevel = pdfAConformanceLevel;
        return radio;
    }

    public static PdfFormField createRadioButton(PdfDocument doc, Rectangle rect, PdfButtonFormField radioGroup, String value) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfButtonFormField radio = new PdfButtonFormField(annot, doc);
        String name = radioGroup.getValue().toString().substring(1);
        if (name.equals(value)) {
            annot.setAppearanceState(new PdfName(value));
        } else {
            annot.setAppearanceState(new PdfName("Off"));
        }
        radio.drawRadioAppearance(rect.getWidth(), rect.getHeight(), value);
        radioGroup.addKid(radio);
        return radio;
    }

    public static PdfFormField createRadioButton(PdfDocument doc, Rectangle rect, PdfButtonFormField radioGroup, String value, PdfAConformanceLevel pdfAConformanceLevel) {
        String name;
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfButtonFormField radio = new PdfButtonFormField(annot, doc);
        radio.pdfAConformanceLevel = pdfAConformanceLevel;
        if (null != pdfAConformanceLevel) {
            annot.setFlag(4);
        }
        if ((name = radioGroup.getValue().toString().substring(1)).equals(value)) {
            annot.setAppearanceState(new PdfName(value));
        } else {
            annot.setAppearanceState(new PdfName("Off"));
        }
        radio.drawRadioAppearance(rect.getWidth(), rect.getHeight(), value);
        radioGroup.addKid(radio);
        return radio;
    }

    public static PdfButtonFormField createPushButton(PdfDocument doc, Rectangle rect, String name, String caption) {
        PdfButtonFormField field;
        try {
            field = PdfFormField.createPushButton(doc, rect, name, caption, PdfFontFactory.createFont(), 12.0f);
        }
        catch (IOException e) {
            throw new PdfException((Throwable)e);
        }
        return field;
    }

    public static PdfButtonFormField createPushButton(PdfDocument doc, Rectangle rect, String name, String caption, PdfFont font, float fontSize) {
        return PdfFormField.createPushButton(doc, rect, name, caption, font, fontSize, null);
    }

    public static PdfButtonFormField createPushButton(PdfDocument doc, Rectangle rect, String name, String caption, PdfFont font, float fontSize, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfButtonFormField field = new PdfButtonFormField(annot, doc);
        field.pdfAConformanceLevel = pdfAConformanceLevel;
        if (null != pdfAConformanceLevel) {
            annot.setFlag(4);
        }
        field.setPushButton(true);
        field.setFieldName(name);
        field.text = caption;
        super.updateFontAndFontSize(font, fontSize);
        field.backgroundColor = ColorConstants.LIGHT_GRAY;
        PdfFormXObject xObject = field.drawPushButtonAppearance(rect.getWidth(), rect.getHeight(), caption, font, fontSize);
        annot.setNormalAppearance((PdfDictionary)xObject.getPdfObject());
        PdfDictionary mk = new PdfDictionary();
        mk.put(PdfName.CA, (PdfObject)new PdfString(caption));
        mk.put(PdfName.BG, (PdfObject)new PdfArray(field.backgroundColor.getColorValue()));
        annot.setAppearanceCharacteristics(mk);
        if (pdfAConformanceLevel != null) {
            PdfFormField.createPushButtonAppearanceState((PdfDictionary)annot.getPdfObject());
        }
        return field;
    }

    public static PdfButtonFormField createCheckBox(PdfDocument doc, Rectangle rect, String name, String value) {
        return PdfFormField.createCheckBox(doc, rect, name, value, 3);
    }

    public static PdfButtonFormField createCheckBox(PdfDocument doc, Rectangle rect, String name, String value, int checkType) {
        return PdfFormField.createCheckBox(doc, rect, name, value, checkType, null);
    }

    public static PdfButtonFormField createCheckBox(PdfDocument doc, Rectangle rect, String name, String value, int checkType, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfButtonFormField check = new PdfButtonFormField(annot, doc);
        check.pdfAConformanceLevel = pdfAConformanceLevel;
        check.setFontSize(0);
        check.setCheckType(checkType);
        check.setFieldName(name);
        check.put(PdfName.V, (PdfObject)new PdfName(value));
        annot.setAppearanceState(new PdfName(value));
        if (pdfAConformanceLevel != null) {
            check.drawPdfA2CheckAppearance(rect.getWidth(), rect.getHeight(), "Off".equals(value) ? "Yes" : value, checkType);
            annot.setFlag(4);
        } else {
            check.drawCheckAppearance(rect.getWidth(), rect.getHeight(), "Off".equals(value) ? "Yes" : value);
        }
        return check;
    }

    public static PdfChoiceFormField createComboBox(PdfDocument doc, Rectangle rect, String name, String value, String[][] options) {
        try {
            return PdfFormField.createComboBox(doc, rect, name, value, options, PdfFontFactory.createFont(), null);
        }
        catch (IOException e) {
            throw new PdfException((Throwable)e);
        }
    }

    public static PdfChoiceFormField createComboBox(PdfDocument doc, Rectangle rect, String name, String value, String[][] options, PdfFont font, PdfAConformanceLevel pdfAConformanceLevel) {
        return PdfFormField.createChoice(doc, rect, name, value, PdfFormField.processOptions(options), PdfChoiceFormField.FF_COMBO, font, pdfAConformanceLevel);
    }

    public static PdfChoiceFormField createComboBox(PdfDocument doc, Rectangle rect, String name, String value, String[] options) {
        return PdfFormField.createComboBox(doc, rect, name, value, options, null, null);
    }

    public static PdfChoiceFormField createComboBox(PdfDocument doc, Rectangle rect, String name, String value, String[] options, PdfFont font, PdfAConformanceLevel pdfAConformanceLevel) {
        return PdfFormField.createChoice(doc, rect, name, value, PdfFormField.processOptions(options), PdfChoiceFormField.FF_COMBO, font, pdfAConformanceLevel);
    }

    public static PdfChoiceFormField createList(PdfDocument doc, Rectangle rect, String name, String value, String[][] options) {
        return PdfFormField.createList(doc, rect, name, value, options, null, null);
    }

    public static PdfChoiceFormField createList(PdfDocument doc, Rectangle rect, String name, String value, String[][] options, PdfFont font, PdfAConformanceLevel pdfAConformanceLevel) {
        return PdfFormField.createChoice(doc, rect, name, value, PdfFormField.processOptions(options), 0, font, pdfAConformanceLevel);
    }

    public static PdfChoiceFormField createList(PdfDocument doc, Rectangle rect, String name, String value, String[] options) {
        return PdfFormField.createList(doc, rect, name, value, options, null, null);
    }

    public static PdfChoiceFormField createList(PdfDocument doc, Rectangle rect, String name, String value, String[] options, PdfFont font, PdfAConformanceLevel pdfAConformanceLevel) {
        return PdfFormField.createChoice(doc, rect, name, value, PdfFormField.processOptions(options), 0, font, pdfAConformanceLevel);
    }

    public static PdfFormField makeFormField(PdfObject pdfObject, PdfDocument document) {
        if (pdfObject.isDictionary()) {
            PdfDictionary dictionary = (PdfDictionary)pdfObject;
            PdfName formType = dictionary.getAsName(PdfName.FT);
            PdfFormField field = PdfName.Tx.equals((Object)formType) ? new PdfTextFormField(dictionary) : (PdfName.Btn.equals((Object)formType) ? new PdfButtonFormField(dictionary) : (PdfName.Ch.equals((Object)formType) ? new PdfChoiceFormField(dictionary) : (PdfName.Sig.equals((Object)formType) ? new PdfSignatureFormField(dictionary) : new PdfFormField(dictionary))));
            field.makeIndirect(document);
            if (document != null && document.getReader() != null && document.getReader().getPdfAConformanceLevel() != null) {
                field.pdfAConformanceLevel = document.getReader().getPdfAConformanceLevel();
            }
            return field;
        }
        return null;
    }

    public PdfName getFormType() {
        PdfName formType = ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.FT);
        if (formType == null) {
            return this.getTypeFromParent((PdfDictionary)this.getPdfObject());
        }
        return formType;
    }

    public PdfFormField setValue(String value) {
        PdfName formType = this.getFormType();
        boolean autoGenerateAppearance = !PdfName.Btn.equals((Object)formType) || !this.getFieldFlag(PdfButtonFormField.FF_RADIO);
        return this.setValue(value, autoGenerateAppearance);
    }

    public PdfFormField setValue(String value, boolean generateAppearance) {
        PdfName formType = this.getFormType();
        if (formType == null || !PdfName.Btn.equals((Object)formType)) {
            PdfArray kids = this.getKids();
            if (kids != null) {
                for (PdfObject kid : kids) {
                    if (!kid.isDictionary() || ((PdfDictionary)kid).getAsString(PdfName.T) == null) continue;
                    PdfFormField field = new PdfFormField((PdfDictionary)kid);
                    field.setValue(value);
                    if (field.getDefaultAppearance() != null) continue;
                    field.font = this.font;
                    field.fontSize = this.fontSize;
                    field.color = this.color;
                }
            }
            if (PdfName.Ch.equals((Object)formType)) {
                if (this instanceof PdfChoiceFormField) {
                    ((PdfChoiceFormField)this).setListSelected(new String[]{value}, false);
                } else {
                    PdfChoiceFormField choice = new PdfChoiceFormField((PdfDictionary)this.getPdfObject());
                    choice.setListSelected(new String[]{value}, false);
                }
            } else {
                this.put(PdfName.V, (PdfObject)new PdfString(value, "UnicodeBig"));
            }
        } else if (PdfName.Btn.equals((Object)formType)) {
            if (this.getFieldFlag(PdfButtonFormField.FF_PUSH_BUTTON)) {
                try {
                    this.img = ImageDataFactory.create((byte[])Base64.decode((String)value));
                }
                catch (Exception e) {
                    this.text = value;
                }
            } else {
                this.put(PdfName.V, (PdfObject)new PdfName(value));
                for (PdfWidgetAnnotation widget : this.getWidgets()) {
                    List<String> states = Arrays.asList(new PdfFormField((PdfDictionary)widget.getPdfObject()).getAppearanceStates());
                    if (states.contains(value)) {
                        widget.setAppearanceState(new PdfName(value));
                        continue;
                    }
                    widget.setAppearanceState(new PdfName("Off"));
                }
            }
        }
        if (generateAppearance) {
            this.regenerateField();
        }
        this.setModified();
        return this;
    }

    public PdfFormField setValue(String value, PdfFont font, float fontSize) {
        this.updateFontAndFontSize(font, fontSize);
        return this.setValue(value);
    }

    private void updateFontAndFontSize(PdfFont font, float fontSize) {
        if (font == null) {
            font = this.getDocument().getDefaultFont();
        }
        this.font = font;
        if (fontSize < 0.0f) {
            fontSize = 12.0f;
        }
        this.fontSize = fontSize;
    }

    public PdfFormField setValue(String value, String display) {
        if (display == null) {
            return this.setValue(value);
        }
        this.setValue(display, true);
        PdfName formType = this.getFormType();
        if (PdfName.Btn.equals((Object)formType)) {
            if ((this.getFieldFlags() & PdfButtonFormField.FF_PUSH_BUTTON) != 0) {
                this.text = value;
            } else {
                this.put(PdfName.V, (PdfObject)new PdfName(value));
            }
        } else {
            this.put(PdfName.V, (PdfObject)new PdfString(value, "UnicodeBig"));
        }
        return this;
    }

    public PdfFormField setParent(PdfFormField parent) {
        return this.put(PdfName.Parent, parent.getPdfObject());
    }

    public PdfDictionary getParent() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Parent);
    }

    public PdfArray getKids() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Kids);
    }

    public PdfFormField addKid(PdfFormField kid) {
        kid.setParent(this);
        PdfArray kids = this.getKids();
        if (kids == null) {
            kids = new PdfArray();
        }
        kids.add(kid.getPdfObject());
        return this.put(PdfName.Kids, (PdfObject)kids);
    }

    public PdfFormField addKid(PdfWidgetAnnotation kid) {
        kid.setParent(this.getPdfObject());
        PdfArray kids = this.getKids();
        if (kids == null) {
            kids = new PdfArray();
        }
        kids.add(kid.getPdfObject());
        return this.put(PdfName.Kids, (PdfObject)kids);
    }

    public PdfFormField setFieldName(String name) {
        return this.put(PdfName.T, (PdfObject)new PdfString(name));
    }

    public PdfString getFieldName() {
        PdfString name;
        PdfFormField parentField;
        PdfString pName;
        String parentName = "";
        PdfDictionary parent = this.getParent();
        if (parent != null && (pName = (parentField = PdfFormField.makeFormField((PdfObject)this.getParent(), this.getDocument())).getFieldName()) != null) {
            parentName = pName.toUnicodeString() + ".";
        }
        if ((name = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.T)) != null) {
            name = new PdfString(parentName + name.toUnicodeString(), "UnicodeBig");
        }
        return name;
    }

    public PdfFormField setAlternativeName(String name) {
        return this.put(PdfName.TU, (PdfObject)new PdfString(name));
    }

    public PdfString getAlternativeName() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.TU);
    }

    public PdfFormField setMappingName(String name) {
        return this.put(PdfName.TM, (PdfObject)new PdfString(name));
    }

    public PdfString getMappingName() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.TM);
    }

    public boolean getFieldFlag(int flag) {
        return (this.getFieldFlags() & flag) != 0;
    }

    public PdfFormField setFieldFlag(int flag) {
        return this.setFieldFlag(flag, true);
    }

    public PdfFormField setFieldFlag(int flag, boolean value) {
        int flags = this.getFieldFlags();
        flags = value ? (flags |= flag) : (flags &= ~flag);
        return this.setFieldFlags(flags);
    }

    public boolean isMultiline() {
        return this.getFieldFlag(FF_MULTILINE);
    }

    public boolean isPassword() {
        return this.getFieldFlag(FF_PASSWORD);
    }

    public PdfFormField setFieldFlags(int flags) {
        int oldFlags = this.getFieldFlags();
        this.put(PdfName.Ff, (PdfObject)new PdfNumber(flags));
        if (((oldFlags ^ flags) & PdfTextFormField.FF_COMB) != 0 && PdfName.Tx.equals((Object)this.getFormType()) && new PdfTextFormField((PdfDictionary)this.getPdfObject()).getMaxLen() != 0) {
            this.regenerateField();
        }
        return this;
    }

    public int getFieldFlags() {
        PdfNumber f = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.Ff);
        if (f != null) {
            return f.intValue();
        }
        PdfDictionary parent = this.getParent();
        if (parent != null) {
            return new PdfFormField(parent).getFieldFlags();
        }
        return 0;
    }

    public PdfObject getValue() {
        if (((PdfDictionary)this.getPdfObject()).get(PdfName.T) == null && this.getParent() != null) {
            return this.getParent().get(PdfName.V);
        }
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.V);
    }

    public String getValueAsString() {
        PdfObject value = this.getValue();
        if (value == null) {
            return "";
        }
        if (value instanceof PdfStream) {
            return new String(((PdfStream)value).getBytes(), StandardCharsets.UTF_8);
        }
        if (value instanceof PdfName) {
            return ((PdfName)value).getValue();
        }
        if (value instanceof PdfString) {
            return ((PdfString)value).toUnicodeString();
        }
        return "";
    }

    public PdfFormField setDefaultValue(PdfObject value) {
        return this.put(PdfName.DV, value);
    }

    public PdfObject getDefaultValue() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.DV);
    }

    public PdfFormField setAdditionalAction(PdfName key, PdfAction action) {
        PdfAction.setAdditionalAction((PdfObjectWrapper)this, (PdfName)key, (PdfAction)action);
        return this;
    }

    public PdfDictionary getAdditionalAction() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.AA);
    }

    public PdfFormField setOptions(PdfArray options) {
        return this.put(PdfName.Opt, (PdfObject)options);
    }

    public PdfArray getOptions() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Opt);
    }

    public List<PdfWidgetAnnotation> getWidgets() {
        PdfArray kids;
        ArrayList<PdfWidgetAnnotation> widgets = new ArrayList<PdfWidgetAnnotation>();
        PdfName subType = ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.Subtype);
        if (subType != null && subType.equals((Object)PdfName.Widget)) {
            widgets.add((PdfWidgetAnnotation)PdfAnnotation.makeAnnotation((PdfObject)this.getPdfObject()));
        }
        if ((kids = this.getKids()) != null) {
            for (int i = 0; i < kids.size(); ++i) {
                PdfObject kid = kids.get(i);
                subType = ((PdfDictionary)kid).getAsName(PdfName.Subtype);
                if (subType == null || !subType.equals((Object)PdfName.Widget)) continue;
                widgets.add((PdfWidgetAnnotation)PdfAnnotation.makeAnnotation((PdfObject)kid));
            }
        }
        return widgets;
    }

    public PdfString getDefaultAppearance() {
        PdfDictionary parent;
        PdfString defaultAppearance = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.DA);
        if (defaultAppearance == null && (parent = this.getParent()) != null && parent.containsKey(PdfName.FT)) {
            defaultAppearance = parent.getAsString(PdfName.DA);
        }
        if (defaultAppearance == null) {
            defaultAppearance = (PdfString)this.getAcroFormKey(PdfName.DA, 10);
        }
        return defaultAppearance;
    }

    @Deprecated
    public PdfFormField setDefaultAppearance(String defaultAppearance) {
        byte[] b = defaultAppearance.getBytes(StandardCharsets.UTF_8);
        for (int k = 0; k < b.length; ++k) {
            if (b[k] != 10) continue;
            b[k] = 32;
        }
        this.put(PdfName.DA, (PdfObject)new PdfString(new String(b, StandardCharsets.UTF_8)));
        return this;
    }

    public void updateDefaultAppearance() {
        if (this.hasDefaultAppearance()) {
            PdfName fontName;
            PdfDictionary fontResources;
            assert (this.font != null);
            PdfDictionary defaultResources = (PdfDictionary)this.getAcroFormObject(PdfName.DR, 3);
            if (defaultResources == null) {
                this.addAcroFormToCatalog();
                defaultResources = new PdfDictionary();
                this.putAcroFormObject(PdfName.DR, (PdfObject)defaultResources);
            }
            if ((fontResources = defaultResources.getAsDictionary(PdfName.Font)) == null) {
                fontResources = new PdfDictionary();
                defaultResources.put(PdfName.Font, (PdfObject)fontResources);
            }
            if ((fontName = this.getFontNameFromDR(fontResources, this.font.getPdfObject())) == null) {
                fontName = this.getUniqueFontNameForDR(fontResources);
                fontResources.put(fontName, this.font.getPdfObject());
                fontResources.setModified();
            }
            this.put(PdfName.DA, (PdfObject)PdfFormField.generateDefaultAppearance(fontName, this.fontSize, this.color));
            this.getDocument().addFont(this.font);
        } else {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.DA);
            this.setModified();
        }
    }

    public Integer getJustification() {
        Integer justification = ((PdfDictionary)this.getPdfObject()).getAsInt(PdfName.Q);
        if (justification == null && this.getParent() != null) {
            justification = this.getParent().getAsInt(PdfName.Q);
        }
        return justification;
    }

    public PdfFormField setJustification(int justification) {
        this.put(PdfName.Q, (PdfObject)new PdfNumber(justification));
        this.regenerateField();
        return this;
    }

    public PdfString getDefaultStyle() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.DS);
    }

    public PdfFormField setDefaultStyle(PdfString defaultStyleString) {
        this.put(PdfName.DS, (PdfObject)defaultStyleString);
        return this;
    }

    public PdfObject getRichText() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.RV);
    }

    public PdfFormField setRichText(PdfObject richText) {
        this.put(PdfName.RV, richText);
        return this;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public PdfFont getFont() {
        return this.font;
    }

    public Color getColor() {
        return this.color;
    }

    public PdfFormField setFont(PdfFont font) {
        this.updateFontAndFontSize(font, this.fontSize);
        this.regenerateField();
        return this;
    }

    public PdfFormField setFontSize(float fontSize) {
        this.updateFontAndFontSize(this.font, fontSize);
        this.regenerateField();
        return this;
    }

    public PdfFormField setFontSize(int fontSize) {
        this.setFontSize((float)fontSize);
        return this;
    }

    @Deprecated
    public PdfFormField setFontAndSize(PdfFont font, int fontSize) {
        this.updateFontAndFontSize(font, fontSize);
        this.regenerateField();
        return this;
    }

    public PdfFormField setFontAndSize(PdfFont font, float fontSize) {
        this.updateFontAndFontSize(font, fontSize);
        this.regenerateField();
        return this;
    }

    public PdfFormField setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        List<PdfWidgetAnnotation> kids = this.getWidgets();
        for (PdfWidgetAnnotation kid : kids) {
            PdfDictionary mk = kid.getAppearanceCharacteristics();
            if (mk == null) {
                mk = new PdfDictionary();
            }
            if (backgroundColor == null) {
                mk.remove(PdfName.BG);
            } else {
                mk.put(PdfName.BG, (PdfObject)new PdfArray(backgroundColor.getColorValue()));
            }
            kid.setAppearanceCharacteristics(mk);
        }
        this.regenerateField();
        return this;
    }

    public PdfFormField setRotation(int degRotation) {
        if (degRotation % 90 != 0) {
            throw new IllegalArgumentException("degRotation.must.be.a.multiple.of.90");
        }
        if ((degRotation %= 360) < 0) {
            degRotation += 360;
        }
        this.rotation = degRotation;
        PdfDictionary mk = this.getWidgets().get(0).getAppearanceCharacteristics();
        if (mk == null) {
            mk = new PdfDictionary();
            this.put(PdfName.MK, (PdfObject)mk);
        }
        mk.put(PdfName.R, (PdfObject)new PdfNumber(degRotation));
        this.rotation = degRotation;
        this.regenerateField();
        return this;
    }

    public PdfFormField setAction(PdfAction action) {
        List<PdfWidgetAnnotation> widgets = this.getWidgets();
        if (widgets != null) {
            for (PdfWidgetAnnotation widget : widgets) {
                widget.setAction(action);
            }
        }
        return this;
    }

    public PdfFormField setCheckType(int checkType) {
        if (checkType < 1 || checkType > 6) {
            checkType = 3;
        }
        this.checkType = checkType;
        this.text = typeChars[checkType - 1];
        if (this.pdfAConformanceLevel != null) {
            return this;
        }
        try {
            this.font = PdfFontFactory.createFont((String)"ZapfDingbats");
        }
        catch (IOException e) {
            throw new PdfException((Throwable)e);
        }
        return this;
    }

    public PdfFormField setVisibility(int visibility) {
        switch (visibility) {
            case 1: {
                this.put(PdfName.F, (PdfObject)new PdfNumber(6));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.put(PdfName.F, (PdfObject)new PdfNumber(36));
                break;
            }
            default: {
                this.put(PdfName.F, (PdfObject)new PdfNumber(4));
            }
        }
        return this;
    }

    public boolean regenerateField() {
        boolean result = true;
        this.updateDefaultAppearance();
        for (PdfWidgetAnnotation widget : this.getWidgets()) {
            PdfFormField field = new PdfFormField((PdfDictionary)widget.getPdfObject());
            this.copyParamsToKids(field);
            result &= field.regenerateWidget(this.getValueAsString());
        }
        return result;
    }

    public float getBorderWidth() {
        PdfNumber w;
        PdfDictionary bs = this.getWidgets().get(0).getBorderStyle();
        if (bs != null && (w = bs.getAsNumber(PdfName.W)) != null) {
            this.borderWidth = w.floatValue();
        }
        return this.borderWidth;
    }

    public PdfFormField setBorderWidth(float borderWidth) {
        PdfDictionary bs = this.getWidgets().get(0).getBorderStyle();
        if (bs == null) {
            bs = new PdfDictionary();
            this.put(PdfName.BS, (PdfObject)bs);
        }
        bs.put(PdfName.W, (PdfObject)new PdfNumber((double)borderWidth));
        this.borderWidth = borderWidth;
        this.regenerateField();
        return this;
    }

    public PdfFormField setBorderStyle(PdfDictionary style) {
        this.getWidgets().get(0).setBorderStyle(style);
        this.regenerateField();
        return this;
    }

    public PdfFormField setBorderColor(Color color) {
        this.borderColor = color;
        List<PdfWidgetAnnotation> kids = this.getWidgets();
        for (PdfWidgetAnnotation kid : kids) {
            PdfDictionary mk = kid.getAppearanceCharacteristics();
            if (mk == null) {
                mk = new PdfDictionary();
            }
            if (this.borderColor == null) {
                mk.remove(PdfName.BC);
            } else {
                mk.put(PdfName.BC, (PdfObject)new PdfArray(this.borderColor.getColorValue()));
            }
            kid.setAppearanceCharacteristics(mk);
        }
        this.regenerateField();
        return this;
    }

    public PdfFormField setColor(Color color) {
        this.color = color;
        this.regenerateField();
        return this;
    }

    public PdfFormField setReadOnly(boolean readOnly) {
        return this.setFieldFlag(FF_READ_ONLY, readOnly);
    }

    public boolean isReadOnly() {
        return this.getFieldFlag(FF_READ_ONLY);
    }

    public PdfFormField setRequired(boolean required) {
        return this.setFieldFlag(FF_REQUIRED, required);
    }

    public boolean isRequired() {
        return this.getFieldFlag(FF_REQUIRED);
    }

    public PdfFormField setNoExport(boolean noExport) {
        return this.setFieldFlag(FF_NO_EXPORT, noExport);
    }

    public boolean isNoExport() {
        return this.getFieldFlag(FF_NO_EXPORT);
    }

    public PdfFormField setPage(int pageNum) {
        PdfAnnotation annot;
        List<PdfWidgetAnnotation> widgets = this.getWidgets();
        if (widgets.size() > 0 && (annot = (PdfAnnotation)widgets.get(0)) != null) {
            annot.setPage(this.getDocument().getPage(pageNum));
        }
        return this;
    }

    public String[] getAppearanceStates() {
        PdfArray kids;
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        PdfString stringOpt = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Opt);
        if (stringOpt != null) {
            names.add(stringOpt.toUnicodeString());
        } else {
            PdfArray arrayOpt = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Opt);
            if (arrayOpt != null) {
                for (PdfObject pdfObject : arrayOpt) {
                    PdfString valStr = null;
                    if (pdfObject.isArray()) {
                        valStr = ((PdfArray)pdfObject).getAsString(1);
                    } else if (pdfObject.isString()) {
                        valStr = (PdfString)pdfObject;
                    }
                    if (valStr == null) continue;
                    names.add(valStr.toUnicodeString());
                }
            }
        }
        PdfDictionary dic = (PdfDictionary)this.getPdfObject();
        dic = dic.getAsDictionary(PdfName.AP);
        if (dic != null && (dic = dic.getAsDictionary(PdfName.N)) != null) {
            for (PdfName state : dic.keySet()) {
                names.add(state.getValue());
            }
        }
        if ((kids = this.getKids()) != null) {
            for (PdfObject kid : kids) {
                PdfFormField fld = new PdfFormField((PdfDictionary)kid);
                String[] states = fld.getAppearanceStates();
                Collections.addAll(names, states);
            }
        }
        return names.toArray(new String[names.size()]);
    }

    public PdfFormField setAppearance(PdfName appearanceType, String appearanceState, PdfStream appearanceStream) {
        PdfWidgetAnnotation widget = this.getWidgets().get(0);
        PdfDictionary dic = widget != null ? (PdfDictionary)widget.getPdfObject() : (PdfDictionary)this.getPdfObject();
        PdfDictionary ap = dic.getAsDictionary(PdfName.AP);
        if (ap != null) {
            PdfDictionary appearanceDictionary = ap.getAsDictionary(appearanceType);
            if (appearanceDictionary == null) {
                ap.put(appearanceType, (PdfObject)appearanceStream);
            } else {
                appearanceDictionary.put(new PdfName(appearanceState), (PdfObject)appearanceStream);
            }
        }
        return this;
    }

    public PdfFormField setFontSizeAutoScale() {
        this.fontSize = 0.0f;
        this.regenerateField();
        return this;
    }

    public PdfFormField put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        this.setModified();
        return this;
    }

    public PdfFormField remove(PdfName key) {
        ((PdfDictionary)this.getPdfObject()).remove(key);
        this.setModified();
        return this;
    }

    public void release() {
        this.unsetForbidRelease();
        ((PdfDictionary)this.getPdfObject()).release();
    }

    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    protected PdfDocument getDocument() {
        return ((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument();
    }

    protected Rectangle getRect(PdfDictionary field) {
        PdfArray rect = field.getAsArray(PdfName.Rect);
        if (rect == null) {
            PdfArray kids = field.getAsArray(PdfName.Kids);
            if (kids == null) {
                throw new PdfException("Wrong form field. Add annotation to the field.");
            }
            rect = ((PdfDictionary)kids.get(0)).getAsArray(PdfName.Rect);
        }
        return rect != null ? rect.toRectangle() : null;
    }

    protected static PdfArray processOptions(String[][] options) {
        PdfArray array = new PdfArray();
        for (String[] option : options) {
            PdfArray subArray = new PdfArray((PdfObject)new PdfString(option[0], "UnicodeBig"));
            subArray.add((PdfObject)new PdfString(option[1], "UnicodeBig"));
            array.add((PdfObject)subArray);
        }
        return array;
    }

    protected static PdfArray processOptions(String[] options) {
        PdfArray array = new PdfArray();
        for (String option : options) {
            array.add((PdfObject)new PdfString(option, "UnicodeBig"));
        }
        return array;
    }

    @Deprecated
    protected String generateDefaultAppearanceString(PdfFont font, float fontSize, Color color, PdfResources res) {
        PdfStream stream = new PdfStream();
        PdfCanvas canvas = new PdfCanvas(stream, res, this.getDocument());
        canvas.setFontAndSize(font, fontSize);
        if (color != null) {
            canvas.setColor(color, true);
        }
        return new String(stream.getBytes(), StandardCharsets.UTF_8);
    }

    @Deprecated
    protected Object[] getFontAndSize(PdfDictionary asNormal) throws IOException {
        return new Object[]{this.getFont(), Float.valueOf(this.getFontSize())};
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Object[] splitDAelements(String da) {
        tk = new PdfTokenizer(new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(PdfEncodings.convertToBytes((String)da, null))));
        stack = new ArrayList<String>();
        ret = new Object[3];
lbl4:
        // 5 sources

        try {
            block14: while (tk.nextToken()) {
                block15: {
                    if (tk.getTokenType() == PdfTokenizer.TokenType.Comment) continue;
                    if (tk.getTokenType() != PdfTokenizer.TokenType.Other) break block15;
                    var4_4 = tk.getStringValue();
                    var5_6 = -1;
                    switch (var4_4.hashCode()) {
                        case 2706: {
                            if (!var4_4.equals("Tf")) break;
                            var5_6 = 0;
                            break;
                        }
                        case 103: {
                            if (!var4_4.equals("g")) break;
                            var5_6 = 1;
                            break;
                        }
                        case 3637: {
                            if (!var4_4.equals("rg")) break;
                            var5_6 = 2;
                            break;
                        }
                        case 107: {
                            if (!var4_4.equals("k")) break;
                            var5_6 = 3;
                            break;
                        }
                    }
                    switch (var5_6) {
                        case 0: {
                            if (stack.size() < 2) continue block14;
                            ret[0] = stack.get(stack.size() - 2);
                            ret[1] = new Float((String)stack.get(stack.size() - 1));
                            ** GOTO lbl4
                        }
                        case 1: {
                            if (stack.size() < 1 || (gray = new Float((String)stack.get(stack.size() - 1)).floatValue()) == 0.0f) continue block14;
                            ret[2] = new DeviceGray(gray);
                            ** GOTO lbl4
                        }
                        case 2: {
                            if (stack.size() < 3) continue block14;
                            red = new Float((String)stack.get(stack.size() - 3)).floatValue();
                            green = new Float((String)stack.get(stack.size() - 2)).floatValue();
                            blue = new Float((String)stack.get(stack.size() - 1)).floatValue();
                            ret[2] = new DeviceRgb(red, green, blue);
                            ** GOTO lbl4
                        }
                        case 3: {
                            if (stack.size() < 4) continue block14;
                            cyan = new Float((String)stack.get(stack.size() - 4)).floatValue();
                            magenta = new Float((String)stack.get(stack.size() - 3)).floatValue();
                            yellow = new Float((String)stack.get(stack.size() - 2)).floatValue();
                            black = new Float((String)stack.get(stack.size() - 1)).floatValue();
                            ret[2] = new DeviceCmyk(cyan, magenta, yellow, black);
                            ** GOTO lbl4
                        }
                    }
                    stack.clear();
                    continue;
                }
                stack.add(tk.getStringValue());
            }
            return ret;
        }
        catch (Exception var4_5) {
            // empty catch block
        }
        return ret;
    }

    protected void drawTextAppearance(Rectangle rect, PdfFont font, float fontSize, String value, PdfFormXObject appearance) {
        PdfStream stream = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfResources resources = appearance.getResources();
        PdfCanvas canvas = new PdfCanvas(stream, resources, this.getDocument());
        float height = rect.getHeight();
        float width = rect.getWidth();
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, width, height));
        this.drawBorder(canvas, xObject, width, height);
        if (this.isPassword()) {
            value = this.obfuscatePassword(value);
        }
        canvas.beginVariableText().saveState().endPath();
        TextAlignment textAlignment = this.convertJustificationToTextAlignment();
        float x = 0.0f;
        if (textAlignment == TextAlignment.RIGHT) {
            x = rect.getWidth();
        } else if (textAlignment == TextAlignment.CENTER) {
            x = rect.getWidth() / 2.0f;
        }
        Canvas modelCanvas = new Canvas(canvas, new Rectangle(0.0f, -height, 0.0f, 2.0f * height));
        modelCanvas.setProperty(82, (Object)true);
        Style paragraphStyle = (Style)((Style)new Style().setFont(font)).setFontSize(fontSize);
        paragraphStyle.setProperty(33, (Object)new Leading(2, 1.0f));
        if (this.color != null) {
            paragraphStyle.setProperty(21, (Object)new TransparentColor(this.color));
        }
        int maxLen = new PdfTextFormField((PdfDictionary)this.getPdfObject()).getMaxLen();
        if (this.getFieldFlag(PdfTextFormField.FF_COMB) && 0 != maxLen) {
            int start;
            float widthPerCharacter = width / (float)maxLen;
            int numberOfCharacters = Math.min(maxLen, value.length());
            switch (textAlignment) {
                case RIGHT: {
                    start = maxLen - numberOfCharacters;
                    break;
                }
                case CENTER: {
                    start = (maxLen - numberOfCharacters) / 2;
                    break;
                }
                default: {
                    start = 0;
                }
            }
            float startOffset = widthPerCharacter * ((float)start + 0.5f);
            for (int i = 0; i < numberOfCharacters; ++i) {
                modelCanvas.showTextAligned((Paragraph)new Paragraph(value.substring(i, i + 1)).addStyle(paragraphStyle), startOffset + widthPerCharacter * (float)i, rect.getHeight() / 2.0f, TextAlignment.CENTER, VerticalAlignment.MIDDLE);
            }
        } else {
            if (this.getFieldFlag(PdfTextFormField.FF_COMB)) {
                Logger logger = LoggerFactory.getLogger(PdfFormField.class);
                logger.error(MessageFormatUtil.format((String)"The Comb flag may be set only if the MaxLen entry is present in the text field dictionary and if the Multiline, Password, and FileSelect flags are clear.", (Object[])new Object[0]));
            }
            modelCanvas.showTextAligned((Paragraph)((Paragraph)PdfFormField.createParagraphForTextFieldValue(value).addStyle(paragraphStyle)).setPaddings(0.0f, 2.0f, 0.0f, 2.0f), x, rect.getHeight() / 2.0f, textAlignment, VerticalAlignment.MIDDLE);
        }
        canvas.restoreState().endVariableText();
        ((PdfStream)appearance.getPdfObject()).setData(stream.getBytes());
    }

    @Deprecated
    protected void drawMultiLineTextAppearance(Rectangle rect, PdfFont font, float fontSize, String value, PdfFormXObject appearance) {
        this.drawMultiLineTextAppearance(rect, font, value, appearance);
    }

    protected void drawMultiLineTextAppearance(Rectangle rect, PdfFont font, String value, PdfFormXObject appearance) {
        PdfStream stream = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfResources resources = appearance.getResources();
        PdfCanvas canvas = new PdfCanvas(stream, resources, this.getDocument());
        float width = rect.getWidth();
        float height = rect.getHeight();
        this.drawBorder(canvas, appearance, width, height);
        canvas.beginVariableText();
        Rectangle areaRect = new Rectangle(0.0f, 0.0f, width, height);
        Canvas modelCanvas = new Canvas(canvas, areaRect);
        modelCanvas.setProperty(82, (Object)true);
        Paragraph paragraph = ((Paragraph)((Paragraph)((Paragraph)PdfFormField.createParagraphForTextFieldValue(value).setFont(font)).setMargin(0.0f)).setPadding(3.0f)).setMultipliedLeading(1.0f);
        if (this.fontSize == 0.0f) {
            paragraph.setFontSize(this.approximateFontSizeToFitMultiLine(paragraph, areaRect, (IRenderer)modelCanvas.getRenderer()));
        } else {
            paragraph.setFontSize(this.fontSize);
        }
        paragraph.setProperty(26, (Object)true);
        paragraph.setTextAlignment(this.convertJustificationToTextAlignment());
        if (this.color != null) {
            paragraph.setFontColor(this.color);
        }
        paragraph.setHeight(height - 1.0E-5f);
        paragraph.setProperty(105, (Object)BoxSizingPropertyValue.BORDER_BOX);
        paragraph.setProperty(103, (Object)OverflowPropertyValue.FIT);
        paragraph.setProperty(104, (Object)OverflowPropertyValue.HIDDEN);
        modelCanvas.add((IBlockElement)paragraph);
        canvas.endVariableText();
        ((PdfStream)appearance.getPdfObject()).setData(stream.getBytes());
    }

    private void drawChoiceAppearance(Rectangle rect, float fontSize, String value, PdfFormXObject appearance, int topIndex) {
        Boolean isFull;
        PdfStream stream = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfResources resources = appearance.getResources();
        PdfCanvas canvas = new PdfCanvas(stream, resources, this.getDocument());
        float width = rect.getWidth();
        float height = rect.getHeight();
        float widthBorder = 6.0f;
        float heightBorder = 2.0f;
        List strings = this.font.splitString(value, fontSize, width - widthBorder);
        this.drawBorder(canvas, appearance, width, height);
        canvas.beginVariableText().saveState().rectangle(3.0, 3.0, (double)(width - widthBorder), (double)(height - heightBorder)).clip().endPath();
        Canvas modelCanvas = new Canvas(canvas, new Rectangle(3.0f, 0.0f, Math.max(0.0f, width - widthBorder), Math.max(0.0f, height - heightBorder)));
        modelCanvas.setProperty(82, (Object)true);
        Div div = new Div();
        if (this.getFieldFlag(PdfChoiceFormField.FF_COMBO)) {
            div.setVerticalAlignment(VerticalAlignment.MIDDLE);
        }
        div.setHeight(Math.max(0.0f, height - heightBorder));
        for (int index = 0; index < strings.size() && !Boolean.TRUE.equals(isFull = modelCanvas.getRenderer().getPropertyAsBoolean(25)); ++index) {
            Paragraph paragraph = ((Paragraph)((Paragraph)((Paragraph)new Paragraph((String)strings.get(index)).setFont(this.font)).setFontSize(fontSize)).setMargins(0.0f, 0.0f, 0.0f, 0.0f)).setMultipliedLeading(1.0f);
            paragraph.setProperty(26, (Object)true);
            paragraph.setTextAlignment(this.convertJustificationToTextAlignment());
            if (this.color != null) {
                paragraph.setFontColor(this.color);
            }
            if (!this.getFieldFlag(PdfChoiceFormField.FF_COMBO)) {
                PdfArray indices = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.I);
                if (indices == null && this.getKids() == null && this.getParent() != null) {
                    indices = this.getParent().getAsArray(PdfName.I);
                }
                if (indices != null && indices.size() > 0) {
                    for (PdfObject ind : indices) {
                        if (!ind.isNumber() || ((PdfNumber)ind).getValue() != (double)(index + topIndex)) continue;
                        paragraph.setBackgroundColor((Color)new DeviceRgb(10, 36, 106));
                        paragraph.setFontColor(ColorConstants.LIGHT_GRAY);
                    }
                }
            }
            div.add((IBlockElement)paragraph);
        }
        modelCanvas.add((IBlockElement)div);
        canvas.restoreState().endVariableText();
        ((PdfStream)appearance.getPdfObject()).setData(stream.getBytes());
    }

    protected void drawBorder(PdfCanvas canvas, PdfFormXObject xObject, float width, float height) {
        canvas.saveState();
        float borderWidth = this.getBorderWidth();
        PdfDictionary bs = this.getWidgets().get(0).getBorderStyle();
        if (borderWidth < 0.0f) {
            borderWidth = 0.0f;
        }
        if (this.backgroundColor != null) {
            canvas.setFillColor(this.backgroundColor).rectangle(0.0, 0.0, (double)width, (double)height).fill();
        }
        if (borderWidth > 0.0f && this.borderColor != null) {
            PdfName borderType;
            borderWidth = Math.max(1.0f, borderWidth);
            canvas.setStrokeColor(this.borderColor).setLineWidth(borderWidth);
            if (bs != null && (borderType = bs.getAsName(PdfName.S)) != null && borderType.equals((Object)PdfName.D)) {
                int unitsOn;
                PdfArray dashArray = bs.getAsArray(PdfName.D);
                int n = dashArray != null ? (dashArray.size() > 0 ? (dashArray.getAsNumber(0) != null ? dashArray.getAsNumber(0).intValue() : 3) : 3) : (unitsOn = 3);
                int unitsOff = dashArray != null ? (dashArray.size() > 1 ? (dashArray.getAsNumber(1) != null ? dashArray.getAsNumber(1).intValue() : unitsOn) : unitsOn) : unitsOn;
                canvas.setLineDash((float)unitsOn, (float)unitsOff, 0.0f);
            }
            canvas.rectangle(0.0, 0.0, (double)width, (double)height).stroke();
        }
        this.applyRotation(xObject, height, width);
        canvas.restoreState();
    }

    protected void drawRadioBorder(PdfCanvas canvas, PdfFormXObject xObject, float width, float height) {
        canvas.saveState();
        float borderWidth = this.getBorderWidth();
        float cx = width / 2.0f;
        float cy = height / 2.0f;
        if (borderWidth < 0.0f) {
            borderWidth = 0.0f;
        }
        float r = (Math.min(width, height) - borderWidth) / 2.0f;
        if (this.backgroundColor != null) {
            canvas.setFillColor(this.backgroundColor).circle((double)cx, (double)cy, (double)(r + borderWidth / 2.0f)).fill();
        }
        if (borderWidth > 0.0f && this.borderColor != null) {
            borderWidth = Math.max(1.0f, borderWidth);
            canvas.setStrokeColor(this.borderColor).setLineWidth(borderWidth).circle((double)cx, (double)cy, (double)r).stroke();
        }
        this.applyRotation(xObject, height, width);
        canvas.restoreState();
    }

    protected void drawRadioAppearance(float width, float height, String value) {
        Rectangle rect = new Rectangle(0.0f, 0.0f, width, height);
        PdfWidgetAnnotation widget = this.getWidgets().get(0);
        widget.setNormalAppearance(new PdfDictionary());
        PdfFormXObject xObjectOn = new PdfFormXObject(rect);
        if (value != null) {
            PdfStream streamOn = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
            PdfCanvas canvasOn = new PdfCanvas(streamOn, new PdfResources(), this.getDocument());
            this.drawRadioBorder(canvasOn, xObjectOn, width, height);
            this.drawRadioField(canvasOn, width, height, true);
            ((PdfStream)xObjectOn.getPdfObject()).getOutputStream().writeBytes(streamOn.getBytes());
            widget.getNormalAppearanceObject().put(new PdfName(value), xObjectOn.getPdfObject());
        }
        PdfStream streamOff = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvasOff = new PdfCanvas(streamOff, new PdfResources(), this.getDocument());
        PdfFormXObject xObjectOff = new PdfFormXObject(rect);
        this.drawRadioBorder(canvasOff, xObjectOff, width, height);
        ((PdfStream)xObjectOff.getPdfObject()).getOutputStream().writeBytes(streamOff.getBytes());
        widget.getNormalAppearanceObject().put(new PdfName("Off"), xObjectOff.getPdfObject());
        if (this.pdfAConformanceLevel != null && ("2".equals(this.pdfAConformanceLevel.getPart()) || "3".equals(this.pdfAConformanceLevel.getPart()))) {
            xObjectOn.getResources();
            xObjectOff.getResources();
        }
    }

    @Deprecated
    protected void drawPdfA1RadioAppearance(float width, float height, String value) {
        PdfStream stream = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvas = new PdfCanvas(stream, new PdfResources(), this.getDocument());
        Rectangle rect = new Rectangle(0.0f, 0.0f, width, height);
        PdfFormXObject xObject = new PdfFormXObject(rect);
        this.drawBorder(canvas, xObject, width, height);
        this.drawRadioField(canvas, rect.getWidth(), rect.getHeight(), !"Off".equals(value));
        PdfDictionary normalAppearance = new PdfDictionary();
        normalAppearance.put(new PdfName(value), xObject.getPdfObject());
        PdfWidgetAnnotation widget = this.getWidgets().get(0);
        ((PdfStream)xObject.getPdfObject()).getOutputStream().writeBytes(stream.getBytes());
        widget.setNormalAppearance(normalAppearance);
    }

    protected void drawRadioField(PdfCanvas canvas, float width, float height, boolean on) {
        canvas.saveState();
        if (on) {
            canvas.resetFillColorRgb();
            DrawingUtil.drawCircle(canvas, width / 2.0f, height / 2.0f, Math.min(width, height) / 4.0f);
        }
        canvas.restoreState();
    }

    protected void drawCheckAppearance(float width, float height, String onStateName) {
        Rectangle rect = new Rectangle(0.0f, 0.0f, width, height);
        PdfStream streamOn = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvasOn = new PdfCanvas(streamOn, new PdfResources(), this.getDocument());
        PdfFormXObject xObjectOn = new PdfFormXObject(rect);
        this.drawBorder(canvasOn, xObjectOn, width, height);
        this.drawCheckBox(canvasOn, width, height, this.fontSize, true);
        ((PdfStream)xObjectOn.getPdfObject()).getOutputStream().writeBytes(streamOn.getBytes());
        xObjectOn.getResources().addFont(this.getDocument(), this.getFont());
        PdfStream streamOff = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvasOff = new PdfCanvas(streamOff, new PdfResources(), this.getDocument());
        PdfFormXObject xObjectOff = new PdfFormXObject(rect);
        this.drawBorder(canvasOff, xObjectOff, width, height);
        this.drawCheckBox(canvasOff, width, height, this.fontSize, false);
        ((PdfStream)xObjectOff.getPdfObject()).getOutputStream().writeBytes(streamOff.getBytes());
        xObjectOff.getResources().addFont(this.getDocument(), this.getFont());
        PdfDictionary normalAppearance = new PdfDictionary();
        normalAppearance.put(new PdfName(onStateName), xObjectOn.getPdfObject());
        normalAppearance.put(new PdfName("Off"), xObjectOff.getPdfObject());
        PdfDictionary mk = new PdfDictionary();
        mk.put(PdfName.CA, (PdfObject)new PdfString(this.text));
        PdfWidgetAnnotation widget = this.getWidgets().get(0);
        widget.put(PdfName.MK, (PdfObject)mk);
        widget.setNormalAppearance(normalAppearance);
    }

    protected void drawPdfA2CheckAppearance(float width, float height, String onStateName, int checkType) {
        this.checkType = checkType;
        Rectangle rect = new Rectangle(0.0f, 0.0f, width, height);
        PdfStream streamOn = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvasOn = new PdfCanvas(streamOn, new PdfResources(), this.getDocument());
        PdfFormXObject xObjectOn = new PdfFormXObject(rect);
        xObjectOn.getResources();
        this.drawBorder(canvasOn, xObjectOn, width, height);
        this.drawPdfACheckBox(canvasOn, width, height, true);
        ((PdfStream)xObjectOn.getPdfObject()).getOutputStream().writeBytes(streamOn.getBytes());
        PdfStream streamOff = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvasOff = new PdfCanvas(streamOff, new PdfResources(), this.getDocument());
        PdfFormXObject xObjectOff = new PdfFormXObject(rect);
        xObjectOff.getResources();
        this.drawBorder(canvasOff, xObjectOff, width, height);
        ((PdfStream)xObjectOff.getPdfObject()).getOutputStream().writeBytes(streamOff.getBytes());
        PdfDictionary normalAppearance = new PdfDictionary();
        normalAppearance.put(new PdfName(onStateName), xObjectOn.getPdfObject());
        normalAppearance.put(new PdfName("Off"), xObjectOff.getPdfObject());
        PdfDictionary mk = new PdfDictionary();
        mk.put(PdfName.CA, (PdfObject)new PdfString(this.text));
        PdfWidgetAnnotation widget = this.getWidgets().get(0);
        widget.put(PdfName.MK, (PdfObject)mk);
        widget.setNormalAppearance(normalAppearance);
    }

    @Deprecated
    protected void drawPdfA1CheckAppearance(float width, float height, String selectedValue, int checkType) {
        PdfStream stream = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvas = new PdfCanvas(stream, new PdfResources(), this.getDocument());
        Rectangle rect = new Rectangle(0.0f, 0.0f, width, height);
        PdfFormXObject xObject = new PdfFormXObject(rect);
        this.checkType = checkType;
        this.drawBorder(canvas, xObject, width, height);
        this.drawPdfACheckBox(canvas, width, height, !"Off".equals(selectedValue));
        ((PdfStream)xObject.getPdfObject()).getOutputStream().writeBytes(stream.getBytes());
        PdfDictionary normalAppearance = new PdfDictionary();
        normalAppearance.put(new PdfName(selectedValue), xObject.getPdfObject());
        PdfDictionary mk = new PdfDictionary();
        mk.put(PdfName.CA, (PdfObject)new PdfString(this.text));
        PdfWidgetAnnotation widget = this.getWidgets().get(0);
        widget.put(PdfName.MK, (PdfObject)mk);
        widget.setNormalAppearance(normalAppearance);
    }

    protected PdfFormXObject drawPushButtonAppearance(float width, float height, String text, PdfFont font, float fontSize) {
        PdfStream stream = (PdfStream)new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvas = new PdfCanvas(stream, new PdfResources(), this.getDocument());
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, width, height));
        this.drawBorder(canvas, xObject, width, height);
        if (this.img != null) {
            PdfImageXObject imgXObj = new PdfImageXObject(this.img);
            canvas.addXObject((PdfXObject)imgXObj, width - this.borderWidth, 0.0f, 0.0f, height - this.borderWidth, this.borderWidth / 2.0f, this.borderWidth / 2.0f);
            xObject.getResources().addImage(imgXObj);
        } else if (this.form != null) {
            canvas.addXObject((PdfXObject)this.form, (height - this.borderWidth) / this.form.getHeight(), 0.0f, 0.0f, (height - this.borderWidth) / this.form.getHeight(), this.borderWidth / 2.0f, this.borderWidth / 2.0f);
            xObject.getResources().addForm(this.form);
        } else {
            this.drawButton(canvas, 0.0f, 0.0f, width, height, text, font, fontSize);
            xObject.getResources().addFont(this.getDocument(), font);
        }
        ((PdfStream)xObject.getPdfObject()).getOutputStream().writeBytes(stream.getBytes());
        return xObject;
    }

    @Deprecated
    protected PdfFormXObject drawPushButtonAppearance(float width, float height, String text, PdfFont font, PdfName fontName, float fontSize) {
        return this.drawPushButtonAppearance(width, height, text, font, fontSize);
    }

    protected void drawButton(PdfCanvas canvas, float x, float y, float width, float height, String text, PdfFont font, float fontSize) {
        if (this.color == null) {
            this.color = ColorConstants.BLACK;
        }
        if (text == null) {
            text = "";
        }
        Paragraph paragraph = (Paragraph)((Paragraph)((Paragraph)((Paragraph)new Paragraph(text).setFont(font)).setFontSize(fontSize)).setMargin(0.0f)).setMultipliedLeading(1.0f).setVerticalAlignment(VerticalAlignment.MIDDLE);
        Canvas modelCanvas = new Canvas(canvas, new Rectangle(0.0f, -height, width, 2.0f * height));
        modelCanvas.setProperty(82, (Object)true);
        modelCanvas.showTextAligned(paragraph, width / 2.0f, height / 2.0f, TextAlignment.CENTER, VerticalAlignment.MIDDLE);
    }

    protected void drawCheckBox(PdfCanvas canvas, float width, float height, float fontSize, boolean on) {
        if (!on) {
            return;
        }
        if (this.checkType == 3) {
            DrawingUtil.drawCross(canvas, width, height, this.borderWidth);
            return;
        }
        PdfFont ufont = this.getFont();
        if (fontSize <= 0.0f) {
            fontSize = this.approximateFontSizeToFitSingleLine(ufont, new Rectangle(width, height), this.text, 0.1f);
        }
        canvas.beginText().setFontAndSize(ufont, fontSize).resetFillColorRgb().setTextMatrix((width - ufont.getWidth(this.text, fontSize)) / 2.0f, (height - (float)ufont.getAscent(this.text, fontSize)) / 2.0f).showText(this.text).endText();
    }

    protected void drawPdfACheckBox(PdfCanvas canvas, float width, float height, boolean on) {
        if (!on) {
            return;
        }
        switch (this.checkType) {
            case 1: {
                DrawingUtil.drawPdfACheck(canvas, width, height);
                break;
            }
            case 2: {
                DrawingUtil.drawPdfACircle(canvas, width, height);
                break;
            }
            case 3: {
                DrawingUtil.drawPdfACross(canvas, width, height);
                break;
            }
            case 4: {
                DrawingUtil.drawPdfADiamond(canvas, width, height);
                break;
            }
            case 5: {
                DrawingUtil.drawPdfASquare(canvas, width, height);
                break;
            }
            case 6: {
                DrawingUtil.drawPdfAStar(canvas, width, height);
            }
        }
    }

    private String getRadioButtonValue() {
        for (String state : this.getAppearanceStates()) {
            if ("Off".equals(state)) continue;
            return state;
        }
        return null;
    }

    private float getFontSize(PdfArray bBox, String value) {
        assert (!this.isMultiline());
        if (this.fontSize == 0.0f) {
            if (bBox == null || value == null || value.isEmpty()) {
                return 12.0f;
            }
            return this.approximateFontSizeToFitSingleLine(this.font, bBox.toRectangle(), value, 4.0f);
        }
        return this.fontSize;
    }

    private float approximateFontSizeToFitMultiLine(Paragraph paragraph, Rectangle rect, IRenderer parentRenderer) {
        IRenderer renderer = paragraph.createRendererSubTree().setParent(parentRenderer);
        LayoutContext layoutContext = new LayoutContext(new LayoutArea(1, rect));
        float lFontSize = 4.0f;
        float rFontSize = 12.0f;
        paragraph.setFontSize(12.0f);
        if (renderer.layout(layoutContext).getStatus() != 1) {
            int numberOfIterations = 6;
            for (int i = 0; i < 6; ++i) {
                float mFontSize = (lFontSize + rFontSize) / 2.0f;
                paragraph.setFontSize(mFontSize);
                LayoutResult result = renderer.layout(layoutContext);
                if (result.getStatus() == 1) {
                    lFontSize = mFontSize;
                    continue;
                }
                rFontSize = mFontSize;
            }
        } else {
            lFontSize = 12.0f;
        }
        return lFontSize;
    }

    private float approximateFontSizeToFitSingleLine(PdfFont localFont, Rectangle bBox, String value, float minValue) {
        float height = bBox.getHeight() - this.borderWidth * 2.0f;
        int[] fontBbox = localFont.getFontProgram().getFontMetrics().getBbox();
        float fs = height / (float)(fontBbox[2] - fontBbox[1]) * 1000.0f;
        float baseWidth = localFont.getWidth(value, 1.0f);
        if (baseWidth != 0.0f) {
            float absMaxPadding;
            float relativePaddingForSmallSizes;
            float availableWidth = Math.max(bBox.getWidth() - this.borderWidth * 2.0f, 0.0f);
            availableWidth = availableWidth * (relativePaddingForSmallSizes = 0.15f) < (absMaxPadding = 4.0f) ? (availableWidth -= availableWidth * relativePaddingForSmallSizes * 2.0f) : (availableWidth -= absMaxPadding * 2.0f);
            fs = Math.min(fs, availableWidth / baseWidth);
        }
        return Math.max(fs, minValue);
    }

    private float calculateTranslationHeightAfterFieldRot(Rectangle bBox, double pageRotation, double relFieldRotation) {
        if (relFieldRotation == 0.0) {
            return 0.0f;
        }
        if (pageRotation == 0.0) {
            if (relFieldRotation == 1.5707963267948966) {
                return bBox.getHeight();
            }
            if (relFieldRotation == Math.PI) {
                return bBox.getHeight();
            }
        }
        if (pageRotation == -1.5707963267948966) {
            if (relFieldRotation == -1.5707963267948966) {
                return bBox.getWidth() - bBox.getHeight();
            }
            if (relFieldRotation == 1.5707963267948966) {
                return bBox.getHeight();
            }
            if (relFieldRotation == Math.PI) {
                return bBox.getWidth();
            }
        }
        if (pageRotation == -Math.PI) {
            if (relFieldRotation == -Math.PI) {
                return bBox.getHeight();
            }
            if (relFieldRotation == -1.5707963267948966) {
                return bBox.getHeight() - bBox.getWidth();
            }
            if (relFieldRotation == 1.5707963267948966) {
                return bBox.getWidth();
            }
        }
        if (pageRotation == -4.71238898038469) {
            if (relFieldRotation == -4.71238898038469) {
                return bBox.getWidth();
            }
            if (relFieldRotation == -Math.PI) {
                return bBox.getWidth();
            }
        }
        return 0.0f;
    }

    private float calculateTranslationWidthAfterFieldRot(Rectangle bBox, double pageRotation, double relFieldRotation) {
        if (relFieldRotation == 0.0) {
            return 0.0f;
        }
        if (pageRotation == 0.0 && (relFieldRotation == Math.PI || relFieldRotation == 4.71238898038469)) {
            return bBox.getWidth();
        }
        if (pageRotation == -1.5707963267948966 && (relFieldRotation == -1.5707963267948966 || relFieldRotation == Math.PI)) {
            return bBox.getHeight();
        }
        if (pageRotation == -Math.PI) {
            if (relFieldRotation == -Math.PI) {
                return bBox.getWidth();
            }
            if (relFieldRotation == -1.5707963267948966) {
                return bBox.getHeight();
            }
            if (relFieldRotation == 1.5707963267948966) {
                return -1.0f * (bBox.getHeight() - bBox.getWidth());
            }
        }
        if (pageRotation == -4.71238898038469) {
            if (relFieldRotation == -4.71238898038469) {
                return -1.0f * (bBox.getWidth() - bBox.getHeight());
            }
            if (relFieldRotation == -Math.PI) {
                return bBox.getHeight();
            }
            if (relFieldRotation == -1.5707963267948966) {
                return bBox.getWidth();
            }
        }
        return 0.0f;
    }

    private boolean hasDefaultAppearance() {
        PdfName type = this.getFormType();
        return type == PdfName.Tx || type == PdfName.Ch || type == PdfName.Btn && (this.getFieldFlags() & PdfButtonFormField.FF_PUSH_BUTTON) != 0;
    }

    private PdfName getUniqueFontNameForDR(PdfDictionary fontResources) {
        PdfName uniqueName;
        int indexer = 1;
        Set fontNames = fontResources.keySet();
        while (fontNames.contains(uniqueName = new PdfName("F" + indexer++))) {
        }
        return uniqueName;
    }

    private PdfName getFontNameFromDR(PdfDictionary fontResources, PdfObject font) {
        for (Map.Entry drFont : fontResources.entrySet()) {
            if (drFont.getValue() != font) continue;
            return (PdfName)drFont.getKey();
        }
        return null;
    }

    private PdfObject getAcroFormObject(PdfName key, int type) {
        PdfObject acroFormObject = null;
        PdfDictionary acroFormDictionary = ((PdfDictionary)this.getDocument().getCatalog().getPdfObject()).getAsDictionary(PdfName.AcroForm);
        if (acroFormDictionary != null) {
            acroFormObject = acroFormDictionary.get(key);
        }
        return acroFormObject != null && acroFormObject.getType() == type ? acroFormObject : null;
    }

    private void putAcroFormObject(PdfName acroFormKey, PdfObject acroFormObject) {
        ((PdfDictionary)this.getDocument().getCatalog().getPdfObject()).getAsDictionary(PdfName.AcroForm).put(acroFormKey, acroFormObject);
    }

    private void addAcroFormToCatalog() {
        if (((PdfDictionary)this.getDocument().getCatalog().getPdfObject()).getAsDictionary(PdfName.AcroForm) == null) {
            PdfDictionary acroform = new PdfDictionary();
            acroform.makeIndirect(this.getDocument());
            acroform.put(PdfName.Fields, (PdfObject)new PdfArray());
            this.getDocument().getCatalog().put(PdfName.AcroForm, (PdfObject)acroform);
        }
    }

    private PdfObject getAcroFormKey(PdfName key, int type) {
        PdfDictionary acroFormDictionary;
        PdfObject acroFormKey = null;
        PdfDocument document = this.getDocument();
        if (document != null && (acroFormDictionary = ((PdfDictionary)document.getCatalog().getPdfObject()).getAsDictionary(PdfName.AcroForm)) != null) {
            acroFormKey = acroFormDictionary.get(key);
        }
        return acroFormKey != null && acroFormKey.getType() == type ? acroFormKey : null;
    }

    private TextAlignment convertJustificationToTextAlignment() {
        Integer justification = this.getJustification();
        if (justification == null) {
            justification = 0;
        }
        TextAlignment textAlignment = TextAlignment.LEFT;
        if (justification == 2) {
            textAlignment = TextAlignment.RIGHT;
        } else if (justification == 1) {
            textAlignment = TextAlignment.CENTER;
        }
        return textAlignment;
    }

    private PdfName getTypeFromParent(PdfDictionary field) {
        PdfDictionary parent = field.getAsDictionary(PdfName.Parent);
        PdfName formType = field.getAsName(PdfName.FT);
        if (parent != null && (formType = parent.getAsName(PdfName.FT)) == null) {
            formType = this.getTypeFromParent(parent);
        }
        return formType;
    }

    private String obfuscatePassword(String text) {
        char[] pchar = new char[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            pchar[i] = 42;
        }
        return new String(pchar);
    }

    private void applyRotation(PdfFormXObject xObject, float height, float width) {
        switch (this.rotation) {
            case 90: {
                xObject.put(PdfName.Matrix, (PdfObject)new PdfArray(new float[]{0.0f, 1.0f, -1.0f, 0.0f, height, 0.0f}));
                break;
            }
            case 180: {
                xObject.put(PdfName.Matrix, (PdfObject)new PdfArray(new float[]{-1.0f, 0.0f, 0.0f, -1.0f, width, height}));
                break;
            }
            case 270: {
                xObject.put(PdfName.Matrix, (PdfObject)new PdfArray(new float[]{0.0f, -1.0f, 1.0f, 0.0f, 0.0f, width}));
            }
        }
    }

    private PdfObject getValueFromAppearance(PdfObject appearanceDict, PdfName key) {
        if (appearanceDict instanceof PdfDictionary) {
            return ((PdfDictionary)appearanceDict).get(key);
        }
        return null;
    }

    private void retrieveStyles() {
        Object[] fontData;
        PdfString defaultAppearance;
        PdfDictionary appearanceCharacteristics;
        PdfName subType = ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.Subtype);
        if (subType != null && subType.equals((Object)PdfName.Widget) && (appearanceCharacteristics = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.MK)) != null) {
            this.backgroundColor = this.appearancePropToColor(appearanceCharacteristics, PdfName.BG);
            Color extractedBorderColor = this.appearancePropToColor(appearanceCharacteristics, PdfName.BC);
            if (extractedBorderColor != null) {
                this.borderColor = extractedBorderColor;
            }
        }
        if ((defaultAppearance = this.getDefaultAppearance()) != null && (fontData = PdfFormField.splitDAelements(defaultAppearance.getValue()))[1] != null && fontData[0] != null) {
            this.color = (Color)fontData[2];
            this.fontSize = ((Float)fontData[1]).floatValue();
            this.font = this.resolveFontName((String)fontData[0]);
        }
        this.updateFontAndFontSize(this.font, this.fontSize);
    }

    private PdfFont resolveFontName(String fontName) {
        PdfDictionary daFontDict;
        PdfDictionary defaultFontDic;
        PdfDictionary defaultResources = (PdfDictionary)this.getAcroFormObject(PdfName.DR, 3);
        PdfDictionary pdfDictionary = defaultFontDic = defaultResources != null ? defaultResources.getAsDictionary(PdfName.Font) : null;
        if (fontName != null && defaultFontDic != null && (daFontDict = defaultFontDic.getAsDictionary(new PdfName(fontName))) != null) {
            return this.getDocument().getFont(daFontDict);
        }
        return null;
    }

    private Color appearancePropToColor(PdfDictionary appearanceCharacteristics, PdfName property) {
        PdfArray colorData = appearanceCharacteristics.getAsArray(property);
        if (colorData != null) {
            float[] backgroundFloat = new float[colorData.size()];
            for (int i = 0; i < colorData.size(); ++i) {
                backgroundFloat[i] = colorData.getAsNumber(i).floatValue();
            }
            switch (colorData.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return new DeviceGray(backgroundFloat[0]);
                }
                case 3: {
                    return new DeviceRgb(backgroundFloat[0], backgroundFloat[1], backgroundFloat[2]);
                }
                case 4: {
                    return new DeviceCmyk(backgroundFloat[0], backgroundFloat[1], backgroundFloat[2], backgroundFloat[3]);
                }
            }
        }
        return null;
    }

    private void regeneratePushButtonField() {
        PdfDictionary widget = (PdfDictionary)this.getPdfObject();
        Rectangle rect = this.getRect(widget);
        PdfDictionary apDic = widget.getAsDictionary(PdfName.AP);
        if (apDic == null) {
            apDic = new PdfDictionary();
            this.put(PdfName.AP, (PdfObject)apDic);
        }
        PdfFormXObject appearance = this.drawPushButtonAppearance(rect.getWidth(), rect.getHeight(), this.text, this.font, this.getFontSize(widget.getAsArray(PdfName.Rect), this.text));
        apDic.put(PdfName.N, appearance.getPdfObject());
        if (this.pdfAConformanceLevel != null) {
            PdfFormField.createPushButtonAppearanceState(widget);
        }
    }

    private void regenerateRadioButtonField() {
        Rectangle rect = this.getRect((PdfDictionary)this.getPdfObject());
        String value = this.getRadioButtonValue();
        if (rect != null && !"".equals(value)) {
            this.drawRadioAppearance(rect.getWidth(), rect.getHeight(), value);
        }
    }

    private void regenerateCheckboxField(String value) {
        Rectangle rect = this.getRect((PdfDictionary)this.getPdfObject());
        this.setCheckType(this.checkType);
        PdfWidgetAnnotation widget = (PdfWidgetAnnotation)PdfAnnotation.makeAnnotation((PdfObject)this.getPdfObject());
        if (this.pdfAConformanceLevel != null) {
            this.drawPdfA2CheckAppearance(rect.getWidth(), rect.getHeight(), "Off".equals(value) ? "Yes" : value, this.checkType);
            widget.setFlag(4);
        } else {
            this.drawCheckAppearance(rect.getWidth(), rect.getHeight(), "Off".equals(value) ? "Yes" : value);
        }
        if (widget.getNormalAppearanceObject() != null && widget.getNormalAppearanceObject().containsKey(new PdfName(value))) {
            widget.setAppearanceState(new PdfName(value));
        } else {
            widget.setAppearanceState(new PdfName("Off"));
        }
    }

    private boolean regenerateTextAndChoiceField(String value, PdfName type) {
        PdfArray matrix;
        double translationHeight;
        double translationWidth;
        PdfPage page = PdfWidgetAnnotation.makeAnnotation((PdfObject)this.getPdfObject()).getPage();
        PdfArray bBox = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Rect);
        int pageRotation = 0;
        if (page != null) {
            pageRotation = page.getRotation();
            pageRotation *= -1;
        }
        if (pageRotation % 90 == 0) {
            double angle = pageRotation % 360;
            angle = PdfFormField.degreeToRadians(angle);
            Rectangle initialBboxRectangle = bBox.toRectangle();
            Rectangle rect = initialBboxRectangle.clone();
            translationWidth = 0.0;
            translationHeight = 0.0;
            if (angle >= -Math.PI && angle <= -1.5707963267948966) {
                translationWidth = rect.getWidth();
            }
            if (angle <= -Math.PI) {
                translationHeight = rect.getHeight();
            }
            matrix = new PdfArray(new double[]{Math.cos(angle), -Math.sin(angle), Math.sin(angle), Math.cos(angle), translationWidth, translationHeight});
            if (angle % 1.5707963267948966 == 0.0 && angle % Math.PI != 0.0) {
                rect.setWidth(initialBboxRectangle.getHeight());
                rect.setHeight(initialBboxRectangle.getWidth());
            }
            rect.setX(rect.getX() + (float)translationWidth);
            rect.setY(rect.getY() + (float)translationHeight);
            bBox = new PdfArray(rect);
        } else {
            Logger logger = LoggerFactory.getLogger(PdfFormField.class);
            logger.error("Encounterd a page rotation that was not a multiple of 90\u00b0/ (Pi/2) when generating default appearances for form fields");
            matrix = new PdfArray(new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0});
        }
        float fieldRotation = 0.0f;
        if (((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.MK) != null && ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.MK).get(PdfName.R) != null) {
            fieldRotation = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.MK).getAsFloat(PdfName.R).floatValue();
            fieldRotation += (float)pageRotation;
        }
        if (fieldRotation % 90.0f == 0.0f) {
            Rectangle initialBboxRectangle = bBox.toRectangle();
            double angle = fieldRotation % 360.0f;
            angle = PdfFormField.degreeToRadians(angle);
            translationWidth = this.calculateTranslationWidthAfterFieldRot(initialBboxRectangle, PdfFormField.degreeToRadians(pageRotation), angle);
            translationHeight = this.calculateTranslationHeightAfterFieldRot(initialBboxRectangle, PdfFormField.degreeToRadians(pageRotation), angle);
            Matrix currentMatrix = new Matrix(matrix.getAsNumber(0).floatValue(), matrix.getAsNumber(1).floatValue(), matrix.getAsNumber(2).floatValue(), matrix.getAsNumber(3).floatValue(), matrix.getAsNumber(4).floatValue(), matrix.getAsNumber(5).floatValue());
            Matrix toConcatenate = new Matrix((float)Math.cos(angle), (float)(-Math.sin(angle)), (float)Math.sin(angle), (float)Math.cos(angle), (float)translationWidth, (float)translationHeight);
            currentMatrix = currentMatrix.multiply(toConcatenate);
            matrix = new PdfArray(new float[]{currentMatrix.get(0), currentMatrix.get(1), currentMatrix.get(3), currentMatrix.get(4), currentMatrix.get(6), currentMatrix.get(7)});
            Rectangle rect = initialBboxRectangle.clone();
            if (angle % 1.5707963267948966 == 0.0 && angle % Math.PI != 0.0) {
                rect.setWidth(initialBboxRectangle.getHeight());
                rect.setHeight(initialBboxRectangle.getWidth());
            }
            rect.setX(rect.getX() + (float)translationWidth);
            rect.setY(rect.getY() + (float)translationHeight);
            bBox = new PdfArray(rect);
        }
        Rectangle bboxRectangle = bBox.toRectangle();
        PdfFormXObject appearance = new PdfFormXObject(new Rectangle(0.0f, 0.0f, bboxRectangle.getWidth(), bboxRectangle.getHeight()));
        appearance.put(PdfName.Matrix, (PdfObject)matrix);
        if (PdfName.Tx.equals((Object)type)) {
            if (this.isMultiline()) {
                this.drawMultiLineTextAppearance(bboxRectangle, this.font, value, appearance);
            } else {
                this.drawTextAppearance(bboxRectangle, this.font, this.getFontSize(bBox, value), value, appearance);
            }
        } else {
            int topIndex = 0;
            if (!this.getFieldFlag(PdfChoiceFormField.FF_COMBO)) {
                PdfArray options;
                PdfNumber topIndexNum = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.TI);
                if (topIndexNum == null && this.getParent() != null) {
                    topIndexNum = this.getParent().getAsNumber(PdfName.TI);
                }
                if (null == (options = this.getOptions()) && this.getParent() != null) {
                    options = this.getParent().getAsArray(PdfName.Opt);
                }
                if (null != options) {
                    topIndex = null != topIndexNum ? topIndexNum.intValue() : 0;
                    PdfArray visibleOptions = topIndex > 0 ? new PdfArray(options.subList(topIndex, options.size())) : (PdfArray)options.clone();
                    value = PdfFormField.optionsArrayToString(visibleOptions);
                }
            }
            this.drawChoiceAppearance(bboxRectangle, this.getFontSize(bBox, value), value, appearance, topIndex);
        }
        PdfDictionary ap = new PdfDictionary();
        ap.put(PdfName.N, appearance.getPdfObject());
        ap.setModified();
        this.put(PdfName.AP, (PdfObject)ap);
        return true;
    }

    private void copyParamsToKids(PdfFormField child) {
        if (child.checkType <= 0 || child.checkType > 5) {
            child.checkType = this.checkType;
        }
        if (child.getDefaultAppearance() == null) {
            child.font = this.font;
            child.fontSize = this.fontSize;
        }
        if (child.color == null) {
            child.color = this.color;
        }
        if (child.text == null) {
            child.text = this.text;
        }
        if (child.img == null) {
            child.img = this.img;
        }
        if (child.borderWidth == 1.0f) {
            child.borderWidth = this.borderWidth;
        }
        if (child.backgroundColor == null) {
            child.backgroundColor = this.backgroundColor;
        }
        if (child.borderColor == null) {
            child.borderColor = this.borderColor;
        }
        if (child.rotation == 0) {
            child.rotation = this.rotation;
        }
        if (child.pdfAConformanceLevel == null) {
            child.pdfAConformanceLevel = this.pdfAConformanceLevel;
        }
        if (child.form == null) {
            child.form = this.form;
        }
    }

    private boolean regenerateWidget(String value) {
        PdfName type = this.getFormType();
        if (PdfName.Tx.equals((Object)type) || PdfName.Ch.equals((Object)type)) {
            return this.regenerateTextAndChoiceField(value, type);
        }
        if (PdfName.Btn.equals((Object)type)) {
            if (this.getFieldFlag(PdfButtonFormField.FF_PUSH_BUTTON)) {
                this.regeneratePushButtonField();
            } else if (this.getFieldFlag(PdfButtonFormField.FF_RADIO)) {
                this.regenerateRadioButtonField();
            } else {
                this.regenerateCheckboxField(value);
            }
            return true;
        }
        return false;
    }

    private static String optionsArrayToString(PdfArray options) {
        StringBuilder sb = new StringBuilder();
        for (PdfObject obj : options) {
            if (obj.isString()) {
                sb.append(((PdfString)obj).toUnicodeString()).append('\n');
                continue;
            }
            if (obj.isArray()) {
                PdfObject element = ((PdfArray)obj).get(1);
                if (!element.isString()) continue;
                sb.append(((PdfString)element).toUnicodeString()).append('\n');
                continue;
            }
            sb.append('\n');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private static double degreeToRadians(double angle) {
        return Math.PI * angle / 180.0;
    }

    private static PdfString generateDefaultAppearance(PdfName font, float fontSize, Color textColor) {
        assert (font != null);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PdfOutputStream pdfStream = new PdfOutputStream((OutputStream)new com.itextpdf.io.source.OutputStream((OutputStream)output));
        byte[] g = new byte[]{103};
        byte[] rg = new byte[]{114, 103};
        byte[] k = new byte[]{107};
        byte[] Tf = new byte[]{84, 102};
        ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)pdfStream.write((PdfObject)font).writeSpace()).writeFloat(fontSize)).writeSpace()).writeBytes(Tf);
        if (textColor != null) {
            if (textColor instanceof DeviceGray) {
                ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)pdfStream.writeSpace()).writeFloats(textColor.getColorValue())).writeSpace()).writeBytes(g);
            } else if (textColor instanceof DeviceRgb) {
                ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)pdfStream.writeSpace()).writeFloats(textColor.getColorValue())).writeSpace()).writeBytes(rg);
            } else if (textColor instanceof DeviceCmyk) {
                ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)pdfStream.writeSpace()).writeFloats(textColor.getColorValue())).writeSpace()).writeBytes(k);
            } else {
                Logger logger = LoggerFactory.getLogger(PdfFormField.class);
                logger.error("Unsupported color in FormField's DA");
            }
        }
        return new PdfString(output.toByteArray());
    }

    private static boolean isWidgetAnnotation(PdfDictionary pdfObject) {
        return pdfObject != null && PdfName.Widget.equals((Object)pdfObject.getAsName(PdfName.Subtype));
    }

    private static void createPushButtonAppearanceState(PdfDictionary widget) {
        PdfDictionary appearances = widget.getAsDictionary(PdfName.AP);
        PdfStream normalAppearanceStream = appearances.getAsStream(PdfName.N);
        if (normalAppearanceStream != null) {
            PdfName stateName = widget.getAsName(PdfName.AS);
            if (stateName == null) {
                stateName = new PdfName("push");
            }
            widget.put(PdfName.AS, (PdfObject)stateName);
            PdfDictionary normalAppearance = new PdfDictionary();
            normalAppearance.put(stateName, (PdfObject)normalAppearanceStream);
            appearances.put(PdfName.N, (PdfObject)normalAppearance);
        }
    }

    private static Paragraph createParagraphForTextFieldValue(String value) {
        Text text = new Text(value);
        text.setNextRenderer((IRenderer)new FormFieldValueNonTrimmingTextRenderer(text));
        return new Paragraph(text);
    }
}

