/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.numbering;

public class RomanNumbering {
    private static final RomanDigit[] ROMAN_DIGITS = new RomanDigit[]{new RomanDigit('m', 1000, false), new RomanDigit('d', 500, false), new RomanDigit('c', 100, true), new RomanDigit('l', 50, false), new RomanDigit('x', 10, true), new RomanDigit('v', 5, false), new RomanDigit('i', 1, true)};

    public static String toRomanLowerCase(int number) {
        return RomanNumbering.convert(number);
    }

    public static String toRomanUpperCase(int number) {
        return RomanNumbering.convert(number).toUpperCase();
    }

    public static String toRoman(int number, boolean upperCase) {
        return upperCase ? RomanNumbering.toRomanUpperCase(number) : RomanNumbering.toRomanLowerCase(number);
    }

    protected static String convert(int index) {
        StringBuilder buf = new StringBuilder();
        if (index < 0) {
            buf.append('-');
            index = -index;
        }
        if (index >= 4000) {
            buf.append('|');
            buf.append(RomanNumbering.convert(index / 1000));
            buf.append('|');
            index -= index / 1000 * 1000;
        }
        int pos = 0;
        while (true) {
            RomanDigit dig = ROMAN_DIGITS[pos];
            while (index >= dig.value) {
                buf.append(dig.digit);
                index -= dig.value;
            }
            if (index <= 0) break;
            int j = pos;
            while (!RomanNumbering.ROMAN_DIGITS[++j].pre) {
            }
            if (index + RomanNumbering.ROMAN_DIGITS[j].value >= dig.value) {
                buf.append(RomanNumbering.ROMAN_DIGITS[j].digit).append(dig.digit);
                index -= dig.value - RomanNumbering.ROMAN_DIGITS[j].value;
            }
            ++pos;
        }
        return buf.toString();
    }

    private static class RomanDigit {
        public char digit;
        public int value;
        public boolean pre;

        RomanDigit(char digit, int value, boolean pre) {
            this.digit = digit;
            this.value = value;
            this.pre = pre;
        }
    }
}

