/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.kernel.font.PdfFont;

public final class TextPreprocessingUtil {
    static final int NON_MONO_SPACE_ENSP_WIDTH = 500;
    static final int NON_MONO_SPACE_THINSP_WIDTH = 200;
    static final int AMOUNT_OF_SPACE_IN_TAB = 3;

    private TextPreprocessingUtil() {
    }

    public static GlyphLine replaceSpecialWhitespaceGlyphs(GlyphLine line, PdfFont font) {
        if (null != line) {
            boolean isMonospaceFont = font.getFontProgram().getFontMetrics().isFixedPitch();
            Glyph space = font.getGlyph(32);
            int spaceWidth = space.getWidth();
            int lineSize = line.size();
            for (int i = 0; i < lineSize; ++i) {
                boolean isSpecialWhitespaceGlyph;
                Glyph glyph = line.get(i);
                Integer xAdvance = TextPreprocessingUtil.calculateXAdvancement(spaceWidth, isMonospaceFont, glyph);
                boolean bl = isSpecialWhitespaceGlyph = xAdvance != null;
                if (!isSpecialWhitespaceGlyph) continue;
                Glyph newGlyph = new Glyph(space, glyph.getUnicode());
                assert (xAdvance <= Short.MAX_VALUE && xAdvance >= Short.MIN_VALUE);
                newGlyph.setXAdvance((short)xAdvance.intValue());
                line.set(i, newGlyph);
            }
        }
        return line;
    }

    private static Integer calculateXAdvancement(int spaceWidth, boolean isMonospaceFont, Glyph glyph) {
        Integer xAdvance = null;
        if (glyph.getCode() <= 0) {
            switch (glyph.getUnicode()) {
                case 8194: {
                    xAdvance = isMonospaceFont ? 0 : 500 - spaceWidth;
                    break;
                }
                case 8195: {
                    xAdvance = isMonospaceFont ? 0 : 1000 - spaceWidth;
                    break;
                }
                case 8201: {
                    xAdvance = isMonospaceFont ? 0 : 200 - spaceWidth;
                    break;
                }
                case 9: {
                    xAdvance = 3 * spaceWidth;
                    break;
                }
                default: {
                    return xAdvance;
                }
            }
        }
        return xAdvance;
    }
}

