/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.properties;

import com.itextpdf.layout.properties.UnitValue;
import java.util.Objects;

public class BackgroundPosition {
    private static final double EPS = (double)1.0E-4f;
    private static final int FULL_VALUE = 100;
    private static final int HALF_VALUE = 50;
    private PositionX positionX;
    private PositionY positionY;
    private UnitValue xShift = new UnitValue(1, 0.0f);
    private UnitValue yShift = new UnitValue(1, 0.0f);

    public BackgroundPosition() {
        this.positionX = PositionX.LEFT;
        this.positionY = PositionY.TOP;
    }

    public void calculatePositionValues(float fullWidth, float fullHeight, UnitValue outXValue, UnitValue outYValue) {
        int posMultiplier = this.parsePositionXToUnitValueAndReturnMultiplier(outXValue);
        if (posMultiplier == 0 && this.xShift != null && (double)Math.abs(this.xShift.getValue()) > (double)1.0E-4f) {
            outXValue.setValue(0.0f);
        } else {
            outXValue.setValue(BackgroundPosition.calculateValue(outXValue, fullWidth) + BackgroundPosition.calculateValue(this.xShift, fullWidth) * (float)posMultiplier);
        }
        outXValue.setUnitType(1);
        posMultiplier = this.parsePositionYToUnitValueAndReturnMultiplier(outYValue);
        if (posMultiplier == 0 && this.yShift != null && (double)Math.abs(this.yShift.getValue()) > (double)1.0E-4f) {
            outYValue.setValue(0.0f);
        } else {
            outYValue.setValue(BackgroundPosition.calculateValue(outYValue, fullHeight) + BackgroundPosition.calculateValue(this.yShift, fullHeight) * (float)posMultiplier);
        }
        outYValue.setUnitType(1);
    }

    public PositionX getPositionX() {
        return this.positionX;
    }

    public BackgroundPosition setPositionX(PositionX xPosition) {
        this.positionX = xPosition;
        return this;
    }

    public PositionY getPositionY() {
        return this.positionY;
    }

    public BackgroundPosition setPositionY(PositionY yPosition) {
        this.positionY = yPosition;
        return this;
    }

    public UnitValue getXShift() {
        return this.xShift;
    }

    public BackgroundPosition setXShift(UnitValue xShift) {
        this.xShift = xShift;
        return this;
    }

    public UnitValue getYShift() {
        return this.yShift;
    }

    public BackgroundPosition setYShift(UnitValue yShift) {
        this.yShift = yShift;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackgroundPosition position = (BackgroundPosition)o;
        return Objects.equals((Object)this.positionX, (Object)position.positionX) && Objects.equals((Object)this.positionY, (Object)position.positionY) && Objects.equals(this.xShift, position.xShift) && Objects.equals(this.yShift, position.yShift);
    }

    public int hashCode() {
        return Objects.hash(this.positionX.ordinal(), this.positionY.ordinal(), this.xShift, this.yShift);
    }

    private int parsePositionXToUnitValueAndReturnMultiplier(UnitValue outValue) {
        outValue.setUnitType(2);
        switch (this.positionX) {
            case LEFT: {
                outValue.setValue(0.0f);
                return 1;
            }
            case RIGHT: {
                outValue.setValue(100.0f);
                return -1;
            }
            case CENTER: {
                outValue.setValue(50.0f);
                return 0;
            }
        }
        return 0;
    }

    private int parsePositionYToUnitValueAndReturnMultiplier(UnitValue outValue) {
        outValue.setUnitType(2);
        switch (this.positionY) {
            case TOP: {
                outValue.setValue(0.0f);
                return 1;
            }
            case BOTTOM: {
                outValue.setValue(100.0f);
                return -1;
            }
            case CENTER: {
                outValue.setValue(50.0f);
                return 0;
            }
        }
        return 0;
    }

    private static float calculateValue(UnitValue value, float fullValue) {
        if (value == null) {
            return 0.0f;
        }
        return value.isPercentValue() ? value.getValue() / 100.0f * fullValue : value.getValue();
    }

    public static enum PositionY {
        TOP,
        BOTTOM,
        CENTER;

    }

    public static enum PositionX {
        LEFT,
        RIGHT,
        CENTER;

    }
}

