/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.layout.properties.grid.GridFlow;
import com.itextpdf.layout.renderer.Grid;
import com.itextpdf.layout.renderer.GridCell;

class GridView {
    private final Grid grid;
    private final Grid.GridOrder iterationOrder;
    private final Cursor cursor;
    private boolean restrictYGrow = false;
    private boolean restrictXGrow = false;
    private boolean hasNext = true;
    private int rightMargin;
    private int bottomMargin;

    GridView(Grid grid, GridFlow iterationOrder) {
        this.iterationOrder = GridFlow.COLUMN.equals((Object)iterationOrder) || GridFlow.COLUMN_DENSE.equals((Object)iterationOrder) ? Grid.GridOrder.COLUMN : Grid.GridOrder.ROW;
        this.cursor = new Cursor(GridFlow.ROW_DENSE.equals((Object)iterationOrder) || GridFlow.COLUMN_DENSE.equals((Object)iterationOrder));
        this.grid = grid;
    }

    public boolean hasNext() {
        return this.cursor.y < this.grid.getRows().length - this.bottomMargin && this.cursor.x < this.grid.getRows()[0].length - this.rightMargin && this.hasNext;
    }

    public Pos next() {
        if (this.isFixed()) {
            this.hasNext = false;
        } else {
            if (this.restrictXGrow) {
                ++this.cursor.y;
                return new Pos(this.cursor);
            }
            if (this.restrictYGrow) {
                ++this.cursor.x;
                return new Pos(this.cursor);
            }
        }
        Pos boundaries = new Pos(this.grid.getRows().length - this.bottomMargin, this.grid.getRows()[0].length - this.rightMargin);
        this.cursor.increment(this.iterationOrder, boundaries);
        return new Pos(this.cursor);
    }

    Pos reset(int y, int x, int rightMargin, int bottomMargin) {
        this.cursor.setY(y);
        this.cursor.setX(x);
        if (x == -1 && y == -1) {
            if (rightMargin > this.grid.getNumberOfColumns() - this.cursor.x + (Grid.GridOrder.COLUMN.equals((Object)this.iterationOrder) ? 1 : 0)) {
                this.cursor.setX(0);
            }
            if (bottomMargin > this.grid.getNumberOfRows() - this.cursor.y + (Grid.GridOrder.ROW.equals((Object)this.iterationOrder) ? 1 : 0)) {
                this.cursor.setY(0);
            }
        }
        this.rightMargin = rightMargin - 1;
        this.bottomMargin = bottomMargin - 1;
        this.restrictXGrow = x != -1;
        this.restrictYGrow = y != -1;
        this.hasNext = true;
        return new Pos(this.cursor);
    }

    boolean fit(int width, int height) {
        GridCell[][] rows = this.grid.getRows();
        for (int i = this.cursor.x; i < this.cursor.x + width; ++i) {
            for (int j = this.cursor.y; j < this.cursor.y + height; ++j) {
                if (rows[j][i] == null) continue;
                return false;
            }
        }
        this.increaseDefaultCursor(new Pos(height, width));
        this.resetCursorIfIntersectingCellIsPlaced();
        return true;
    }

    void resetCursorIfIntersectingCellIsPlaced() {
        if (Grid.GridOrder.ROW.equals((Object)this.iterationOrder) && this.restrictYGrow || Grid.GridOrder.COLUMN.equals((Object)this.iterationOrder) && this.restrictXGrow) {
            this.cursor.reset();
        }
    }

    void increaseDefaultCursor(Pos cellSizes) {
        if (Grid.GridOrder.ROW.equals((Object)this.iterationOrder)) {
            this.cursor.x += cellSizes.x - 1;
        } else if (Grid.GridOrder.COLUMN.equals((Object)this.iterationOrder)) {
            this.cursor.y += cellSizes.y - 1;
        }
    }

    void increaseDefaultAxis() {
        if (this.restrictYGrow) {
            this.grid.resize(-1, this.grid.getRows()[0].length + 1);
        } else if (this.restrictXGrow) {
            this.grid.resize(this.grid.getRows().length + 1, -1);
        } else if (Grid.GridOrder.ROW.equals((Object)this.iterationOrder)) {
            this.grid.resize(this.grid.getRows().length + 1, -1);
        } else if (Grid.GridOrder.COLUMN.equals((Object)this.iterationOrder)) {
            this.grid.resize(-1, this.grid.getRows()[0].length + 1);
        }
        this.hasNext = true;
    }

    boolean isFixed() {
        return this.restrictXGrow && this.restrictYGrow;
    }

    static class Cursor
    extends Pos {
        private final boolean densePacking;

        public Cursor(boolean densePacking) {
            super(0, 0);
            this.densePacking = densePacking;
        }

        public void setX(int x) {
            if (this.densePacking) {
                this.x = Math.max(x, 0);
            } else if (this.x > x && x != -1) {
                this.x = x;
                ++this.y;
            } else {
                this.x = Math.max(x, this.x);
            }
        }

        public void setY(int y) {
            if (this.densePacking) {
                this.y = Math.max(y, 0);
            } else if (this.y > y && y != -1) {
                this.y = y;
                ++this.x;
            } else {
                this.y = Math.max(y, this.y);
            }
        }

        public void increment(Grid.GridOrder flow, Pos boundaries) {
            if (Grid.GridOrder.ROW.equals((Object)flow)) {
                ++this.x;
                if (this.x == boundaries.x) {
                    this.x = 0;
                    ++this.y;
                }
            } else if (Grid.GridOrder.COLUMN.equals((Object)flow)) {
                ++this.y;
                if (this.y == boundaries.y) {
                    this.y = 0;
                    ++this.x;
                }
            }
        }

        public void reset() {
            this.x = 0;
            this.y = 0;
        }
    }

    static class Pos {
        protected int x;
        protected int y;

        public Pos(int y, int x) {
            this.y = y;
            this.x = x;
        }

        public Pos(Pos other) {
            this.y = other.y;
            this.x = other.x;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

