/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.renderer.CellRenderer;
import com.itextpdf.layout.renderer.TableBorderDescriptor;
import com.itextpdf.layout.renderer.TableBorders;
import com.itextpdf.layout.renderer.TableRenderer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SeparatedTableBorders
extends TableBorders {
    public SeparatedTableBorders(List<CellRenderer[]> rows, int numberOfColumns, Border[] tableBoundingBorders) {
        super(rows, numberOfColumns, tableBoundingBorders);
    }

    public SeparatedTableBorders(List<CellRenderer[]> rows, int numberOfColumns, Border[] tableBoundingBorders, int largeTableIndexOffset) {
        super(rows, numberOfColumns, tableBoundingBorders, largeTableIndexOffset);
    }

    @Override
    protected TableBorders drawHorizontalBorder(PdfCanvas canvas, TableBorderDescriptor borderDescriptor) {
        return this;
    }

    @Override
    protected TableBorders drawVerticalBorder(PdfCanvas canvas, TableBorderDescriptor borderDescriptor) {
        return this;
    }

    @Override
    protected TableBorders applyTopTableBorder(Rectangle occupiedBox, Rectangle layoutBox, boolean isEmpty, boolean force, boolean reverse) {
        return this.applyTopTableBorder(occupiedBox, layoutBox, reverse);
    }

    @Override
    protected TableBorders applyTopTableBorder(Rectangle occupiedBox, Rectangle layoutBox, boolean reverse) {
        float topIndent = (float)(reverse ? -1 : 1) * this.getMaxTopWidth();
        layoutBox.decreaseHeight(topIndent);
        occupiedBox.moveDown(topIndent).increaseHeight(topIndent);
        return this;
    }

    @Override
    protected TableBorders applyBottomTableBorder(Rectangle occupiedBox, Rectangle layoutBox, boolean isEmpty, boolean force, boolean reverse) {
        return this.applyBottomTableBorder(occupiedBox, layoutBox, reverse);
    }

    @Override
    protected TableBorders applyBottomTableBorder(Rectangle occupiedBox, Rectangle layoutBox, boolean reverse) {
        float bottomTableBorderWidth = (float)(reverse ? -1 : 1) * this.getMaxBottomWidth();
        layoutBox.decreaseHeight(bottomTableBorderWidth);
        occupiedBox.moveDown(bottomTableBorderWidth).increaseHeight(bottomTableBorderWidth);
        return this;
    }

    @Override
    protected TableBorders applyLeftAndRightTableBorder(Rectangle layoutBox, boolean reverse) {
        if (null != layoutBox) {
            layoutBox.applyMargins(0.0f, this.rightBorderMaxWidth, 0.0f, this.leftBorderMaxWidth, reverse);
        }
        return this;
    }

    @Override
    protected TableBorders skipFooter(Border[] borders) {
        this.setTableBoundingBorders(borders);
        return this;
    }

    @Override
    protected TableBorders skipHeader(Border[] borders) {
        return this;
    }

    @Override
    protected TableBorders collapseTableWithFooter(TableBorders footerBordersHandler, boolean hasContent) {
        return this;
    }

    @Override
    protected TableBorders collapseTableWithHeader(TableBorders headerBordersHandler, boolean updateBordersHandler) {
        return this;
    }

    @Override
    protected TableBorders fixHeaderOccupiedArea(Rectangle occupiedBox, Rectangle layoutBox) {
        return this;
    }

    @Override
    protected TableBorders applyCellIndents(Rectangle box, float topIndent, float rightIndent, float bottomIndent, float leftIndent, boolean reverse) {
        box.applyMargins(topIndent, rightIndent, bottomIndent, leftIndent, false);
        return this;
    }

    @Override
    public List<Border> getVerticalBorder(int index) {
        return (List)this.verticalBorders.get(index);
    }

    @Override
    public List<Border> getHorizontalBorder(int index) {
        return (List)this.horizontalBorders.get(index - this.largeTableIndexOffset);
    }

    @Override
    protected float getCellVerticalAddition(float[] indents) {
        return 0.0f;
    }

    @Override
    protected TableBorders updateBordersOnNewPage(boolean isOriginalNonSplitRenderer, boolean isFooterOrHeader, TableRenderer currentRenderer, TableRenderer headerRenderer, TableRenderer footerRenderer) {
        if (!isFooterOrHeader && isOriginalNonSplitRenderer && null != this.rows) {
            this.processAllBordersAndEmptyRows();
            this.rightBorderMaxWidth = this.getMaxRightWidth();
            this.leftBorderMaxWidth = this.getMaxLeftWidth();
        }
        if (null != footerRenderer) {
            float rightFooterBorderWidth = footerRenderer.bordersHandler.getMaxRightWidth();
            float leftFooterBorderWidth = footerRenderer.bordersHandler.getMaxLeftWidth();
            this.leftBorderMaxWidth = Math.max(this.leftBorderMaxWidth, leftFooterBorderWidth);
            this.rightBorderMaxWidth = Math.max(this.rightBorderMaxWidth, rightFooterBorderWidth);
        }
        if (null != headerRenderer) {
            float rightHeaderBorderWidth = headerRenderer.bordersHandler.getMaxRightWidth();
            float leftHeaderBorderWidth = headerRenderer.bordersHandler.getMaxLeftWidth();
            this.leftBorderMaxWidth = Math.max(this.leftBorderMaxWidth, leftHeaderBorderWidth);
            this.rightBorderMaxWidth = Math.max(this.rightBorderMaxWidth, rightHeaderBorderWidth);
        }
        return this;
    }

    @Override
    public float[] getCellBorderIndents(int row, int col, int rowspan, int colspan) {
        return new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    }

    @Override
    protected void buildBordersArrays(CellRenderer cell, int row, int col) {
        int i;
        int colspan = cell.getPropertyAsInteger(16);
        int rowspan = cell.getPropertyAsInteger(60);
        int colN = ((Cell)cell.getModelElement()).getCol();
        Border[] cellBorders = cell.getBorders();
        if (row + 1 - rowspan < 0) {
            rowspan = row + 1;
        }
        for (i = 0; i < colspan; ++i) {
            this.checkAndReplaceBorderInArray(this.horizontalBorders, 2 * (row + 1 - rowspan), colN + i, cellBorders[0], false);
        }
        for (i = 0; i < colspan; ++i) {
            this.checkAndReplaceBorderInArray(this.horizontalBorders, 2 * row + 1, colN + i, cellBorders[2], true);
        }
        for (int j = row - rowspan + 1; j <= row; ++j) {
            this.checkAndReplaceBorderInArray(this.verticalBorders, 2 * colN, j, cellBorders[3], false);
        }
        for (i = row - rowspan + 1; i <= row; ++i) {
            this.checkAndReplaceBorderInArray(this.verticalBorders, 2 * (colN + colspan) - 1, i, cellBorders[1], true);
        }
    }

    protected boolean checkAndReplaceBorderInArray(List<List<Border>> borderArray, int i, int j, Border borderToAdd, boolean hasPriority) {
        List<Border> borders = borderArray.get(i);
        Border neighbour = borders.get(j);
        if (neighbour == null) {
            borders.set(j, borderToAdd);
        } else {
            Logger logger = LoggerFactory.getLogger(TableRenderer.class);
            logger.warn("Unexpected behaviour during table row collapsing. Calculated rowspan was less then 1.");
        }
        return true;
    }

    @Override
    protected TableBorders initializeBorders() {
        ArrayList tempBorders;
        while (2 * Math.max(this.numberOfColumns, 1) > this.verticalBorders.size()) {
            tempBorders = new ArrayList();
            while (2 * Math.max(this.rows.size(), 1) > tempBorders.size()) {
                tempBorders.add(null);
            }
            this.verticalBorders.add(tempBorders);
        }
        while (2 * Math.max(this.rows.size(), 1) > this.horizontalBorders.size()) {
            tempBorders = new ArrayList();
            while (this.numberOfColumns > tempBorders.size()) {
                tempBorders.add(null);
            }
            this.horizontalBorders.add(tempBorders);
        }
        return this;
    }

    @Override
    public List<Border> getFirstHorizontalBorder() {
        return this.getHorizontalBorder(2 * this.startRow);
    }

    @Override
    public List<Border> getLastHorizontalBorder() {
        return this.getHorizontalBorder(2 * this.finishRow + 1);
    }

    @Override
    public float getMaxTopWidth() {
        return null == this.tableBoundingBorders[0] ? 0.0f : this.tableBoundingBorders[0].getWidth();
    }

    @Override
    public float getMaxBottomWidth() {
        return null == this.tableBoundingBorders[2] ? 0.0f : this.tableBoundingBorders[2].getWidth();
    }

    @Override
    public float getMaxRightWidth() {
        return null == this.tableBoundingBorders[1] ? 0.0f : this.tableBoundingBorders[1].getWidth();
    }

    @Override
    public float getMaxLeftWidth() {
        return null == this.tableBoundingBorders[3] ? 0.0f : this.tableBoundingBorders[3].getWidth();
    }
}

