/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.report.xml;

import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.io.util.EnumUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SignatureValidationStatus {
    private static final Map<MainIndication, String> MAIN_INDICATION_VALUE_MAP = new HashMap<MainIndication, String>(EnumUtil.getAllValuesOfEnum(MainIndication.class).size());
    private static final Map<MessageType, String> MESSAGE_TYPE_VALUE_MAP = new HashMap<MessageType, String>(EnumUtil.getAllValuesOfEnum(MessageType.class).size());
    private final List<Tuple2<String, String>> messages = new ArrayList<Tuple2<String, String>>();
    private MainIndication mainIndication;
    private SubIndication subIndication;
    private boolean subIndicationSet = false;

    public void setMainIndication(MainIndication mainIndication) {
        this.mainIndication = mainIndication;
    }

    public MainIndication getMainIndication() {
        return this.mainIndication;
    }

    public String getMainIndicationAsString() {
        return MAIN_INDICATION_VALUE_MAP.get((Object)this.mainIndication);
    }

    public void setSubIndication(SubIndication subIndication) {
        this.subIndication = subIndication;
        this.subIndicationSet = true;
    }

    public SubIndication getSubIndication() {
        return this.subIndication;
    }

    public String getSubIndicationAsString() {
        if (!this.subIndicationSet) {
            return null;
        }
        return this.subIndication.toString();
    }

    public void addMessage(String reason, MessageType messageType) {
        this.messages.add((Tuple2<String, String>)new Tuple2((Object)reason, (Object)MESSAGE_TYPE_VALUE_MAP.get((Object)messageType)));
    }

    public Collection<Tuple2<String, String>> getMessages() {
        return this.messages;
    }

    static {
        MAIN_INDICATION_VALUE_MAP.put(MainIndication.TOTAL_PASSED, "urn:etsi:019102:mainindication:total-passed");
        MAIN_INDICATION_VALUE_MAP.put(MainIndication.TOTAL_FAILED, "urn:etsi:019102:mainindication:total-failed ");
        MAIN_INDICATION_VALUE_MAP.put(MainIndication.INDETERMINATE, "urn:etsi:019102:mainindication:indeterminate");
        MAIN_INDICATION_VALUE_MAP.put(MainIndication.PASSED, "urn:etsi:019102:mainindication:passed");
        MAIN_INDICATION_VALUE_MAP.put(MainIndication.FAILED, "urn:etsi:019102:mainindication:failed ");
        MESSAGE_TYPE_VALUE_MAP.put(MessageType.INFO, "urn:cef:dss:message:info");
        MESSAGE_TYPE_VALUE_MAP.put(MessageType.WARN, "urn:cef:dss:message:warn");
        MESSAGE_TYPE_VALUE_MAP.put(MessageType.ERROR, "urn:cef:dss:message:error");
    }

    public static enum MessageType {
        INFO,
        WARN,
        ERROR;

    }

    public static enum SubIndication {
        FORMAT_FAILURE,
        HASH_FAILURE,
        SIG_CRYPTO_FAILURE,
        REVOKED,
        EXPIRED,
        NOT_YET_VALID,
        SIG_CONSTRAINTS_FAILURE,
        CHAIN_CONSTRAINTS_FAILURE,
        CERTIFICATE_CHAIN_GENERAL_FAILURE,
        CRYPTO_CONSTRAINTS_FAILURE,
        POLICY_PROCESSING_ERROR,
        SIGNATURE_POLICY_NOT_AVAILABLE,
        TIMESTAMP_ORDER_FAILURE,
        NO_SIGNING_CERTIFICATE_FOUND,
        NO_CERTIFICATE_CHAIN_FOUND,
        REVOKED_NO_POE,
        REVOKED_CA_NO_POE,
        OUT_OF_BOUNDS_NOT_REVOKED,
        OUT_OF_BOUNDS_NO_POE,
        CRYPTO_CONSTRAINTS_FAILURE_NO_POE,
        NO_POE,
        TRY_LATER,
        SIGNED_DATA_NOT_FOUND;

    }

    public static enum MainIndication {
        TOTAL_PASSED,
        TOTAL_FAILED,
        INDETERMINATE,
        PASSED,
        FAILED;

    }
}

