/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.jsoup.select;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.styledxmlparser.jsoup.nodes.Element;
import com.itextpdf.styledxmlparser.jsoup.select.Evaluator;

abstract class StructuralEvaluator
extends Evaluator {
    Evaluator evaluator;

    StructuralEvaluator() {
    }

    static class ImmediatePreviousSibling
    extends StructuralEvaluator {
        public ImmediatePreviousSibling(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(Element root, Element element) {
            if (root == element) {
                return false;
            }
            Element prev = element.previousElementSibling();
            return prev != null && this.evaluator.matches(root, prev);
        }

        public String toString() {
            return MessageFormatUtil.format((String)":prev{0}", (Object[])new Object[]{this.evaluator});
        }
    }

    static class PreviousSibling
    extends StructuralEvaluator {
        public PreviousSibling(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(Element root, Element element) {
            if (root == element) {
                return false;
            }
            for (Element prev = element.previousElementSibling(); prev != null; prev = prev.previousElementSibling()) {
                if (!this.evaluator.matches(root, prev)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return MessageFormatUtil.format((String)":prev*{0}", (Object[])new Object[]{this.evaluator});
        }
    }

    static class ImmediateParent
    extends StructuralEvaluator {
        public ImmediateParent(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(Element root, Element element) {
            if (root == element) {
                return false;
            }
            Element parent = (Element)element.parent();
            return parent != null && this.evaluator.matches(root, parent);
        }

        public String toString() {
            return MessageFormatUtil.format((String)":ImmediateParent{0}", (Object[])new Object[]{this.evaluator});
        }
    }

    static class Parent
    extends StructuralEvaluator {
        public Parent(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(Element root, Element element) {
            if (root == element) {
                return false;
            }
            Element parent = (Element)element.parent();
            while (true) {
                if (this.evaluator.matches(root, parent)) {
                    return true;
                }
                if (parent == root) break;
                parent = (Element)parent.parent();
            }
            return false;
        }

        public String toString() {
            return MessageFormatUtil.format((String)":parent{0}", (Object[])new Object[]{this.evaluator});
        }
    }

    static class Not
    extends StructuralEvaluator {
        public Not(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(Element root, Element node) {
            return !this.evaluator.matches(root, node);
        }

        public String toString() {
            return MessageFormatUtil.format((String)":not{0}", (Object[])new Object[]{this.evaluator});
        }
    }

    static class Has
    extends StructuralEvaluator {
        public Has(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(Element root, Element element) {
            for (Element e : element.getAllElements()) {
                if (e == element || !this.evaluator.matches(root, e)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return MessageFormatUtil.format((String)":has({0})", (Object[])new Object[]{this.evaluator});
        }
    }

    static class Root
    extends Evaluator {
        Root() {
        }

        @Override
        public boolean matches(Element root, Element element) {
            return root == element;
        }
    }
}

