/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css;

import com.itextpdf.styledxmlparser.css.CssFontFaceRule;
import com.itextpdf.styledxmlparser.css.CssImportAtRule;
import com.itextpdf.styledxmlparser.css.CssNestedAtRule;
import com.itextpdf.styledxmlparser.css.CssSemicolonAtRule;
import com.itextpdf.styledxmlparser.css.media.CssMediaRule;
import com.itextpdf.styledxmlparser.css.page.CssMarginRule;
import com.itextpdf.styledxmlparser.css.page.CssPageRule;

public final class CssAtRuleFactory {
    private CssAtRuleFactory() {
    }

    public static CssSemicolonAtRule createSemicolonAtRule(String ruleDeclaration) {
        ruleDeclaration = ruleDeclaration.trim();
        String ruleName = CssAtRuleFactory.extractRuleNameFromDeclaration(ruleDeclaration);
        String ruleParameters = ruleDeclaration.substring(ruleName.length()).trim();
        if ("import".equals(ruleName)) {
            return new CssImportAtRule(ruleParameters);
        }
        return new CssSemicolonAtRule(ruleName, ruleParameters);
    }

    public static CssNestedAtRule createNestedRule(String ruleDeclaration) {
        ruleDeclaration = ruleDeclaration.trim();
        String ruleName = CssAtRuleFactory.extractRuleNameFromDeclaration(ruleDeclaration);
        String ruleParameters = ruleDeclaration.substring(ruleName.length()).trim();
        switch (ruleName) {
            case "media": {
                return new CssMediaRule(ruleParameters);
            }
            case "page": {
                return new CssPageRule(ruleParameters);
            }
            case "top-left-corner": 
            case "top-left": 
            case "top-center": 
            case "top-right": 
            case "top-right-corner": 
            case "left-top": 
            case "left-middle": 
            case "left-bottom": 
            case "right-top": 
            case "right-middle": 
            case "right-bottom": 
            case "bottom-left-corner": 
            case "bottom-left": 
            case "bottom-center": 
            case "bottom-right": 
            case "bottom-right-corner": {
                return new CssMarginRule(ruleName);
            }
            case "font-face": {
                return new CssFontFaceRule();
            }
        }
        return new CssNestedAtRule(ruleName, ruleParameters);
    }

    static String extractRuleNameFromDeclaration(String ruleDeclaration) {
        int spaceIndex = ruleDeclaration.indexOf(32);
        int colonIndex = ruleDeclaration.indexOf(58);
        int separatorIndex = spaceIndex == -1 ? colonIndex : (colonIndex == -1 ? spaceIndex : Math.min(spaceIndex, colonIndex));
        return separatorIndex == -1 ? ruleDeclaration : ruleDeclaration.substring(0, separatorIndex);
    }
}

