/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.MarkerVertexType;
import com.itextpdf.svg.renderers.IMarkerCapable;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractBranchSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;
import com.itextpdf.svg.utils.SvgTextUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerSvgNodeRenderer
extends AbstractBranchSvgNodeRenderer {
    public static final String MARKER_INDEX = "marker-index";
    private static final float DEFAULT_MARKER_WIDTH = 2.25f;
    private static final float DEFAULT_MARKER_HEIGHT = 2.25f;
    private static final float DEFAULT_REF_X = 0.0f;
    private static final float DEFAULT_REF_Y = 0.0f;

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        MarkerSvgNodeRenderer copy = new MarkerSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        this.deepCopyChildren(copy);
        return copy;
    }

    @Override
    public Rectangle getObjectBoundingBox(SvgDrawContext context) {
        return null;
    }

    @Override
    protected boolean isHidden() {
        return "hidden".equals(this.attributesAndStyles.get("visibility"));
    }

    @Override
    void preDraw(SvgDrawContext context) {
        super.preDraw(context);
        float[] markerWidthHeight = this.getMarkerWidthHeightValues();
        float markerWidth = markerWidthHeight[0];
        float markerHeight = markerWidthHeight[1];
        String xAttribute = this.getAttribute("x");
        String yAttribute = this.getAttribute("y");
        float x = xAttribute == null ? 0.0f : CssDimensionParsingUtils.parseAbsoluteLength((String)xAttribute);
        float y = yAttribute == null ? 0.0f : CssDimensionParsingUtils.parseAbsoluteLength((String)yAttribute);
        Rectangle markerViewport = new Rectangle(x, y, markerWidth, markerHeight);
        context.addViewPort(markerViewport);
    }

    void applyMarkerAttributes(SvgDrawContext context) {
        this.applyRotation(context);
        this.applyUserSpaceScaling(context);
        this.applyCoordinatesTranslation(context);
    }

    static void drawMarker(SvgDrawContext context, String moveX, String moveY, MarkerVertexType markerToUse, AbstractSvgNodeRenderer parent) {
        ISvgNodeRenderer namedObject;
        String elementToReUse = parent.attributesAndStyles.get(markerToUse.toString());
        String normalizedName = SvgTextUtil.filterReferenceValue(elementToReUse);
        ISvgNodeRenderer template = context.getNamedObject(normalizedName);
        ISvgNodeRenderer iSvgNodeRenderer = namedObject = template == null ? null : template.createDeepCopy();
        if (namedObject instanceof MarkerSvgNodeRenderer && MarkerSvgNodeRenderer.markerWidthHeightAreCorrect((MarkerSvgNodeRenderer)namedObject)) {
            namedObject.setParent(parent);
            namedObject.setAttribute("marker", markerToUse.toString());
            namedObject.setAttribute("x", moveX);
            namedObject.setAttribute("y", moveY);
            context.getCurrentCanvas().saveState();
            namedObject.draw(context);
            context.getCurrentCanvas().restoreState();
            namedObject.setParent(null);
        }
    }

    static void drawMarkers(SvgDrawContext context, int startIndex, List<Point> markerPoints, MarkerVertexType markerToUse, AbstractSvgNodeRenderer parent) {
        String elementToReUse = SvgTextUtil.filterReferenceValue(parent.attributesAndStyles.get(markerToUse.toString()));
        ISvgNodeRenderer template = context.getNamedObject(elementToReUse);
        if (!(template instanceof MarkerSvgNodeRenderer) || !MarkerSvgNodeRenderer.markerWidthHeightAreCorrect((MarkerSvgNodeRenderer)template)) {
            return;
        }
        for (int i = 0; i < markerPoints.size(); ++i) {
            ISvgNodeRenderer marker = template.createDeepCopy();
            marker.setParent(parent);
            marker.setAttribute("marker", markerToUse.toString());
            marker.setAttribute("x", Double.toString(markerPoints.get(i).getX()));
            marker.setAttribute("y", Double.toString(markerPoints.get(i).getY()));
            marker.setAttribute(MARKER_INDEX, Integer.toString(startIndex + i));
            context.getCurrentCanvas().saveState();
            marker.draw(context);
            context.getCurrentCanvas().restoreState();
        }
    }

    @Override
    protected void applyViewBox(SvgDrawContext context) {
        if (this.attributesAndStyles != null) {
            float[] markerWidthHeight = this.getMarkerWidthHeightValues();
            float markerWidth = markerWidthHeight[0];
            float markerHeight = markerWidthHeight[1];
            float[] values = this.getViewBoxValues(markerWidth, markerHeight);
            Rectangle currentViewPort = context.getCurrentViewPort();
            super.calculateAndApplyViewBox(context, values, currentViewPort);
        }
    }

    private float[] getMarkerWidthHeightValues() {
        String markerWidthRawValue;
        float markerWidth = 2.25f;
        if (this.attributesAndStyles.containsKey("markerWidth")) {
            markerWidthRawValue = (String)this.attributesAndStyles.get("markerWidth");
            markerWidth = CssDimensionParsingUtils.parseAbsoluteLength((String)markerWidthRawValue);
        } else if (this.attributesAndStyles.containsKey(StringNormalizer.toLowerCase((String)"markerWidth"))) {
            markerWidthRawValue = (String)this.attributesAndStyles.get(StringNormalizer.toLowerCase((String)"markerWidth"));
            markerWidth = CssDimensionParsingUtils.parseAbsoluteLength((String)markerWidthRawValue);
        }
        float markerHeight = 2.25f;
        if (this.attributesAndStyles.containsKey("markerHeight")) {
            String markerHeightRawValue = (String)this.attributesAndStyles.get("markerHeight");
            markerHeight = CssDimensionParsingUtils.parseAbsoluteLength((String)markerHeightRawValue);
        } else if (this.attributesAndStyles.containsKey(StringNormalizer.toLowerCase((String)"markerHeight"))) {
            String markerHeightRawValue = (String)this.attributesAndStyles.get(StringNormalizer.toLowerCase((String)"markerHeight"));
            markerHeight = CssDimensionParsingUtils.parseAbsoluteLength((String)markerHeightRawValue);
        }
        return new float[]{markerWidth, markerHeight};
    }

    private static boolean markerWidthHeightAreCorrect(MarkerSvgNodeRenderer namedObject) {
        String markerHeight;
        Logger log = LoggerFactory.getLogger(MarkerSvgNodeRenderer.class);
        String markerWidth = namedObject.getAttribute("markerWidth");
        if (markerWidth == null) {
            markerWidth = namedObject.getAttribute(StringNormalizer.toLowerCase((String)"markerWidth"));
        }
        if ((markerHeight = namedObject.getAttribute("markerHeight")) == null) {
            markerHeight = namedObject.getAttribute(StringNormalizer.toLowerCase((String)"markerHeight"));
        }
        boolean isCorrect = true;
        if (markerWidth != null) {
            float absoluteMarkerWidthValue = CssDimensionParsingUtils.parseAbsoluteLength((String)markerWidth);
            if (absoluteMarkerWidthValue == 0.0f) {
                log.warn("markerWidth has zero value. Marker will not be rendered.");
                isCorrect = false;
            } else if (absoluteMarkerWidthValue < 0.0f) {
                log.warn("markerWidth has negative value. Marker will not be rendered.");
                isCorrect = false;
            }
        }
        if (markerHeight != null) {
            float absoluteMarkerHeightValue = CssDimensionParsingUtils.parseAbsoluteLength((String)markerHeight);
            if (absoluteMarkerHeightValue == 0.0f) {
                log.warn("markerHeight has zero value. Marker will not be rendered.");
                isCorrect = false;
            } else if (absoluteMarkerHeightValue < 0.0f) {
                log.warn("markerHeight has negative value. Marker will not be rendered.");
                isCorrect = false;
            }
        }
        return isCorrect;
    }

    private void applyRotation(SvgDrawContext context) {
        if (this.attributesAndStyles.containsKey("orient")) {
            String orient = (String)this.attributesAndStyles.get("orient");
            double rotAngle = Double.NaN;
            if ("auto".equals(orient) || "auto-start-reverse".equals(orient) && !"marker-start".equals(this.attributesAndStyles.get("marker"))) {
                rotAngle = ((IMarkerCapable)((Object)this.getParent())).getAutoOrientAngle(this, false);
            } else if ("auto-start-reverse".equals(orient) && "marker-start".equals(this.attributesAndStyles.get("marker"))) {
                rotAngle = ((IMarkerCapable)((Object)this.getParent())).getAutoOrientAngle(this, true);
            } else if (CssTypesValidationUtils.isAngleValue((String)orient) || CssTypesValidationUtils.isNumber((String)orient)) {
                rotAngle = CssDimensionParsingUtils.parseAngle((String)((String)this.attributesAndStyles.get("orient")));
            }
            if (!Double.isNaN(rotAngle)) {
                context.getCurrentCanvas().concatMatrix(AffineTransform.getRotateInstance((double)rotAngle));
            }
        }
    }

    private void applyUserSpaceScaling(SvgDrawContext context) {
        String parentValue;
        boolean markerUnitsLowerEqualsStrokeWidth;
        boolean markerUnitsEqualsStrokeWidth = !this.attributesAndStyles.containsKey("markerUnits") || "strokeWidth".equals(this.attributesAndStyles.get("markerUnits"));
        boolean bl = markerUnitsLowerEqualsStrokeWidth = !this.attributesAndStyles.containsKey(StringNormalizer.toLowerCase((String)"markerUnits")) || "strokeWidth".equals(this.attributesAndStyles.get(StringNormalizer.toLowerCase((String)"markerUnits")));
        if (markerUnitsEqualsStrokeWidth && markerUnitsLowerEqualsStrokeWidth && (parentValue = this.getParent().getAttribute("stroke-width")) != null) {
            double rootViewPortHeight = context.getRootViewPort().getHeight();
            double rootViewPortWidth = context.getRootViewPort().getWidth();
            double viewBoxDiagonalLength = CssUtils.convertPxToPts((double)Math.sqrt(rootViewPortHeight * rootViewPortHeight + rootViewPortWidth * rootViewPortWidth));
            float strokeWidthScale = CssUtils.convertPtsToPx((float)SvgCssUtils.parseAbsoluteLength(this, parentValue, (float)viewBoxDiagonalLength, 1.0f, context));
            context.getCurrentCanvas().concatMatrix(AffineTransform.getScaleInstance((double)strokeWidthScale, (double)strokeWidthScale));
        }
    }

    private void applyCoordinatesTranslation(SvgDrawContext context) {
        String refY;
        String refX;
        float xScale = 1.0f;
        float yScale = 1.0f;
        float[] viewBox = SvgCssUtils.parseViewBox(this);
        if (viewBox != null && viewBox.length == 4) {
            xScale = context.getCurrentViewPort().getWidth() / viewBox[2];
            yScale = context.getCurrentViewPort().getHeight() / viewBox[3];
        }
        float moveX = 0.0f;
        if (this.attributesAndStyles.containsKey("refX")) {
            refX = (String)this.attributesAndStyles.get("refX");
            moveX = SvgCssUtils.parseAbsoluteLength(this, refX, context.getRootViewPort().getWidth(), moveX, context);
            moveX *= -1.0f * xScale;
        } else if (this.attributesAndStyles.containsKey(StringNormalizer.toLowerCase((String)"refX"))) {
            refX = (String)this.attributesAndStyles.get(StringNormalizer.toLowerCase((String)"refX"));
            moveX = SvgCssUtils.parseAbsoluteLength(this, refX, context.getRootViewPort().getWidth(), moveX, context);
            moveX *= -1.0f * xScale;
        }
        float moveY = 0.0f;
        if (this.attributesAndStyles.containsKey("refY")) {
            refY = (String)this.attributesAndStyles.get("refY");
            moveY = SvgCssUtils.parseAbsoluteLength(this, refY, context.getRootViewPort().getHeight(), moveY, context);
            moveY *= -1.0f * yScale;
        } else if (this.attributesAndStyles.containsKey(StringNormalizer.toLowerCase((String)"refY"))) {
            refY = (String)this.attributesAndStyles.get(StringNormalizer.toLowerCase((String)"refY"));
            moveY = SvgCssUtils.parseAbsoluteLength(this, refY, context.getRootViewPort().getHeight(), moveY, context);
            moveY *= -1.0f * yScale;
        }
        AffineTransform translation = AffineTransform.getTranslateInstance((double)moveX, (double)moveY);
        if (!translation.isIdentity()) {
            context.getCurrentCanvas().concatMatrix(translation);
        }
    }

    private float[] getViewBoxValues(float defaultWidth, float defaultHeight) {
        float[] values = SvgCssUtils.parseViewBox(this);
        if (values == null || values.length < 4) {
            return new float[]{0.0f, 0.0f, defaultWidth, defaultHeight};
        }
        return values;
    }
}

