/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.utils;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.layout.properties.TransparentColor;
import com.itextpdf.layout.properties.Underline;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.TextDecorationShorthandResolver;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.util.WhiteSpaceUtil;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.ISvgTextNodeRenderer;
import com.itextpdf.svg.renderers.impl.TextLeafSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.TextSvgBranchRenderer;
import java.util.ArrayList;
import java.util.List;

public final class SvgTextUtil {
    private static final float TEXT_DECORATION_LINE_THROUGH_Y_POS = -0.3f;
    private static final float TEXT_DECORATION_LINE_OVER_Y_POS = -0.9f;
    private static final float TEXT_DECORATION_LINE_UNDER_Y_POS = 0.1f;

    private SvgTextUtil() {
    }

    public static String trimLeadingWhitespace(String toTrim) {
        char currentChar;
        int current;
        if (toTrim == null) {
            return "";
        }
        int end = toTrim.length();
        for (current = 0; current < end && Character.isWhitespace(currentChar = toTrim.charAt(current)) && currentChar != '\n' && currentChar != '\r'; ++current) {
        }
        return toTrim.substring(current);
    }

    public static String trimTrailingWhitespace(String toTrim) {
        if (toTrim == null) {
            return "";
        }
        int end = toTrim.length();
        if (end > 0) {
            char currentChar;
            int current;
            for (current = end - 1; current >= 0 && Character.isWhitespace(currentChar = toTrim.charAt(current)) && currentChar != '\n' && currentChar != '\r'; --current) {
            }
            if (current < 0) {
                return "";
            }
            return toTrim.substring(0, current + 1);
        }
        return toTrim;
    }

    @Deprecated
    public static void processWhiteSpace(TextSvgBranchRenderer root, boolean isLeadingElement) {
        SvgTextUtil.processWhiteSpace(root, isLeadingElement, new SvgDrawContext(null, null));
    }

    public static void processWhiteSpace(TextSvgBranchRenderer root, boolean isLeadingElement, SvgDrawContext context) {
        String whiteSpace;
        String string = whiteSpace = root.getAttributeMapCopy().isEmpty() ? "normal" : root.getAttribute("white-space");
        if (whiteSpace == null) {
            whiteSpace = root.getAttribute("xml:space");
            whiteSpace = "preserve".equals(whiteSpace) ? "pre" : "normal";
        }
        boolean keepLineBreaks = "pre".equals(whiteSpace) || "pre-wrap".equals(whiteSpace) || "pre-line".equals(whiteSpace) || "break-spaces".equals(whiteSpace);
        boolean collapseSpaces = !"pre".equals(whiteSpace) && !"pre-wrap".equals(whiteSpace) && !"break-spaces".equals(whiteSpace);
        for (ISvgTextNodeRenderer child : root.getChildren()) {
            if (child instanceof TextSvgBranchRenderer) {
                TextSvgBranchRenderer childText;
                SvgTextUtil.processWhiteSpace(childText, (childText = (TextSvgBranchRenderer)child).containsAbsolutePositionChange(context) || isLeadingElement, context);
                childText.markWhiteSpaceProcessed();
                isLeadingElement = false;
            }
            if (!(child instanceof TextLeafSvgNodeRenderer)) continue;
            TextLeafSvgNodeRenderer leafRend = (TextLeafSvgNodeRenderer)child;
            String toProcess = leafRend.getAttribute("text_content");
            toProcess = toProcess.replace("\n", "");
            toProcess = WhiteSpaceUtil.processWhitespaces((String)toProcess, (boolean)keepLineBreaks, (boolean)collapseSpaces);
            if (!keepLineBreaks) {
                if (isLeadingElement) {
                    toProcess = SvgTextUtil.trimLeadingWhitespace(toProcess);
                    toProcess = SvgTextUtil.trimTrailingWhitespace(toProcess);
                    isLeadingElement = false;
                } else {
                    toProcess = SvgTextUtil.trimTrailingWhitespace(toProcess);
                }
            }
            leafRend.setAttribute("text_content", toProcess);
        }
    }

    public static boolean isOnlyWhiteSpace(String s) {
        String trimmedText = s.replaceAll("\\s+", " ");
        trimmedText = SvgTextUtil.trimLeadingWhitespace(trimmedText);
        trimmedText = SvgTextUtil.trimTrailingWhitespace(trimmedText);
        return trimmedText.isEmpty();
    }

    @Deprecated
    public static float resolveFontSize(ISvgTextNodeRenderer renderer, float parentFontSize) {
        float fontSize = Float.NaN;
        String elementFontSize = renderer.getAttribute("font-size");
        if (null != elementFontSize && !elementFontSize.isEmpty()) {
            fontSize = CssTypesValidationUtils.isRelativeValue((String)elementFontSize) || "larger".equals(elementFontSize) || "smaller".equals(elementFontSize) ? CssDimensionParsingUtils.parseRelativeFontSize((String)elementFontSize, (float)parentFontSize) : CssDimensionParsingUtils.parseAbsoluteFontSize((String)elementFontSize, (String)"px");
        }
        if (Float.isNaN(fontSize) || fontSize < 0.0f) {
            fontSize = parentFontSize;
        }
        return fontSize;
    }

    public static String filterReferenceValue(String name) {
        return name.replace("#", "").replace("url(", "").replace(")", "").trim();
    }

    public static void applyTextDecoration(ISvgTextNodeRenderer renderer, boolean doFill, boolean doStroke, SvgDrawContext context) {
        String textDecorationLineProp;
        if (renderer.getAttributeMapCopy().isEmpty()) {
            return;
        }
        String textDecoration = renderer.getAttribute("text-decoration");
        if (textDecoration != null) {
            List resolvedShorthandProps = new TextDecorationShorthandResolver().resolveShorthand(textDecoration);
            for (CssDeclaration cssDeclaration : resolvedShorthandProps) {
                if (renderer.getAttribute(cssDeclaration.getProperty()) != null) continue;
                renderer.setAttribute(cssDeclaration.getProperty(), cssDeclaration.getExpression());
            }
        }
        if ((textDecorationLineProp = renderer.getAttribute("text-decoration-line")) == null) {
            return;
        }
        String[] textDecorationArray = textDecorationLineProp.split("\\s+");
        ArrayList<Float> baselineList = new ArrayList<Float>();
        for (Underline underline : context.getSvgTextProperties().getTextDecoration()) {
            baselineList.add(Float.valueOf(underline.getYPositionMul()));
        }
        for (String line : textDecorationArray) {
            float textDecorationLine;
            switch (line) {
                case "line-through": {
                    textDecorationLine = -0.3f;
                    break;
                }
                case "overline": {
                    textDecorationLine = -0.9f;
                    break;
                }
                case "underline": {
                    textDecorationLine = 0.1f;
                    break;
                }
                default: {
                    return;
                }
            }
            baselineList.add(Float.valueOf(textDecorationLine));
        }
        Color fillColor = doFill ? context.getSvgTextProperties().getFillColor() : null;
        float fillOpacity = context.getSvgTextProperties().getFillOpacity();
        Color strokeColor = doStroke ? context.getSvgTextProperties().getStrokeColor() : null;
        float strokeOpacity = context.getSvgTextProperties().getStrokeOpacity();
        ArrayList<Underline> underlineList = new ArrayList<Underline>();
        Object object = baselineList.iterator();
        while (object.hasNext()) {
            float textDecorationLine = ((Float)object.next()).floatValue();
            SvgTextUtil.addUnderline(context, underlineList, strokeColor, strokeOpacity, fillColor, fillOpacity, textDecorationLine, doFill, doStroke);
        }
        context.getSvgTextProperties().setTextDecoration(underlineList);
    }

    private static void addUnderline(SvgDrawContext context, List<Underline> underlineList, Color strokeColor, float strokeOpacity, Color fillColor, float fillOpacity, float textDecorationLine, boolean doFill, boolean doStroke) {
        Underline underline = doStroke && doFill ? new Underline(fillColor, fillOpacity, context.getSvgTextProperties().getLineWidth(), 0.07f, 0.0f, textDecorationLine, 0).setStrokeColor(new TransparentColor(strokeColor, strokeOpacity)).setStrokeWidth(context.getSvgTextProperties().getLineWidth()).setDashPattern(context.getSvgTextProperties().getDashArray(), context.getSvgTextProperties().getDashPhase()) : (doStroke ? new Underline(null, 0.0f, context.getSvgTextProperties().getLineWidth(), 0.07f, 0.0f, textDecorationLine, 0).setStrokeColor(new TransparentColor(strokeColor, strokeOpacity)).setStrokeWidth(context.getSvgTextProperties().getLineWidth()).setDashPattern(context.getSvgTextProperties().getDashArray(), context.getSvgTextProperties().getDashPhase()) : new Underline(fillColor, fillOpacity, 0.0f, 0.07f, 0.0f, textDecorationLine, 0));
        underlineList.add(underline);
    }
}

