/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.credential.env;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.HostAddress;
import com.singlestore.jdbc.plugin.credential.Credential;
import com.singlestore.jdbc.plugin.credential.CredentialPlugin;

public class EnvCredentialPlugin
implements CredentialPlugin {
    private Configuration conf;
    private String userName;

    @Override
    public String type() {
        return "ENV";
    }

    @Override
    public CredentialPlugin initialize(Configuration conf, String userName, HostAddress hostAddress) {
        this.conf = conf;
        this.userName = userName;
        return this;
    }

    @Override
    public Credential get() {
        String userKey = this.conf.nonMappedOptions().getProperty("userKey");
        String pwdKey = this.conf.nonMappedOptions().getProperty("pwdKey");
        String envUser = System.getenv(userKey != null ? userKey : "SINGLESTORE_USER");
        return new Credential(envUser == null ? this.userName : envUser, System.getenv(pwdKey != null ? pwdKey : "SINGLESTORE_PWD"));
    }
}

