/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.credential.system;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.HostAddress;
import com.singlestore.jdbc.plugin.credential.Credential;
import com.singlestore.jdbc.plugin.credential.CredentialPlugin;

public class PropertiesCredentialPlugin
implements CredentialPlugin {
    private Configuration conf;
    private String userName;

    @Override
    public String type() {
        return "PROPERTY";
    }

    @Override
    public CredentialPlugin initialize(Configuration conf, String userName, HostAddress hostAddress) {
        this.conf = conf;
        this.userName = userName;
        return this;
    }

    @Override
    public Credential get() {
        String userKey = this.conf.nonMappedOptions().getProperty("userKey");
        String pwdKey = this.conf.nonMappedOptions().getProperty("pwdKey");
        String propUser = System.getProperty(userKey != null ? userKey : "singlestore.user");
        return new Credential(propUser == null ? this.userName : propUser, System.getProperty(pwdKey != null ? pwdKey : "singlestore.pwd"));
    }
}

