/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.common;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.common.ColumnInfo;
import com.taosdata.jdbc.common.DataLengthCfg;
import com.taosdata.jdbc.common.TableInfo;
import com.taosdata.jdbc.utils.DateTimeUtils;
import com.taosdata.jdbc.utils.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SerializeBlock {
    private SerializeBlock() {
    }

    private static int bitMapLen(int n) {
        return n + 7 >> 3;
    }

    private static int bitPos(int n) {
        return n & 7;
    }

    private static int charOffset(int n) {
        return n >> 3;
    }

    private static byte bmSetNull(byte c, int n) {
        return (byte)(c + (1 << 7 - SerializeBlock.bitPos(n)));
    }

    private static void handleBoolean(ByteArrayOutputStream buf, Object o) {
        boolean v = (Boolean)o;
        if (v) {
            buf.write(1);
        } else {
            buf.write(0);
        }
    }

    private static void SerializeInt(byte[] buf, int offset, int v) {
        buf[offset] = (byte)(v & 0xFF);
        buf[offset + 1] = (byte)(v >> 8 & 0xFF);
        buf[offset + 2] = (byte)(v >> 16 & 0xFF);
        buf[offset + 3] = (byte)(v >> 24 & 0xFF);
    }

    private static void SerializeLong(byte[] buf, int offset, long v) {
        buf[offset] = (byte)(v & 0xFFL);
        buf[offset + 1] = (byte)(v >> 8 & 0xFFL);
        buf[offset + 2] = (byte)(v >> 16 & 0xFFL);
        buf[offset + 3] = (byte)(v >> 24 & 0xFFL);
        buf[offset + 4] = (byte)(v >> 32 & 0xFFL);
        buf[offset + 5] = (byte)(v >> 40 & 0xFFL);
        buf[offset + 6] = (byte)(v >> 48 & 0xFFL);
        buf[offset + 7] = (byte)(v >> 56 & 0xFFL);
    }

    private static void SerializeShort(ByteBuf buf, short v) {
        buf.writeShortLE((int)v);
    }

    public static void serializeByteArray(ByteBuf buf, byte[] data) {
        buf.writeBytes(data);
    }

    private static void serializeColumn(ColumnInfo columnInfo, ByteBuf buf, int precision) throws SQLException {
        Integer dataLen = DataLengthCfg.getDataLength(columnInfo.getType());
        buf.writeIntLE(columnInfo.getSerializeSize());
        buf.writeIntLE(columnInfo.getType());
        buf.writeIntLE(columnInfo.getDataList().size());
        for (Object o : columnInfo.getDataList()) {
            if (o == null) {
                buf.writeByte(1);
                continue;
            }
            buf.writeByte(0);
        }
        if (dataLen != null) {
            buf.writeByte(0);
            SerializeBlock.SerializeNormalDataType(columnInfo.getType(), buf, columnInfo.getDataList(), precision);
            return;
        }
        buf.writeByte(1);
        int bufferLength = 0;
        block5: for (Object o : columnInfo.getDataList()) {
            if (o == null) {
                buf.writeIntLE(0);
                continue;
            }
            switch (columnInfo.getType()) {
                case 8: 
                case 15: 
                case 16: 
                case 18: 
                case 20: {
                    Object v = (byte[])o;
                    buf.writeIntLE(((Object)v).length);
                    bufferLength += ((Object)v).length;
                    continue block5;
                }
                case 10: {
                    Object v = (String)o;
                    int len = ((String)v).getBytes().length;
                    buf.writeIntLE(len);
                    bufferLength += len;
                    continue block5;
                }
            }
            throw TSDBError.createSQLException(8963, "unsupported data type : " + columnInfo.getType());
        }
        buf.writeIntLE(bufferLength);
        SerializeBlock.SerializeArrayDataType(columnInfo.getType(), buf, columnInfo.getDataList());
    }

    private static void SerializeNormalDataType(int dataType, ByteBuf buf, List<Object> objectList, int precision) throws SQLException {
        switch (dataType) {
            case 1: {
                buf.writeIntLE(objectList.size());
                for (Object o : objectList) {
                    if (o == null) {
                        buf.writeByte(0);
                        continue;
                    }
                    boolean v = (Boolean)o;
                    buf.writeByte(v ? 1 : 0);
                }
                break;
            }
            case 2: {
                buf.writeIntLE(objectList.size());
                for (Object o : objectList) {
                    if (o == null) {
                        buf.writeByte(0);
                        continue;
                    }
                    byte v = (Byte)o;
                    buf.writeByte((int)v);
                }
                break;
            }
            case 11: {
                buf.writeIntLE(objectList.size());
                for (Object o : objectList) {
                    if (o == null) {
                        buf.writeByte(0);
                        continue;
                    }
                    short v = (Short)o;
                    if (v < 0 || v > 255) {
                        throw TSDBError.createSQLException(8963, "utinyint value is out of range");
                    }
                    buf.writeByte(v & 0xFF);
                }
                break;
            }
            case 3: {
                buf.writeIntLE(objectList.size() * 2);
                for (Object o : objectList) {
                    if (o != null) {
                        SerializeBlock.SerializeShort(buf, (Short)o);
                        continue;
                    }
                    SerializeBlock.SerializeShort(buf, (short)0);
                }
                break;
            }
            case 12: {
                buf.writeIntLE(objectList.size() * 2);
                for (Object o : objectList) {
                    if (o != null) {
                        int v = (Integer)o;
                        if (v < 0 || v > 65535) {
                            throw TSDBError.createSQLException(8963, "usmallint value is out of range");
                        }
                        buf.writeShortLE(v & 0xFFFF);
                        continue;
                    }
                    buf.writeShortLE(0);
                }
                break;
            }
            case 4: {
                buf.writeIntLE(objectList.size() * 4);
                for (Object o : objectList) {
                    if (o != null) {
                        buf.writeIntLE(((Integer)o).intValue());
                        continue;
                    }
                    buf.writeIntLE(0);
                }
                break;
            }
            case 13: {
                buf.writeIntLE(objectList.size() * 4);
                for (Object o : objectList) {
                    if (o != null) {
                        long v = (Long)o;
                        if (v < 0L || v > 0xFFFFFFFFL) {
                            throw TSDBError.createSQLException(8963, "uint value is out of range");
                        }
                        buf.writeIntLE((int)(v & 0xFFFFFFFFL));
                        continue;
                    }
                    buf.writeIntLE(0);
                }
                break;
            }
            case 5: {
                buf.writeIntLE(objectList.size() * 8);
                for (Object o : objectList) {
                    if (o != null) {
                        buf.writeLongLE(((Long)o).longValue());
                        continue;
                    }
                    buf.writeLongLE(0L);
                }
                break;
            }
            case 14: {
                buf.writeIntLE(objectList.size() * 8);
                for (Object o : objectList) {
                    if (o != null) {
                        BigInteger v = (BigInteger)o;
                        if (v.compareTo(BigInteger.ZERO) < 0 || v.compareTo(new BigInteger("18446744073709551615")) > 0) {
                            throw TSDBError.createSQLException(8963, "ubigint value is out of range");
                        }
                        buf.writeLongLE(v.longValue());
                        continue;
                    }
                    buf.writeLongLE(0L);
                }
                break;
            }
            case 6: {
                buf.writeIntLE(objectList.size() * 4);
                for (Object o : objectList) {
                    float v = 0.0f;
                    if (o != null) {
                        v = ((Float)o).floatValue();
                    }
                    buf.writeFloatLE(v);
                }
                break;
            }
            case 7: {
                buf.writeIntLE(objectList.size() * 8);
                for (Object o : objectList) {
                    double v = 0.0;
                    if (o != null) {
                        v = (Double)o;
                    }
                    buf.writeDoubleLE(v);
                }
                break;
            }
            case 9: {
                buf.writeIntLE(objectList.size() * 8);
                for (Object o : objectList) {
                    if (o != null) {
                        long v;
                        if (o instanceof Instant) {
                            Instant instant = (Instant)o;
                            v = DateTimeUtils.toLong(instant, precision);
                            buf.writeLongLE(v);
                            continue;
                        }
                        if (o instanceof OffsetDateTime) {
                            OffsetDateTime offsetDateTime = (OffsetDateTime)o;
                            v = DateTimeUtils.toLong(offsetDateTime.toInstant(), precision);
                            buf.writeLongLE(v);
                            continue;
                        }
                        if (o instanceof ZonedDateTime) {
                            ZonedDateTime zonedDateTime = (ZonedDateTime)o;
                            v = DateTimeUtils.toLong(zonedDateTime.toInstant(), precision);
                            buf.writeLongLE(v);
                            continue;
                        }
                        if (o instanceof Long) {
                            buf.writeLongLE(((Long)o).longValue());
                            continue;
                        }
                        throw TSDBError.createSQLException(8963, "unsupported timestamp data type : " + o.getClass().getName());
                    }
                    buf.writeLongLE(0L);
                }
                break;
            }
            default: {
                throw TSDBError.createSQLException(8963, "unsupported data type : " + dataType);
            }
        }
    }

    private static void SerializeArrayDataType(int dataType, ByteBuf buf, List<Object> objectList) throws SQLException {
        switch (dataType) {
            case 8: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                for (Object o : objectList) {
                    if (o == null) continue;
                    byte[] v = (byte[])o;
                    SerializeBlock.serializeByteArray(buf, v);
                }
                break;
            }
            case 10: {
                for (Object o : objectList) {
                    if (o == null) continue;
                    String v = (String)o;
                    byte[] bytes = v.getBytes();
                    SerializeBlock.serializeByteArray(buf, bytes);
                }
                break;
            }
            default: {
                throw TSDBError.createSQLException(8963, "unsupported data type : " + dataType);
            }
        }
    }

    public static int getTagTotalLength(TableInfo tableInfo, int toBebindTagCount) throws SQLException {
        int totalLength = 0;
        if (toBebindTagCount > 0) {
            if (tableInfo.getTagInfo().size() != toBebindTagCount) {
                throw TSDBError.createSQLException(8963, "table tag size is not match");
            }
            for (ColumnInfo tag : tableInfo.getTagInfo()) {
                if (tag.getDataList().isEmpty()) {
                    throw TSDBError.createSQLException(8963, "tag value is null, tbname: " + tableInfo.getTableName().toString());
                }
                int columnSize = SerializeBlock.getColumnSize(tag);
                tag.setSerializeSize(columnSize);
                totalLength += columnSize;
            }
        }
        return totalLength;
    }

    public static int getColTotalLength(TableInfo tableInfo, int toBebindColCount) throws SQLException {
        int totalLength = 0;
        if (toBebindColCount > 0) {
            if (tableInfo.getDataList().size() != toBebindColCount) {
                throw TSDBError.createSQLException(8963, "table column size is not match");
            }
            for (ColumnInfo columnInfo : tableInfo.getDataList()) {
                int columnSize = SerializeBlock.getColumnSize(columnInfo);
                columnInfo.setSerializeSize(columnSize);
                totalLength += columnSize;
            }
        }
        return totalLength;
    }

    public static int getColumnSize(ColumnInfo column) throws SQLException {
        Integer dataLen = DataLengthCfg.getDataLength(column.getType());
        if (dataLen != null) {
            return 17 + (dataLen + 1) * column.getDataList().size();
        }
        switch (column.getType()) {
            case 8: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                int totalLength = 0;
                for (Object o : column.getDataList()) {
                    if (o == null) continue;
                    byte[] v = (byte[])o;
                    totalLength += v.length;
                }
                return 17 + 5 * column.getDataList().size() + totalLength;
            }
            case 10: {
                int totalLength = 0;
                for (Object o : column.getDataList()) {
                    if (o == null) continue;
                    String v = (String)o;
                    totalLength += v.getBytes().length;
                }
                return 17 + 5 * column.getDataList().size() + totalLength;
            }
        }
        throw TSDBError.createSQLException(8963, "unsupported data type : " + column.getType());
    }

    public static ByteBuf getStmt2BindBlock(long reqId, long stmtId, HashMap<ByteBuffer, TableInfo> tableInfoMap, int toBeBindTableNameIndex, int toBebindTagCount, int toBebindColCount, int precision) throws SQLException {
        int totalTableNameSize = 0;
        ArrayList<Short> tableNameSizeList = new ArrayList<Short>();
        if (toBeBindTableNameIndex >= 0) {
            for (TableInfo tableInfo : tableInfoMap.values()) {
                if (tableInfo.getTableName().capacity() == 0) {
                    throw TSDBError.createSQLException(8963, "table name is empty");
                }
                int tableNameSize = tableInfo.getTableName().capacity() + 1;
                totalTableNameSize += tableNameSize;
                tableNameSizeList.add((short)tableNameSize);
            }
        }
        int totalTagSize = 0;
        ArrayList<Integer> tagSizeList = new ArrayList<Integer>();
        if (toBebindTagCount > 0) {
            for (TableInfo tableInfo : tableInfoMap.values()) {
                int tagSize = SerializeBlock.getTagTotalLength(tableInfo, toBebindTagCount);
                totalTagSize += tagSize;
                tagSizeList.add(tagSize);
            }
        }
        int totalColSize = 0;
        ArrayList<Integer> colSizeList = new ArrayList<Integer>();
        if (toBebindColCount > 0) {
            for (TableInfo tableInfo : tableInfoMap.values()) {
                int colSize = SerializeBlock.getColTotalLength(tableInfo, toBebindColCount);
                totalColSize += colSize;
                colSizeList.add(colSize);
            }
        }
        int totalSize = totalTableNameSize + totalTagSize + totalColSize;
        int toBebindTableNameCount = toBeBindTableNameIndex >= 0 ? 1 : 0;
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.directBuffer(58 + (totalSize += tableInfoMap.size() * (toBebindTableNameCount * 2 + (toBebindTagCount > 0 ? 1 : 0) * 4 + (toBebindColCount > 0 ? 1 : 0) * 4)));
        try {
            buf.writeLongLE(reqId);
            buf.writeLongLE(stmtId);
            buf.writeLongLE(9L);
            buf.writeShortLE(1);
            buf.writeIntLE(-1);
            buf.writeIntLE(totalSize + 28);
            buf.writeIntLE(tableInfoMap.size());
            buf.writeIntLE(toBebindTagCount);
            buf.writeIntLE(toBebindColCount);
            if (toBebindTableNameCount > 0) {
                buf.writeIntLE(28);
            } else {
                buf.writeIntLE(0);
            }
            if (toBebindTagCount > 0) {
                if (toBebindTableNameCount > 0) {
                    buf.writeIntLE(28 + totalTableNameSize + 2 * tableInfoMap.size());
                } else {
                    buf.writeIntLE(28);
                }
            } else {
                buf.writeIntLE(0);
            }
            if (toBebindColCount > 0) {
                int skipSize = 0;
                if (toBebindTableNameCount > 0) {
                    skipSize += totalTableNameSize + 2 * tableInfoMap.size();
                }
                if (toBebindTagCount > 0) {
                    skipSize += totalTagSize + 4 * tableInfoMap.size();
                }
                buf.writeIntLE(28 + skipSize);
            } else {
                buf.writeIntLE(0);
            }
            if (toBebindTableNameCount > 0) {
                for (Short tableNameLen : tableNameSizeList) {
                    if (tableNameLen == 0) {
                        throw TSDBError.createSQLException(8963, "table name is empty");
                    }
                    buf.writeShortLE((int)tableNameLen.shortValue());
                }
                for (TableInfo tableInfo : tableInfoMap.values()) {
                    if (tableInfo.getTableName().capacity() == 0) {
                        throw TSDBError.createSQLException(8963, "table name is empty");
                    }
                    buf.writeBytes(tableInfo.getTableName().array());
                    buf.writeByte(0);
                }
            }
            if (toBebindTagCount > 0) {
                for (Integer tagsize : tagSizeList) {
                    buf.writeIntLE(tagsize.intValue());
                }
                for (TableInfo tableInfo : tableInfoMap.values()) {
                    for (ColumnInfo tag : tableInfo.getTagInfo()) {
                        if (tag.getDataList().isEmpty()) {
                            throw TSDBError.createSQLException(8963, "tag value is null, tbname: " + tableInfo.getTableName().toString());
                        }
                        SerializeBlock.serializeColumn(tag, buf, precision);
                    }
                }
            }
            if (toBebindColCount > 0) {
                for (Integer colSize : colSizeList) {
                    buf.writeIntLE(colSize.intValue());
                }
                for (TableInfo tableInfo : tableInfoMap.values()) {
                    for (ColumnInfo col : tableInfo.getDataList()) {
                        SerializeBlock.serializeColumn(col, buf, precision);
                    }
                }
            }
            return buf;
        }
        catch (Exception e) {
            Utils.releaseByteBuf(buf);
            throw e;
        }
    }

    public static byte[] shortToBytes(int v) {
        byte[] result = new byte[]{(byte)(v & 0xFF), (byte)(v >> 8 & 0xFF)};
        return result;
    }

    public static byte[] intToBytes(int v) {
        byte[] result = new byte[]{(byte)(v & 0xFF), (byte)(v >> 8 & 0xFF), (byte)(v >> 16 & 0xFF), (byte)(v >> 24 & 0xFF)};
        return result;
    }

    public static byte[] longToBytes(long v) {
        byte[] result = new byte[]{(byte)(v & 0xFFL), (byte)(v >> 8 & 0xFFL), (byte)(v >> 16 & 0xFFL), (byte)(v >> 24 & 0xFFL), (byte)(v >> 32 & 0xFFL), (byte)(v >> 40 & 0xFFL), (byte)(v >> 48 & 0xFFL), (byte)(v >> 56 & 0xFFL)};
        return result;
    }
}

