/*
 * Decompiled with CFR 0.152.
 */
package com.uc.sso;

import cn.hutool.core.lang.Assert;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.uc.sso.entity.UserCenterResponse;
import com.uc.sso.entity.request.UserCenterRequest;
import com.uc.sso.entity.response.AppInfo;
import com.uc.sso.entity.response.OrgInfo;
import com.uc.sso.entity.response.RegionInfo;
import com.uc.sso.entity.response.TokenInfo;
import com.uc.sso.entity.response.UserInfo;
import com.uc.sso.exception.HttpRequestException;
import com.uc.sso.utils.OpenAPIEncryptUtil;
import com.uc.sso.utils.OpenApiCerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCenterClient {
    private static final Logger log = LoggerFactory.getLogger(UserCenterClient.class);
    private String licenseSn;
    private String sid;
    private String sm2PrivateKey;
    private String sm2PublicKey;
    private String sm4Key;
    private String url;
    public static Map<String, UserCenterClient> clientMap = new HashMap<String, UserCenterClient>();

    public static UserCenterClient init(String cerPath) {
        UserCenterClient client = clientMap.get(cerPath);
        if (client == null) {
            String cerDataStr = UserCenterClient.readFileToString(cerPath);
            JSONObject cerData = OpenApiCerUtil.verifyCerAndDecrypt(cerDataStr);
            client = new UserCenterClient();
            client.sid = cerData.getStr((Object)"sid");
            client.licenseSn = cerData.getStr((Object)"license_sn");
            client.sm2PrivateKey = cerData.getStr((Object)"sm2_private_key");
            client.sm2PublicKey = cerData.getStr((Object)"sm2_public_key");
            client.sm4Key = cerData.getStr((Object)"sm4_key");
            client.url = cerData.getStr((Object)"url");
            clientMap.put(cerPath, client);
            log.info("\u521d\u59cb\u5316\u5ba2\u6237\u7aef\u6210\u529f url:[{}] sid:[{}] licenseSn:[{}]", new Object[]{client.url, client.sid, client.licenseSn});
        }
        return client;
    }

    public void setServerUrl(String serverUrl) {
        log.info("\u4fee\u6539\u7528\u6237\u4e2d\u5fc3\u8bf7\u6c42\u5730\u5740\uff0c\u539f\uff1a{}\uff0c\u65b0\uff1a{}", (Object)this.url, (Object)serverUrl);
        this.url = serverUrl;
    }

    public void setApiRoot(String apiRoot) {
        String newUrl = apiRoot + "/openapi/uc/sso";
        log.info("\u4fee\u6539\u7528\u6237\u4e2d\u5fc3\u8bf7\u6c42\u5730\u5740\uff0c\u539f\uff1a{}\uff0c\u65b0\uff1a{}", (Object)this.url, (Object)newUrl);
        this.url = newUrl;
    }

    private static long getServerTimeDiff(UserCenterClient userCenterClient) {
        String timeStampUrl = userCenterClient.url.replace("/openapi/uc/sso", "/node/timestamp");
        try {
            String responseJson = HttpUtil.get((String)timeStampUrl, (int)5000);
            JSONObject json = JSONUtil.parseObj((String)responseJson);
            long currentTimeMillis = System.currentTimeMillis();
            long serverTimestamp = Optional.ofNullable(json.getLong((Object)"timestamp")).orElse(currentTimeMillis);
            long serverTimeDiff = serverTimestamp - currentTimeMillis;
            log.debug("\u83b7\u5f97\u673a\u5668\u65f6\u95f4\u5dee\uff1a{} timeStampUrl:{}", (Object)serverTimeDiff, (Object)timeStampUrl);
            return serverTimeDiff;
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u670d\u52a1\u5668\u65f6\u95f4\u6233\u5931\u8d25\uff0ctimeStampUrl\uff1a{}", (Object)timeStampUrl, (Object)e);
            return 0L;
        }
    }

    public static UserCenterClient getInstance() {
        Assert.isFalse((boolean)clientMap.isEmpty(), (String)"\u8bf7\u5148\u8c03\u7528init\u8fdb\u884c\u521d\u59cb\u5316", (Object[])new Object[0]);
        Assert.isTrue((clientMap.size() == 1 ? 1 : 0) != 0, (String)"\u591a\u4e2a\u8bc1\u4e66\u5b9e\u4f8b\uff0c\u8bf7\u4f7f\u7528getInstance(String cerPath)\u83b7\u53d6\u5b9e\u4f8b", (Object[])new Object[0]);
        return clientMap.values().iterator().next();
    }

    public static UserCenterClient getInstance(String cerPath) {
        UserCenterClient userCenterClient = clientMap.get(cerPath);
        Assert.notNull((Object)userCenterClient, (String)"\u8bf7\u5148\u8c03\u7528init\u8fdb\u884c\u521d\u59cb\u5316", (Object[])new Object[0]);
        return userCenterClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readFileToString(String filePath) {
        Assert.notEmpty((CharSequence)filePath, (String)"\u8bc1\u4e66\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        try {
            return new String(Files.readAllBytes(Paths.get(new File(filePath).toURI())));
        }
        catch (IOException e) {
            log.warn("Failed to read file in system: " + filePath);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(UserCenterClient.class.getClassLoader().getResourceAsStream(filePath)));){
                String currentLine;
                StringBuilder contentBuilder = new StringBuilder();
                while ((currentLine = br.readLine()) != null) {
                    contentBuilder.append(currentLine).append("\n");
                }
                String string = contentBuilder.toString();
                return string;
            }
            catch (IOException e2) {
                throw new RuntimeException("Failed to read file: " + filePath, e2);
            }
        }
    }

    public UserCenterResponse<TokenInfo> getTokenByTicket(UserCenterRequest ucRequest) {
        String ticket = ucRequest.getTicket();
        Assert.isTrue((ticket != null && !ticket.isEmpty() && !ticket.trim().isEmpty() ? 1 : 0) != 0, (String)"ticket\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, String> encryptedData = this.buildEncryptedData(ucRequest);
        String endpoint = "/login/getTokenByTicket";
        return this.executeHttpRequest(encryptedData, endpoint, TokenInfo.class);
    }

    public UserCenterResponse<TokenInfo> refreshToken(UserCenterRequest ucRequest) {
        String refreshToken = ucRequest.getRefreshToken();
        Assert.isTrue((refreshToken != null && !refreshToken.isEmpty() && !refreshToken.trim().isEmpty() ? 1 : 0) != 0, (String)"refreshToken\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, String> encryptedData = this.buildEncryptedData(ucRequest);
        String endpoint = "/login/refreshToken";
        return this.executeHttpRequest(encryptedData, endpoint, TokenInfo.class);
    }

    public UserCenterResponse<UserInfo> getUserInfo(UserCenterRequest ucRequest) {
        String token = ucRequest.getToken();
        Assert.isTrue((token != null && !token.isEmpty() && !token.trim().isEmpty() ? 1 : 0) != 0, (String)"token\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, String> encryptedData = this.buildEncryptedData(ucRequest);
        String endpoint = "/login/getUserInfo";
        return this.executeHttpRequest(encryptedData, endpoint, UserInfo.class);
    }

    public UserCenterResponse<List<AppInfo>> getAppList(UserCenterRequest ucRequest) {
        String token = ucRequest.getToken();
        Assert.isTrue((token != null && !token.isEmpty() && !token.trim().isEmpty() ? 1 : 0) != 0, (String)"token\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, String> encryptedData = this.buildEncryptedData(ucRequest);
        String endpoint = "/login/getAppList";
        Class<AppInfo> clazz = AppInfo.class;
        return this.executeHttpRequestList(encryptedData, endpoint, clazz);
    }

    public UserCenterResponse<String> addAppPermission(UserCenterRequest ucRequest) {
        String userCode = ucRequest.getUserCode();
        Assert.isTrue((userCode != null && !userCode.isEmpty() && !userCode.trim().isEmpty() ? 1 : 0) != 0, (String)"userCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, String> encryptedData = this.buildEncryptedData(ucRequest);
        String endpoint = "/login/addAppPerm";
        return this.executeHttpRequest(encryptedData, endpoint, String.class);
    }

    public UserCenterResponse<OrgInfo> getOrgDetail(UserCenterRequest ucRequest) {
        String orgCode = ucRequest.getOrgCode();
        Assert.isTrue((orgCode != null && !orgCode.isEmpty() && !orgCode.trim().isEmpty() ? 1 : 0) != 0, (String)"orgCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, String> encryptedData = this.buildEncryptedData(ucRequest);
        String endpoint = "/org/getOrgDetail";
        return this.executeHttpRequest(encryptedData, endpoint, OrgInfo.class);
    }

    public UserCenterResponse<RegionInfo> getRegionalInfo(UserCenterRequest ucRequest) {
        String regionCode = ucRequest.getRegionCode();
        Assert.isTrue((regionCode != null && !regionCode.isEmpty() && !regionCode.trim().isEmpty() ? 1 : 0) != 0, (String)"orgCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, String> encryptedData = this.buildEncryptedData(ucRequest);
        String endpoint = "/regional/getRegionalInfo";
        return this.executeHttpRequest(encryptedData, endpoint, RegionInfo.class);
    }

    private <T> UserCenterResponse<List<T>> executeHttpRequestList(Map<String, String> encryptedData, String endpoint, Class<T> clazz) {
        String response;
        try {
            response = this.sendHttpPostRequest(encryptedData, endpoint);
        }
        catch (IOException e) {
            log.error("IOException", (Throwable)e);
            return UserCenterResponse.of(500, "\u8bf7\u6c42\u5931\u8d25");
        }
        catch (HttpRequestException e) {
            log.error("HttpRequestException", (Throwable)e);
            return UserCenterResponse.of(e.getCode(), e.getMessage());
        }
        JSONObject json = JSONUtil.parseObj((String)response);
        String code = json.getStr((Object)"code");
        if (!"0".equals(code)) {
            log.warn("SDK\u8bf7\u6c42\u5f02\u5e38:{} \u54cd\u5e94:{}", (Object)(this.url + endpoint), (Object)response);
            String msg = json.getStr((Object)"msg");
            return UserCenterResponse.of(code, msg);
        }
        List<T> data = this.checkAndGetBusinessDataList(response, clazz);
        log.debug("SDK\u8bf7\u6c42:{} \u54cd\u5e94:{}", (Object)(this.url + endpoint), (Object)JSONUtil.toJsonStr(data));
        return UserCenterResponse.of(data);
    }

    private <T> UserCenterResponse<T> executeHttpRequest(Map<String, String> encryptedData, String endpoint, Class<T> clazz) {
        String response;
        try {
            response = this.sendHttpPostRequest(encryptedData, endpoint);
        }
        catch (IOException e) {
            log.error("IOException during sending HTTP POST request to " + endpoint, (Throwable)e);
            return UserCenterResponse.of(500, "\u8bf7\u6c42\u5931\u8d25");
        }
        catch (HttpRequestException e) {
            log.error("HttpRequestException during sending HTTP POST request to " + endpoint, (Throwable)e);
            return UserCenterResponse.of(e.getCode(), e.getMessage());
        }
        JSONObject json = JSONUtil.parseObj((String)response);
        String code = json.getStr((Object)"code");
        if (!"0".equals(code)) {
            log.warn("SDK\u8bf7\u6c42\u5f02\u5e38:{} \u54cd\u5e94:{}", (Object)(this.url + endpoint), (Object)response);
            String msg = json.getStr((Object)"msg");
            return UserCenterResponse.of(code, msg);
        }
        T data = this.checkAndGetBusinessData(response, clazz);
        log.debug("SDK\u8bf7\u6c42:{} \u54cd\u5e94:{}", (Object)(this.url + endpoint), (Object)JSONUtil.toJsonStr(data));
        return UserCenterResponse.of(data);
    }

    private Map<String, String> buildEncryptedData(UserCenterRequest ucRequest) {
        return OpenAPIEncryptUtil.buildEncryptedData(JSONUtil.toJsonStr((Object)ucRequest), this.sm4Key, this.sm2PrivateKey, UserCenterClient.getServerTimeDiff(this));
    }

    public Map<String, String> buildEncryptedData(String data) {
        return OpenAPIEncryptUtil.buildEncryptedData(data, this.sm4Key, this.sm2PrivateKey, UserCenterClient.getServerTimeDiff(this));
    }

    private String sendHttpPostRequest(Map<String, String> encryptedData, String endpoint) throws IOException {
        String finalUrl = this.url + endpoint;
        if (!this.url.contains("https")) {
            HttpResponse response = ((HttpRequest)HttpRequest.post((String)finalUrl).header("license-sn", this.licenseSn)).body(JSONUtil.toJsonStr(encryptedData)).execute();
            return response.body();
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }}, new SecureRandom());
            URL url = new URL(finalUrl);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setSSLSocketFactory(sslContext.getSocketFactory());
            connection.setHostnameVerifier((hostname, session) -> true);
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("license-sn", this.licenseSn);
            try (OutputStream os = connection.getOutputStream();){
                os.write(JSONUtil.toJsonStr(encryptedData).getBytes());
            }
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                StringBuilder response = new StringBuilder();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String inputLine;
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                }
                return response.toString();
            }
            StringBuilder errorResponse = new StringBuilder();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getErrorStream()));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    errorResponse.append(inputLine);
                }
            }
            throw new HttpRequestException(responseCode, errorResponse.toString());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5931\u8d25 url:{}", (Object)finalUrl, (Object)e);
            throw new IOException("SSL Handshake Failed", e);
        }
    }

    private <T> T checkAndGetBusinessData(String encryptedData, Class<T> clazz) {
        String decryptResponse = this.decryptData(encryptedData);
        try {
            return (T)JSONUtil.toBean((String)decryptResponse, clazz);
        }
        catch (Exception e) {
            log.error("JSON \u89e3\u6790\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public String decryptData(String encryptedData) {
        return OpenAPIEncryptUtil.checkAndGetBusinessData(encryptedData, this.sm4Key, this.sm2PublicKey, UserCenterClient.getServerTimeDiff(this));
    }

    private <T> List<T> checkAndGetBusinessDataList(String encryptedData, Class<T> clazz) {
        String decryptResponse = this.decryptData(encryptedData);
        try {
            return JSONUtil.toList((String)decryptResponse, clazz);
        }
        catch (Exception e) {
            log.error("JSON \u89e3\u6790\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

