/*
 * Decompiled with CFR 0.152.
 */
package com.uc.sso.utils;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.lang.Assert;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.crypto.symmetric.SM4;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class OpenAPIEncryptUtil {
    public static Map<String, String> generateSM2KeyPair() {
        final KeyPair pair = SecureUtil.generateKeyPair((String)"SM2");
        return new HashMap<String, String>(){
            {
                this.put("publicKey", Base64.encode((byte[])pair.getPublic().getEncoded()));
                this.put("privateKey", Base64.encode((byte[])pair.getPrivate().getEncoded()));
            }
        };
    }

    public static String generateSM4Key() {
        return Base64.encode((byte[])SecureUtil.generateKey((String)"SM4").getEncoded());
    }

    public static String generateLicenseSn() {
        return "SN" + UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static Map<String, String> buildEncryptedData(Object businessObj, String sm4Key, String sm2PrivateKey, long serverTimeDiff) {
        String businessData = JSONUtil.toJsonStr((Object)businessObj);
        final long timestamp = System.currentTimeMillis() + serverTimeDiff;
        String plainText = businessData + timestamp;
        String digest = SmUtil.sm3((String)plainText);
        SM2 sm2 = new SM2(Base64.decode((CharSequence)sm2PrivateKey), null);
        sm2.usePlainEncoding();
        byte[] sign = sm2.sign(digest.getBytes(), null);
        final String signBase64 = Base64.encode((byte[])sign);
        SM4 sm4 = SmUtil.sm4((byte[])Base64.decode((CharSequence)sm4Key));
        final String dataBase64 = Base64.encode((byte[])sm4.encrypt(businessData));
        return new HashMap<String, String>(){
            {
                this.put("data", dataBase64);
                this.put("timestamp", String.valueOf(timestamp));
                this.put("signature", signBase64);
            }
        };
    }

    public static String checkAndGetBusinessData(Object encryptedData, String sm4Key, String sm2PublicKey, long serverTimeDiff) {
        JSONObject json = JSONUtil.parseObj((Object)encryptedData);
        String data = json.getStr((Object)"data");
        String timestamp = json.getStr((Object)"timestamp");
        String sign = json.getStr((Object)"signature");
        Assert.isTrue((data != null && timestamp != null && sign != null ? 1 : 0) != 0, (String)"\u52a0\u5bc6\u6570\u636e\u683c\u5f0f\u9519\u8bef", (Object[])new Object[0]);
        Assert.isTrue((boolean)OpenAPIEncryptUtil.isValidTimestamp(timestamp, serverTimeDiff), (String)"\u65f6\u95f4\u6233\u6821\u9a8c\u5931\u8d25", (Object[])new Object[0]);
        SM4 sm4 = SmUtil.sm4((byte[])Base64.decode((CharSequence)sm4Key));
        String businessData = sm4.decryptStr(Base64.decode((CharSequence)data));
        String plainText = businessData + timestamp;
        String digest = SmUtil.sm3((String)plainText);
        SM2 sm2 = new SM2(null, Base64.decode((CharSequence)sm2PublicKey));
        sm2.usePlainEncoding();
        Assert.isTrue((boolean)sm2.verify(digest.getBytes(), Base64.decode((CharSequence)sign)), (String)"\u7b7e\u540d\u6821\u9a8c\u5931\u8d25", (Object[])new Object[0]);
        return businessData;
    }

    public static boolean validateData(Object encryptedData, String sm4Key, String sm2PublicKey, long serverTimeDiff) {
        JSONObject json = JSONUtil.parseObj((Object)encryptedData);
        String data = json.getStr((Object)"data");
        String timestamp = json.getStr((Object)"timestamp");
        String sign = json.getStr((Object)"signature");
        if (!OpenAPIEncryptUtil.isValidTimestamp(timestamp, serverTimeDiff)) {
            return false;
        }
        SM4 sm4 = SmUtil.sm4((byte[])Base64.decode((CharSequence)sm4Key));
        String businessData = sm4.decryptStr(Base64.decode((CharSequence)data));
        String plainText = businessData + timestamp;
        String digest = SmUtil.sm3((String)plainText);
        SM2 sm2 = new SM2(null, Base64.decode((CharSequence)sm2PublicKey));
        sm2.usePlainEncoding();
        return sm2.verify(digest.getBytes(), Base64.decode((CharSequence)sign));
    }

    public static String sm4Encrypt(String sm4Key, String businessData) {
        SM4 sm4 = SmUtil.sm4((byte[])Base64.decode((CharSequence)sm4Key));
        String dataBase64 = Base64.encode((byte[])sm4.encrypt(businessData));
        return dataBase64;
    }

    public static String sign(String sm2PrivateKey, String plainText) {
        String digest = SmUtil.sm3((String)plainText);
        SM2 sm2 = new SM2(Base64.decode((CharSequence)sm2PrivateKey), null);
        sm2.usePlainEncoding();
        byte[] sign = sm2.sign(digest.getBytes(), null);
        String signBase64 = Base64.encode((byte[])sign);
        return signBase64;
    }

    public static String sm4Decrypt(String sm4Key, String data) {
        SM4 sm4 = SmUtil.sm4((byte[])Base64.decode((CharSequence)sm4Key));
        String businessData = sm4.decryptStr(Base64.decode((CharSequence)data));
        return businessData;
    }

    public static String sm3Hash(String plainText) {
        String salt = "6MCQ4zOruHugYvcAS3G+OKd7dtv1seAkI3QMMLvx1G0D/tc67jJfOO+DePMVjGvP1DkdGuDjwMtet4ws1zMRFQ==";
        String digest = SmUtil.sm3WithSalt((byte[])salt.getBytes()).digestHex(plainText);
        return digest;
    }

    public static void verifySign(String sm2PublicKey, String plainText, String sign) {
        String digest = SmUtil.sm3((String)plainText);
        SM2 sm2 = new SM2(null, Base64.decode((CharSequence)sm2PublicKey));
        sm2.usePlainEncoding();
        Assert.isTrue((boolean)sm2.verify(digest.getBytes(), Base64.decode((CharSequence)sign)), (String)"\u7b7e\u540d\u6821\u9a8c\u5931\u8d25", (Object[])new Object[0]);
    }

    private static boolean isValidTimestamp(String timestamp, long serverTimeDiff) {
        long currentServerTime = System.currentTimeMillis() + serverTimeDiff;
        return Math.abs(currentServerTime - Long.parseLong(timestamp)) <= 300000L;
    }

    public static void main(String[] args) {
        String s = OpenAPIEncryptUtil.sm3Hash("SMF-58E1E805E052ED3AC70E558DB84F248E");
        System.out.println(s);
    }
}

