/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.spring;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.annotation.LiteflowMethod;
import com.yomahub.liteflow.core.proxy.DeclWarpBean;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.spi.holder.DeclComponentParserHolder;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;

public class DeclBeanDefinition
implements BeanDefinitionRegistryPostProcessor {
    private final LFLog LOG = LFLoggerManager.getLogger(this.getClass());

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)registry;
        String[] beanDefinitionNames = defaultListableBeanFactory.getBeanDefinitionNames();
        Arrays.stream(beanDefinitionNames).map(beanName -> this.combineAsTriple((String)beanName, defaultListableBeanFactory)).filter(this::hasLiteflowMethodAnnotation).forEach(triple -> this.splitAndRegisterNewBeanDefinition((Triple<String, BeanDefinition, Class<?>>)triple, defaultListableBeanFactory));
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    private Triple<String, BeanDefinition, Class<?>> combineAsTriple(String beanName, DefaultListableBeanFactory defaultListableBeanFactory) {
        BeanDefinition beanDefinition = defaultListableBeanFactory.getMergedBeanDefinition(beanName);
        Class<?> rawClass = this.getRawClassFromBeanDefinition(beanDefinition);
        return Triple.of((Object)beanName, (Object)beanDefinition, rawClass);
    }

    private boolean hasLiteflowMethodAnnotation(Triple<String, BeanDefinition, Class<?>> triple) {
        Class rawClass = (Class)triple.getRight();
        return rawClass != null && Arrays.stream(rawClass.getMethods()).anyMatch(method -> AnnotationUtil.hasAnnotation((AnnotatedElement)method, LiteflowMethod.class));
    }

    private void splitAndRegisterNewBeanDefinition(Triple<String, BeanDefinition, Class<?>> triple, DefaultListableBeanFactory defaultListableBeanFactory) {
        BeanDefinition beanDefinition = (BeanDefinition)triple.getMiddle();
        Class rawClass = (Class)triple.getRight();
        DeclComponentParserHolder.loadDeclComponentParser().parseDeclBean(rawClass).forEach(declWarpBean -> this.registerNewBeanDefinition((DeclWarpBean)declWarpBean, beanDefinition, defaultListableBeanFactory));
    }

    private void registerNewBeanDefinition(DeclWarpBean declWarpBean, BeanDefinition beanDefinition, DefaultListableBeanFactory defaultListableBeanFactory) {
        GenericBeanDefinition newBeanDefinition = new GenericBeanDefinition();
        newBeanDefinition.setBeanClass(DeclWarpBean.class);
        newBeanDefinition.setScope("singleton");
        MutablePropertyValues mutablePropertyValues = new MutablePropertyValues();
        mutablePropertyValues.add("nodeId", (Object)declWarpBean.getNodeId());
        mutablePropertyValues.add("nodeName", (Object)declWarpBean.getNodeName());
        mutablePropertyValues.add("nodeType", (Object)declWarpBean.getNodeType());
        mutablePropertyValues.add("rawClazz", (Object)declWarpBean.getRawClazz());
        mutablePropertyValues.add("methodWrapBeanList", (Object)declWarpBean.getMethodWrapBeanList());
        mutablePropertyValues.add("rawBean", (Object)beanDefinition);
        newBeanDefinition.setPropertyValues(mutablePropertyValues);
        defaultListableBeanFactory.setAllowBeanDefinitionOverriding(true);
        defaultListableBeanFactory.registerBeanDefinition(declWarpBean.getNodeId(), (BeanDefinition)newBeanDefinition);
    }

    private Class<?> getRawClassFromBeanDefinition(BeanDefinition beanDefinition) {
        try {
            Class<?> res = null;
            Method method = ReflectUtil.getMethodByName(DeclBeanDefinition.class, (String)"getResolvableType");
            if (method != null) {
                Object resolvableType = ReflectUtil.invoke((Object)beanDefinition, (Method)method, (Object[])new Object[0]);
                res = (Class)ReflectUtil.invoke((Object)resolvableType, (String)"getRawClass", (Object[])new Object[0]);
            }
            if (res != null) {
                return res;
            }
            res = (Class<?>)ReflectUtil.invoke((Object)beanDefinition, (String)"getTargetType", (Object[])new Object[0]);
            if (res != null) {
                return res;
            }
            String beanClassName = beanDefinition.getBeanClassName();
            if (StrUtil.isNotBlank((CharSequence)beanClassName)) {
                try {
                    res = Class.forName(beanClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return res;
        }
        catch (Exception e) {
            this.LOG.error("An error occurred while obtaining the rawClass.", (Throwable)e);
            return null;
        }
    }
}

