/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.input.structured;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.reflect.TypeToken;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.input.structured.StructuredPrompt;
import dev.langchain4j.spi.prompt.structured.StructuredPromptFactory;
import java.util.Map;

public class DefaultStructuredPromptFactory
implements StructuredPromptFactory {
    private static final Gson GSON = new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create();

    @Override
    public Prompt toPrompt(Object structuredPrompt) {
        this.validate(structuredPrompt);
        StructuredPrompt annotation = structuredPrompt.getClass().getAnnotation(StructuredPrompt.class);
        String promptTemplateString = String.join((CharSequence)annotation.delimiter(), annotation.value());
        PromptTemplate promptTemplate = PromptTemplate.from(promptTemplateString);
        Map<String, Object> variables = DefaultStructuredPromptFactory.extractVariables(structuredPrompt);
        return promptTemplate.apply(variables);
    }

    private void validate(Object structuredPrompt) {
        if (structuredPrompt == null) {
            throw new IllegalArgumentException("Structured prompt cannot be null");
        }
        String structuredPromptClassName = structuredPrompt.getClass().getName();
        StructuredPrompt structuredPromptAnnotation = structuredPrompt.getClass().getAnnotation(StructuredPrompt.class);
        if (structuredPromptAnnotation == null) {
            throw new IllegalArgumentException(String.format("%s should be annotated with @StructuredPrompt to be used as a structured prompt", structuredPromptClassName));
        }
    }

    private static Map<String, Object> extractVariables(Object structuredPrompt) {
        String json = GSON.toJson(structuredPrompt);
        TypeToken<Map<String, Object>> mapType = new TypeToken<Map<String, Object>>(){};
        return (Map)GSON.fromJson(json, (TypeToken)mapType);
    }
}

