/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.language.StreamingLanguageModel;
import dev.langchain4j.model.ollama.CompletionRequest;
import dev.langchain4j.model.ollama.OllamaClient;
import dev.langchain4j.model.ollama.Options;
import java.time.Duration;

public class OllamaStreamingLanguageModel
implements StreamingLanguageModel {
    private final OllamaClient client;
    private final String modelName;
    private final Double temperature;

    public OllamaStreamingLanguageModel(String baseUrl, Duration timeout, String modelName, Double temperature) {
        this.client = OllamaClient.builder().baseUrl(baseUrl).timeout(timeout).build();
        this.modelName = modelName;
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)0.7);
    }

    public void generate(String prompt, StreamingResponseHandler<String> handler) {
        CompletionRequest request = CompletionRequest.builder().model(this.modelName).prompt(prompt).options(Options.builder().temperature(this.temperature).build()).stream(true).build();
        this.client.streamingCompletion(request, handler);
    }

    public static OllamaStreamingLanguageModelBuilder builder() {
        return new OllamaStreamingLanguageModelBuilder();
    }

    public static class OllamaStreamingLanguageModelBuilder {
        private String baseUrl;
        private Duration timeout;
        private String modelName;
        private Double temperature;

        OllamaStreamingLanguageModelBuilder() {
        }

        public OllamaStreamingLanguageModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OllamaStreamingLanguageModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OllamaStreamingLanguageModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OllamaStreamingLanguageModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public OllamaStreamingLanguageModel build() {
            return new OllamaStreamingLanguageModel(this.baseUrl, this.timeout, this.modelName, this.temperature);
        }

        public String toString() {
            return "OllamaStreamingLanguageModel.OllamaStreamingLanguageModelBuilder(baseUrl=" + this.baseUrl + ", timeout=" + this.timeout + ", modelName=" + this.modelName + ", temperature=" + this.temperature + ")";
        }
    }
}

