/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai.internal.chat;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import dev.langchain4j.model.openai.internal.chat.FunctionCall;
import dev.langchain4j.model.openai.internal.chat.Message;
import dev.langchain4j.model.openai.internal.chat.Role;
import dev.langchain4j.model.openai.internal.chat.ToolCall;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public final class AssistantMessage
implements Message {
    @JsonProperty
    private final Role role = Role.ASSISTANT;
    @JsonProperty
    private final String content;
    @JsonProperty
    private final String reasoningContent;
    @JsonProperty
    private final String name;
    @JsonProperty
    private final List<ToolCall> toolCalls;
    @JsonProperty
    private final String refusal;
    @JsonProperty
    @Deprecated
    private final FunctionCall functionCall;

    public AssistantMessage(Builder builder) {
        this.content = builder.content;
        this.reasoningContent = builder.reasoningContent;
        this.name = builder.name;
        this.toolCalls = builder.toolCalls;
        this.refusal = builder.refusal;
        this.functionCall = builder.functionCall;
    }

    @Override
    public Role role() {
        return this.role;
    }

    public String content() {
        return this.content;
    }

    public String reasoningContent() {
        return this.reasoningContent;
    }

    public String name() {
        return this.name;
    }

    public List<ToolCall> toolCalls() {
        return this.toolCalls;
    }

    public String refusal() {
        return this.refusal;
    }

    @Deprecated
    public FunctionCall functionCall() {
        return this.functionCall;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AssistantMessage && this.equalTo((AssistantMessage)another);
    }

    private boolean equalTo(AssistantMessage another) {
        return Objects.equals((Object)this.role, (Object)another.role) && Objects.equals(this.content, another.content) && Objects.equals(this.reasoningContent, another.reasoningContent) && Objects.equals(this.name, another.name) && Objects.equals(this.toolCalls, another.toolCalls) && Objects.equals(this.refusal, another.refusal) && Objects.equals(this.functionCall, another.functionCall);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.role);
        h += (h << 5) + Objects.hashCode(this.content);
        h += (h << 5) + Objects.hashCode(this.reasoningContent);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.toolCalls);
        h += (h << 5) + Objects.hashCode(this.refusal);
        h += (h << 5) + Objects.hashCode(this.functionCall);
        return h;
    }

    public String toString() {
        return "AssistantMessage{role=" + String.valueOf((Object)this.role) + ", content=" + this.content + ", reasoningContent=" + this.reasoningContent + ", name=" + this.name + ", toolCalls=" + String.valueOf(this.toolCalls) + ", refusal=" + this.refusal + ", functionCall=" + String.valueOf(this.functionCall) + "}";
    }

    public static AssistantMessage from(String content) {
        return AssistantMessage.builder().content(content).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static final class Builder {
        private String content;
        private String reasoningContent;
        private String name;
        private List<ToolCall> toolCalls;
        private String refusal;
        @Deprecated
        private FunctionCall functionCall;

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder reasoningContent(String reasoningContent) {
            this.reasoningContent = reasoningContent;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @JsonSetter
        public Builder toolCalls(List<ToolCall> toolCalls) {
            if (toolCalls != null) {
                this.toolCalls = Collections.unmodifiableList(toolCalls);
            }
            return this;
        }

        @JsonIgnore
        public Builder toolCalls(ToolCall ... toolCalls) {
            return this.toolCalls(Arrays.asList(toolCalls));
        }

        public Builder refusal(String refusal) {
            this.refusal = refusal;
            return this;
        }

        @Deprecated
        public Builder functionCall(FunctionCall functionCall) {
            this.functionCall = functionCall;
            return this;
        }

        public AssistantMessage build() {
            return new AssistantMessage(this);
        }
    }
}

