/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic;

import io.lettuce.core.dynamic.support.ClassTypeInformation;
import io.lettuce.core.dynamic.support.TypeInformation;
import io.lettuce.core.internal.LettuceAssert;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

class ConversionService {
    private Map<ConvertiblePair, Function<?, ?>> converterMap = new HashMap(10);

    ConversionService() {
    }

    public void addConverter(Function<?, ?> converter) {
        LettuceAssert.notNull(converter, "Converter must not be null");
        ClassTypeInformation<?> classTypeInformation = ClassTypeInformation.from(converter.getClass());
        TypeInformation typeInformation = classTypeInformation.getSuperTypeInformation((Class)Function.class);
        List<TypeInformation<?>> typeArguments = typeInformation.getTypeArguments();
        ConvertiblePair pair = new ConvertiblePair(typeArguments.get(0).getType(), typeArguments.get(1).getType());
        this.converterMap.put(pair, converter);
    }

    public <S, T> T convert(S source, Class<T> targetType) {
        LettuceAssert.notNull(source, "Source must not be null");
        return (T)this.getConverter(source.getClass(), targetType).apply(source);
    }

    public <S, T> boolean canConvert(Class<S> sourceType, Class<T> targetType) {
        return this.findConverter(sourceType, targetType).isPresent();
    }

    Function<Object, Object> getConverter(Class<?> source, Class<?> target) {
        return this.findConverter(source, target).orElseThrow(() -> new IllegalArgumentException(String.format("No converter found for %s to %s conversion", source.getName(), target.getName())));
    }

    private Optional<Function<Object, Object>> findConverter(Class<?> source, Class<?> target) {
        LettuceAssert.notNull(source, "Source type must not be null");
        LettuceAssert.notNull(target, "Target type must not be null");
        for (ConvertiblePair pair : this.converterMap.keySet()) {
            if (!pair.getSourceType().isAssignableFrom(source) || !target.isAssignableFrom(pair.getTargetType())) continue;
            return Optional.of(this.converterMap.get(pair));
        }
        return Optional.empty();
    }

    final class ConvertiblePair {
        private final Class<?> sourceType;
        private final Class<?> targetType;

        public ConvertiblePair(Class<?> sourceType, Class<?> targetType) {
            LettuceAssert.notNull(sourceType, "Source type must not be null");
            LettuceAssert.notNull(targetType, "Target type must not be null");
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        public Class<?> getSourceType() {
            return this.sourceType;
        }

        public Class<?> getTargetType() {
            return this.targetType;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || other.getClass() != ConvertiblePair.class) {
                return false;
            }
            ConvertiblePair otherPair = (ConvertiblePair)other;
            return this.sourceType == otherPair.sourceType && this.targetType == otherPair.targetType;
        }

        public int hashCode() {
            return this.sourceType.hashCode() * 31 + this.targetType.hashCode();
        }

        public String toString() {
            return this.sourceType.getName() + " -> " + this.targetType.getName();
        }
    }
}

