/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.partition;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class ReleasePartitionsParam {
    private final String collectionName;
    private final List<String> partitionNames;

    private ReleasePartitionsParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.partitionNames = builder.partitionNames;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "ReleasePartitionsParam{collectionName='" + this.collectionName + '\'' + ", partitionNames='" + this.partitionNames.toString() + '\'' + '}';
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public static final class Builder {
        private String collectionName;
        private final List<String> partitionNames = new ArrayList<String>();

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionNames(@NonNull List<String> partitionNames) {
            if (partitionNames == null) {
                throw new NullPointerException("partitionNames is marked non-null but is null");
            }
            partitionNames.forEach(this::addPartitionName);
            return this;
        }

        public Builder addPartitionName(@NonNull String partitionName) {
            if (partitionName == null) {
                throw new NullPointerException("partitionName is marked non-null but is null");
            }
            if (!this.partitionNames.contains(partitionName)) {
                this.partitionNames.add(partitionName);
            }
            return this;
        }

        public ReleasePartitionsParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (this.partitionNames.isEmpty()) {
                throw new ParamException("Partition names cannot be empty");
            }
            for (String name : this.partitionNames) {
                ParamUtils.CheckNullEmptyString(name, "Partition name");
            }
            return new ReleasePartitionsParam(this);
        }
    }
}

