/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response;

import com.alibaba.fastjson.JSONObject;
import io.milvus.exception.ParamException;
import io.milvus.grpc.FieldData;
import io.milvus.grpc.QueryResults;
import io.milvus.response.FieldDataWrapper;
import io.milvus.response.basic.RowRecordWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class QueryResultsWrapper
extends RowRecordWrapper {
    private final QueryResults results;

    public QueryResultsWrapper(@NonNull QueryResults results) {
        if (results == null) {
            throw new NullPointerException("results is marked non-null but is null");
        }
        this.results = results;
    }

    public FieldDataWrapper getFieldWrapper(@NonNull String fieldName) throws ParamException {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        List<FieldData> fields = this.results.getFieldsDataList();
        for (FieldData field : fields) {
            if (fieldName.compareTo(field.getFieldName()) != 0) continue;
            return new FieldDataWrapper(field);
        }
        throw new ParamException("The field name doesn't exist");
    }

    @Override
    public List<RowRecord> getRowRecords() {
        long rowCount = this.getRowCount();
        ArrayList<RowRecord> records = new ArrayList<RowRecord>();
        for (long i = 0L; i < rowCount; ++i) {
            RowRecord record = this.buildRowRecord(i);
            records.add(record);
        }
        return records;
    }

    protected RowRecord buildRowRecord(long index) {
        RowRecord record = new RowRecord();
        this.buildRowRecord(record, index);
        return record;
    }

    public long getRowCount() {
        List<FieldData> fields = this.results.getFieldsDataList();
        Iterator<FieldData> iterator = fields.iterator();
        if (iterator.hasNext()) {
            FieldData field = iterator.next();
            FieldDataWrapper wrapper = new FieldDataWrapper(field);
            return wrapper.getRowCount();
        }
        return 0L;
    }

    @Override
    protected List<FieldData> getFieldDataList() {
        return this.results.getFieldsDataList();
    }

    @Override
    protected List<String> getOutputFields() {
        return this.results.getOutputFieldsList();
    }

    public static final class RowRecord {
        Map<String, Object> fieldValues = new HashMap<String, Object>();

        public boolean put(String keyName, Object obj) {
            if (this.fieldValues.containsKey(keyName)) {
                return false;
            }
            this.fieldValues.put(keyName, obj);
            return true;
        }

        public Object get(String keyName) throws ParamException {
            if (this.fieldValues.isEmpty()) {
                throw new ParamException("This record is empty");
            }
            Object obj = this.fieldValues.get(keyName);
            if (obj == null) {
                JSONObject jsonMata;
                Object innerObj;
                Object meta = this.fieldValues.get("$meta");
                if (meta != null && (innerObj = (jsonMata = (JSONObject)meta).get((Object)keyName)) != null) {
                    return innerObj;
                }
                throw new ParamException("The key name is not found");
            }
            return obj;
        }

        public String toString() {
            ArrayList pairs = new ArrayList();
            this.fieldValues.forEach((keyName, fieldValue) -> pairs.add(keyName + ":" + fieldValue.toString()));
            return ((Object)pairs).toString();
        }

        public Map<String, Object> getFieldValues() {
            return this.fieldValues;
        }
    }
}

