/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.brpc;

import com.baidu.brpc.interceptor.AbstractInterceptor;
import com.baidu.brpc.interceptor.InterceptorChain;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import io.seata.integration.rpc.core.ConsumerRpcFilter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionPropagationClientInterceptor
extends AbstractInterceptor
implements ConsumerRpcFilter<Request> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionPropagationClientInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aroundProcess(Request brpcRequest, Response brpcResponse, InterceptorChain chain) throws Exception {
        Map rootContexts = this.getRootContexts();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SEATA-BRPC context:{}", (Object)this.getJsonContext(rootContexts));
        }
        if (null != this.getXidFromRootContexts(rootContexts)) {
            this.bindContextsToRequest(brpcRequest, rootContexts);
        }
        try {
            chain.intercept(brpcRequest, brpcResponse);
        }
        finally {
            this.cleanRequestContexts(brpcRequest, rootContexts);
        }
    }

    @Override
    public void bindContextToRequest(Request rpcRequest, String key, String value) {
        HashMap<String, String> kvAttachment = rpcRequest.getKvAttachment();
        if (null == kvAttachment) {
            kvAttachment = new HashMap<String, String>();
            rpcRequest.setKvAttachment(kvAttachment);
        }
        kvAttachment.put(key, value);
    }

    @Override
    public void cleanRequestContext(Request rpcRequest, String key) {
        Map requestAttachment = rpcRequest.getKvAttachment();
        if (null != requestAttachment) {
            requestAttachment.remove(key);
        }
    }
}

