/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.tx.api.interceptor.parser;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.CollectionUtils;
import io.seata.integration.tx.api.interceptor.handler.ProxyInvocationHandler;
import io.seata.integration.tx.api.interceptor.parser.InterfaceParser;
import java.util.ArrayList;
import java.util.List;

public class DefaultInterfaceParser
implements InterfaceParser {
    protected static final List<InterfaceParser> ALL_INTERFACE_PARSERS = new ArrayList<InterfaceParser>();

    public static DefaultInterfaceParser get() {
        return SingletonHolder.INSTANCE;
    }

    protected DefaultInterfaceParser() {
        this.initInterfaceParser();
    }

    protected void initInterfaceParser() {
        List<InterfaceParser> interfaceParsers = EnhancedServiceLoader.loadAll(InterfaceParser.class);
        if (CollectionUtils.isNotEmpty(interfaceParsers)) {
            ALL_INTERFACE_PARSERS.addAll(interfaceParsers);
        }
    }

    @Override
    public ProxyInvocationHandler parserInterfaceToProxy(Object target, String objectName) throws Exception {
        for (InterfaceParser interfaceParser : ALL_INTERFACE_PARSERS) {
            ProxyInvocationHandler proxyInvocationHandler = interfaceParser.parserInterfaceToProxy(target, objectName);
            if (proxyInvocationHandler == null) continue;
            return proxyInvocationHandler;
        }
        return null;
    }

    private static class SingletonHolder {
        private static final DefaultInterfaceParser INSTANCE = new DefaultInterfaceParser();

        private SingletonHolder() {
        }
    }
}

