/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl;

import com.alibaba.nacos.auth.config.AuthConfigs;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.io.DecodingException;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenManager {
    private static final String AUTHORITIES_KEY = "auth";
    private final AuthConfigs authConfigs;
    private String secretKey;
    private byte[] secretKeyBytes;
    private long tokenValidityInSeconds;
    private JwtParser jwtParser;

    public JwtTokenManager(AuthConfigs authConfigs) {
        this.authConfigs = authConfigs;
    }

    @PostConstruct
    public void initProperties() {
        Properties properties = this.authConfigs.getAuthPluginProperties("nacos");
        String validitySeconds = properties.getProperty("token.expire.seconds", "18000");
        this.tokenValidityInSeconds = Long.parseLong(validitySeconds);
        this.secretKey = properties.getProperty("token.secret.key", "");
    }

    public String createToken(Authentication authentication) {
        return this.createToken(authentication.getName());
    }

    public String createToken(String userName) {
        long now = System.currentTimeMillis();
        Date validity = new Date(now + this.getTokenValidityInSeconds() * 1000L);
        Claims claims = Jwts.claims().setSubject(userName);
        return Jwts.builder().setClaims(claims).setExpiration(validity).signWith((Key)Keys.hmacShaKeyFor((byte[])this.getSecretKeyBytes()), SignatureAlgorithm.HS256).compact();
    }

    public Authentication getAuthentication(String token) {
        if (this.jwtParser == null) {
            this.jwtParser = Jwts.parserBuilder().setSigningKey(this.getSecretKeyBytes()).build();
        }
        Claims claims = (Claims)this.jwtParser.parseClaimsJws(token).getBody();
        List authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)((String)claims.get((Object)AUTHORITIES_KEY)));
        User principal = new User(claims.getSubject(), "", (Collection)authorities);
        return new UsernamePasswordAuthenticationToken((Object)principal, (Object)"", (Collection)authorities);
    }

    public void validateToken(String token) {
        if (this.jwtParser == null) {
            this.jwtParser = Jwts.parserBuilder().setSigningKey(this.getSecretKeyBytes()).build();
        }
        this.jwtParser.parseClaimsJws(token);
    }

    public byte[] getSecretKeyBytes() {
        if (this.secretKeyBytes == null) {
            try {
                this.secretKeyBytes = (byte[])Decoders.BASE64.decode((Object)this.secretKey);
            }
            catch (DecodingException e) {
                this.secretKeyBytes = this.secretKey.getBytes(StandardCharsets.UTF_8);
            }
        }
        return this.secretKeyBytes;
    }

    public long getTokenValidityInSeconds() {
        return this.tokenValidityInSeconds;
    }
}

