/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.web;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ClassSupport;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Component
public class InMemorySwaggerResourcesProvider
implements SwaggerResourcesProvider {
    @Value(value="${springfox.documentation.swagger.v1.path:/api-docs}")
    private String swagger1Url;
    @Value(value="${springfox.documentation.swagger.v2.path:/v2/api-docs}")
    private String swagger2Url;
    private boolean swagger1Available = ClassSupport.classByName((String)"springfox.documentation.swagger1.web.Swagger1Controller").isPresent();
    private boolean swagger2Available = ClassSupport.classByName((String)"springfox.documentation.swagger2.web.Swagger2Controller").isPresent();
    private final DocumentationCache documentationCache;

    @Autowired
    public InMemorySwaggerResourcesProvider(DocumentationCache documentationCache) {
        this.documentationCache = documentationCache;
    }

    public List<SwaggerResource> get() {
        ArrayList<SwaggerResource> resources = new ArrayList<SwaggerResource>();
        for (Map.Entry entry : this.documentationCache.all().entrySet()) {
            SwaggerResource swaggerResource;
            String swaggerGroup = (String)entry.getKey();
            if (this.swagger1Available) {
                swaggerResource = this.resource(swaggerGroup, this.swagger1Url);
                swaggerResource.setSwaggerVersion("1.2");
                resources.add(swaggerResource);
            }
            if (!this.swagger2Available) continue;
            swaggerResource = this.resource(swaggerGroup, this.swagger2Url);
            swaggerResource.setSwaggerVersion("2.0");
            resources.add(swaggerResource);
        }
        Collections.sort(resources);
        return resources;
    }

    private SwaggerResource resource(String swaggerGroup, String baseUrl) {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(swaggerGroup);
        swaggerResource.setLocation(this.swaggerLocation(baseUrl, swaggerGroup));
        return swaggerResource;
    }

    private String swaggerLocation(String swaggerUrl, String swaggerGroup) {
        String base = (String)Optional.of((Object)swaggerUrl).get();
        if ("default".equals(swaggerGroup)) {
            return base;
        }
        return base + "?group=" + swaggerGroup;
    }
}

